/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaMetamodelEntityInformation<T, ID extends Serializable>
extends JpaEntityInformationSupport<T, ID>
implements JpaEntityInformation<T, ID> {
    private final SingularAttribute<? super T, ?> attribute;

    public JpaMetamodelEntityInformation(Class<T> domainClass, Metamodel metamodel) {
        super(domainClass);
        Assert.notNull((Object)metamodel);
        EntityType type = metamodel.entity(domainClass);
        if (type == null) {
            throw new IllegalArgumentException("The given domain class can not be found in the given Metamodel!");
        }
        this.attribute = type.getId(type.getIdType().getJavaType());
    }

    public ID getId(T entity) {
        return (ID)((Serializable)JpaMetamodelEntityInformation.getMemberValue(this.attribute.getJavaMember(), entity));
    }

    public Class<ID> getIdType() {
        return this.attribute.getJavaType();
    }

    private static Object getMemberValue(Member member, Object source) {
        if (member instanceof Field) {
            Field field = (Field)member;
            ReflectionUtils.makeAccessible((Field)field);
            return ReflectionUtils.getField((Field)field, (Object)source);
        }
        if (member instanceof Method) {
            Method method = (Method)member;
            ReflectionUtils.makeAccessible((Method)method);
            return ReflectionUtils.invokeMethod((Method)method, (Object)source);
        }
        throw new IllegalArgumentException("Given member is neither Field nor Method!");
    }

    @Override
    public SingularAttribute<? super T, ?> getIdAttribute() {
        return this.attribute;
    }
}

