/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import com.mysema.query.dml.DeleteClause;
import com.mysema.query.dml.UpdateClause;
import com.mysema.query.jpa.JPQLQuery;
import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPAUpdateClause;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.path.PathBuilder;
import com.mysema.query.types.path.PathBuilderFactory;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public abstract class QueryDslRepositorySupport {
    @PersistenceContext
    private EntityManager entityManager;
    private PathBuilderFactory builderFactory = new PathBuilderFactory();

    public void setEntityManager(EntityManager entityManager) {
        Assert.notNull((Object)entityManager);
        this.entityManager = entityManager;
    }

    @PostConstruct
    public void validate() {
        Assert.notNull((Object)this.entityManager, (String)"EntityManager must not be null!");
    }

    protected JPQLQuery from(EntityPath<?> ... paths) {
        return (JPQLQuery)new JPAQuery(this.entityManager).from(paths);
    }

    protected DeleteClause<JPADeleteClause> delete(EntityPath<?> path) {
        return new JPADeleteClause(this.entityManager, path);
    }

    protected UpdateClause<JPAUpdateClause> update(EntityPath<?> path) {
        return new JPAUpdateClause(this.entityManager, path);
    }

    protected <T> PathBuilder<T> getBuilder(Class<T> type) {
        return this.builderFactory.create(type);
    }
}

