/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain.support;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.util.Assert;

@Configurable
public class AuditingEntityListener {
    private ObjectFactory<AuditingHandler> handler;

    public void setAuditingHandler(ObjectFactory<AuditingHandler> auditingHandler) {
        Assert.notNull(auditingHandler, (String)"AuditingHandler must not be null!");
        this.handler = auditingHandler;
    }

    @PrePersist
    public void touchForCreate(Object target) {
        if (this.handler != null) {
            ((AuditingHandler)this.handler.getObject()).markCreated(target);
        }
    }

    @PreUpdate
    public void touchForUpdate(Object target) {
        if (this.handler != null) {
            ((AuditingHandler)this.handler.getObject()).markModified(target);
        }
    }
}

