/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class StringQuery {
    private static final Pattern LIKE_PATTERN;
    private static final String MESSAGE = "Already found like binding with same index / parameter name but differing binding type! Already have: %s, found %s! If you bind a parameter multiple times make sure they use the same like binding.";
    private final String query;
    private final List<LikeBinding> bindings;
    private final String alias;

    public StringQuery(String query) {
        Assert.hasText((String)query, (String)"Query must not be null or empty!");
        this.bindings = new ArrayList<LikeBinding>();
        this.query = this.parseLikeBindings(query);
        this.alias = QueryUtils.detectAlias(query);
    }

    public boolean hasLikeBindings() {
        return !this.bindings.isEmpty();
    }

    List<LikeBinding> getLikeBindings() {
        return this.bindings;
    }

    public String getQuery() {
        return this.query;
    }

    public String getAlias() {
        return this.alias;
    }

    public LikeBinding getBindingFor(String name) {
        for (LikeBinding binding : this.bindings) {
            if (!binding.hasName(name)) continue;
            return binding;
        }
        return null;
    }

    public LikeBinding getBindingFor(int position) {
        for (LikeBinding binding : this.bindings) {
            if (!binding.hasPosition(position)) continue;
            return binding;
        }
        return null;
    }

    private final String parseLikeBindings(String query) {
        Matcher matcher = LIKE_PATTERN.matcher(query);
        String result = query;
        while (matcher.find()) {
            Part.Type likeType = StringQuery.getLikeTypeFrom(matcher.group(1));
            String index = matcher.group(3);
            String replacement = matcher.group(2);
            if (index != null) {
                this.checkAndRegister(new LikeBinding(Integer.parseInt(index), likeType));
            } else {
                this.checkAndRegister(new LikeBinding(matcher.group(5), likeType));
                replacement = matcher.group(4);
            }
            result = StringUtils.replace((String)result, (String)matcher.group(1), (String)replacement);
        }
        return result;
    }

    private final void checkAndRegister(LikeBinding binding) {
        for (LikeBinding existing : this.bindings) {
            if (!existing.hasName(binding.name) && !existing.hasPosition(binding.position)) continue;
            Assert.isTrue((boolean)existing.equals(binding), (String)String.format(MESSAGE, existing, binding));
        }
        this.bindings.add(binding);
    }

    private static Part.Type getLikeTypeFrom(String expression) {
        Assert.hasText((String)expression);
        if (expression.matches("%.*%")) {
            return Part.Type.CONTAINING;
        }
        if (expression.startsWith("%")) {
            return Part.Type.ENDING_WITH;
        }
        if (expression.endsWith("%")) {
            return Part.Type.STARTING_WITH;
        }
        return Part.Type.LIKE;
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.append("(?<=like)");
        builder.append("(?: )+");
        builder.append("(");
        builder.append("%?(\\?(\\d+))%?");
        builder.append("|");
        builder.append("%?(:(\\w+))%?");
        builder.append(")");
        LIKE_PATTERN = Pattern.compile(builder.toString(), 2);
    }

    static class LikeBinding {
        private static final List<Part.Type> SUPPORTED_TYPES = Arrays.asList(Part.Type.CONTAINING, Part.Type.STARTING_WITH, Part.Type.ENDING_WITH, Part.Type.LIKE);
        private final String name;
        private final Integer position;
        private final Part.Type type;

        public LikeBinding(String name, Part.Type type) {
            Assert.hasText((String)name, (String)"Name must not be null or empty!");
            Assert.notNull((Object)type, (String)"Type must not be null!");
            Assert.isTrue((boolean)SUPPORTED_TYPES.contains(type), (String)String.format("Type must be one of %s!", StringUtils.collectionToCommaDelimitedString(SUPPORTED_TYPES)));
            this.name = name;
            this.type = type;
            this.position = null;
        }

        public LikeBinding(int position, Part.Type type) {
            Assert.isTrue((position > 0 ? 1 : 0) != 0, (String)"Position must be greater than zero!");
            Assert.notNull((Object)type, (String)"Type must not be null!");
            this.position = position;
            this.type = type;
            this.name = null;
        }

        public boolean hasName(String name) {
            return this.position == null && this.name != null && this.name.equals(name);
        }

        public boolean hasPosition(Integer position) {
            return position != null && this.name == null && this.position == position;
        }

        public Part.Type getType() {
            return this.type;
        }

        public Object prepare(Object value) {
            if (value == null) {
                return value;
            }
            switch (this.type) {
                case STARTING_WITH: {
                    return String.format("%s%%", value.toString());
                }
                case ENDING_WITH: {
                    return String.format("%%%s", value.toString());
                }
                case CONTAINING: {
                    return String.format("%%%s%%", value.toString());
                }
            }
            return value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LikeBinding)) {
                return false;
            }
            LikeBinding that = (LikeBinding)obj;
            return ObjectUtils.nullSafeEquals((Object)this.name, (Object)that.name) && ObjectUtils.nullSafeEquals((Object)this.position, (Object)that.position) && this.type.equals((Object)that.type);
        }

        public int hashCode() {
            int result = 17;
            result += ObjectUtils.nullSafeHashCode((Object)this.name);
            result += ObjectUtils.nullSafeHashCode((Object)this.position);
            return result += ObjectUtils.nullSafeHashCode((Object)this.type);
        }

        public String toString() {
            return String.format("LikeBinding [name: %s, position: %d, type: %s]", this.name, this.position, this.type);
        }
    }
}

