/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.NativeJpaQuery;
import org.springframework.data.jpa.repository.query.SimpleJpaQuery;
import org.springframework.data.jpa.repository.query.StoredProcedureJpaQuery;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;

enum JpaQueryFactory {
    INSTANCE;

    private static final SpelExpressionParser PARSER;
    private static final Logger LOG;

    @Nullable
    AbstractJpaQuery fromQueryAnnotation(JpaQueryMethod method, EntityManager em, EvaluationContextProvider evaluationContextProvider) {
        LOG.debug("Looking up query for method {}", (Object)method.getName());
        return this.fromMethodWithQueryString(method, em, method.getAnnotatedQuery(), evaluationContextProvider);
    }

    @Nullable
    AbstractJpaQuery fromMethodWithQueryString(JpaQueryMethod method, EntityManager em, @Nullable String queryString, EvaluationContextProvider evaluationContextProvider) {
        if (queryString == null) {
            return null;
        }
        return method.isNativeQuery() ? new NativeJpaQuery(method, em, queryString, evaluationContextProvider, PARSER) : new SimpleJpaQuery(method, em, queryString, evaluationContextProvider, PARSER);
    }

    @Nullable
    public StoredProcedureJpaQuery fromProcedureAnnotation(JpaQueryMethod method, EntityManager em) {
        if (!method.isProcedureQuery()) {
            return null;
        }
        return new StoredProcedureJpaQuery(method, em);
    }

    static {
        PARSER = new SpelExpressionParser();
        LOG = LoggerFactory.getLogger(JpaQueryFactory.class);
    }
}

