/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.ExpressionBasedStringQuery;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

abstract class AbstractStringBasedJpaQuery
extends AbstractJpaQuery {
    private final DeclaredQuery query;
    private final DeclaredQuery countQuery;
    private final EvaluationContextProvider evaluationContextProvider;
    private final SpelExpressionParser parser;

    public AbstractStringBasedJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, EvaluationContextProvider evaluationContextProvider, SpelExpressionParser parser) {
        super(method, em);
        Assert.hasText((String)queryString, (String)"Query string must not be null or empty!");
        Assert.notNull((Object)evaluationContextProvider, (String)"ExpressionEvaluationContextProvider must not be null!");
        Assert.notNull((Object)parser, (String)"Parser must not be null or empty!");
        this.evaluationContextProvider = evaluationContextProvider;
        this.query = new ExpressionBasedStringQuery(queryString, (JpaEntityMetadata<?>)method.getEntityInformation(), parser);
        this.countQuery = this.query.deriveCountQuery(method.getCountQuery(), method.getCountQueryProjection());
        this.parser = parser;
        Assert.isTrue((method.isNativeQuery() || !this.query.usesJdbcStyleParameters() ? 1 : 0) != 0, (String)"JDBC style parameters (?) are not supported for JPA queries.");
    }

    @Override
    public Query doCreateQuery(Object[] values) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor((Parameters)this.getQueryMethod().getParameters(), values);
        String sortedQueryString = QueryUtils.applySorting(this.query.getQueryString(), accessor.getSort(), this.query.getAlias());
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Query query = this.createJpaQuery(sortedQueryString, processor.getReturnedType());
        return ((ParameterBinder)this.parameterBinder.get()).bindAndPrepare(query, values);
    }

    @Override
    protected ParameterBinder createBinder() {
        return ParameterBinderFactory.createQueryAwareBinder(this.getQueryMethod().getParameters(), this.query, this.parser, this.evaluationContextProvider);
    }

    @Override
    protected Query doCreateCountQuery(Object[] values) {
        String queryString = this.countQuery.getQueryString();
        EntityManager em = this.getEntityManager();
        Query query = this.getQueryMethod().isNativeQuery() ? em.createNativeQuery(queryString) : em.createQuery(queryString, Long.class);
        return ((ParameterBinder)this.parameterBinder.get()).bind(query, values, QueryParameterSetter.ErrorHandling.LENIENT);
    }

    public DeclaredQuery getQuery() {
        return this.query;
    }

    public DeclaredQuery getCountQuery() {
        return this.countQuery;
    }

    protected Query createJpaQuery(String queryString, ReturnedType returnedType) {
        EntityManager em = this.getEntityManager();
        if (this.query.hasConstructorExpression() || this.query.isDefaultProjection()) {
            return em.createQuery(queryString);
        }
        return this.getTypeToRead(returnedType).map(it -> em.createQuery(queryString, it)).orElseGet(() -> em.createQuery(queryString));
    }
}

