/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DefaultQueryEnhancer;
import org.springframework.data.jpa.repository.query.JSqlParserQueryEnhancer;
import org.springframework.data.jpa.repository.query.JpaQueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.util.ClassUtils;

public final class QueryEnhancerFactory {
    private static final Log LOG = LogFactory.getLog(QueryEnhancerFactory.class);
    private static final boolean jSqlParserPresent = ClassUtils.isPresent((String)"net.sf.jsqlparser.parser.JSqlParser", (ClassLoader)QueryEnhancerFactory.class.getClassLoader());
    private static final boolean hibernatePresent = ClassUtils.isPresent((String)"org.hibernate.query.TypedParameterValue", (ClassLoader)QueryEnhancerFactory.class.getClassLoader());

    private QueryEnhancerFactory() {
    }

    public static QueryEnhancer forQuery(DeclaredQuery query) {
        if (query.isNativeQuery()) {
            if (jSqlParserPresent) {
                return new JSqlParserQueryEnhancer(query);
            }
            return new DefaultQueryEnhancer(query);
        }
        return hibernatePresent ? JpaQueryEnhancer.forHql(query) : JpaQueryEnhancer.forJpql(query);
    }

    static {
        if (jSqlParserPresent) {
            LOG.info((Object)"JSqlParser is in classpath; If applicable, JSqlParser will be used");
        }
        if (hibernatePresent) {
            LOG.info((Object)"Hibernate is in classpath; If applicable, HQL parser will be used.");
        }
    }
}

