/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.springframework.data.jpa.repository.query.HqlBaseVisitor;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.JpaQueryParsingToken;

class HqlQueryRenderer
extends HqlBaseVisitor<List<JpaQueryParsingToken>> {
    HqlQueryRenderer() {
    }

    @Override
    public List<JpaQueryParsingToken> visitStart(HqlParser.StartContext ctx) {
        return (List)this.visit((ParseTree)ctx.ql_statement());
    }

    @Override
    public List<JpaQueryParsingToken> visitQl_statement(HqlParser.Ql_statementContext ctx) {
        if (ctx.selectStatement() != null) {
            return (List)this.visit((ParseTree)ctx.selectStatement());
        }
        if (ctx.updateStatement() != null) {
            return (List)this.visit((ParseTree)ctx.updateStatement());
        }
        if (ctx.deleteStatement() != null) {
            return (List)this.visit((ParseTree)ctx.deleteStatement());
        }
        if (ctx.insertStatement() != null) {
            return (List)this.visit((ParseTree)ctx.insertStatement());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitSelectStatement(HqlParser.SelectStatementContext ctx) {
        return (List)this.visit((ParseTree)ctx.queryExpression());
    }

    @Override
    public List<JpaQueryParsingToken> visitQueryExpression(HqlParser.QueryExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.withClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.withClause()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.orderedQuery(0)));
        int i = 1;
        while (i < ctx.orderedQuery().size()) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.setOperator(i - 1)));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.orderedQuery(i)));
            ++i;
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitWithClause(HqlParser.WithClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_WITH);
        ctx.cte().forEach(cteContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)cteContext));
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCte(HqlParser.CteContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identifier()));
        tokens.add(JpaQueryParsingToken.TOKEN_AS);
        JpaQueryParsingToken.NOSPACE(tokens);
        if (ctx.NOT() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_NOT);
        }
        if (ctx.MATERIALIZED() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_MATERIALIZED);
        }
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.queryExpression()));
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        if (ctx.searchClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.searchClause()));
        }
        if (ctx.cycleClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.cycleClause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSearchClause(HqlParser.SearchClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.SEARCH().getText()));
        if (ctx.BREADTH() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.BREADTH().getText()));
        } else if (ctx.DEPTH() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.DEPTH().getText()));
        }
        tokens.add(new JpaQueryParsingToken(ctx.FIRST().getText()));
        tokens.add(new JpaQueryParsingToken(ctx.BY().getText()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.searchSpecifications()));
        tokens.add(new JpaQueryParsingToken(ctx.SET().getText()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identifier()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSearchSpecifications(HqlParser.SearchSpecificationsContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        ctx.searchSpecification().forEach(searchSpecificationContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)searchSpecificationContext));
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSearchSpecification(HqlParser.SearchSpecificationContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identifier()));
        if (ctx.sortDirection() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.sortDirection()));
        }
        if (ctx.nullsPrecedence() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.nullsPrecedence()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCycleClause(HqlParser.CycleClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.CYCLE().getText()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.cteAttributes()));
        tokens.add(new JpaQueryParsingToken(ctx.SET().getText()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identifier(0)));
        if (ctx.TO() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.TO().getText()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.literal(0)));
            tokens.add(new JpaQueryParsingToken(ctx.DEFAULT().getText()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.literal(1)));
        }
        if (ctx.USING() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.USING().getText()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identifier(1)));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCteAttributes(HqlParser.CteAttributesContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        ctx.identifier().forEach(identifierContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)identifierContext));
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitOrderedQuery(HqlParser.OrderedQueryContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.query() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.query()));
        } else if (ctx.queryExpression() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.queryExpression()));
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        if (ctx.queryOrder() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.queryOrder()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSelectQuery(HqlParser.SelectQueryContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.selectClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.selectClause()));
        }
        if (ctx.fromClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.fromClause()));
        }
        if (ctx.whereClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.whereClause()));
        }
        if (ctx.groupByClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (ctx.havingClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.havingClause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFromQuery(HqlParser.FromQueryContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.fromClause()));
        if (ctx.whereClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.whereClause()));
        }
        if (ctx.groupByClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.groupByClause()));
        }
        if (ctx.havingClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.havingClause()));
        }
        if (ctx.selectClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.selectClause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitQueryOrder(HqlParser.QueryOrderContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.orderByClause()));
        if (ctx.limitClause() != null) {
            JpaQueryParsingToken.SPACE(tokens);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.limitClause()));
        }
        if (ctx.offsetClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.offsetClause()));
        }
        if (ctx.fetchClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.fetchClause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFromClause(HqlParser.FromClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.FROM()));
        ctx.entityWithJoins().forEach(entityWithJoinsContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)entityWithJoinsContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitEntityWithJoins(HqlParser.EntityWithJoinsContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.fromRoot()));
        JpaQueryParsingToken.SPACE(tokens);
        ctx.joinSpecifier().forEach(joinSpecifierContext -> tokens.addAll((Collection)this.visit((ParseTree)joinSpecifierContext)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoinSpecifier(HqlParser.JoinSpecifierContext ctx) {
        if (ctx.join() != null) {
            return (List)this.visit((ParseTree)ctx.join());
        }
        if (ctx.crossJoin() != null) {
            return (List)this.visit((ParseTree)ctx.crossJoin());
        }
        if (ctx.jpaCollectionJoin() != null) {
            return (List)this.visit((ParseTree)ctx.jpaCollectionJoin());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitFromRoot(HqlParser.FromRootContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.entityName() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.entityName()));
            if (ctx.variable() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.variable()));
            }
            JpaQueryParsingToken.NOSPACE(tokens);
        } else if (ctx.subquery() != null) {
            if (ctx.LATERAL() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.LATERAL()));
            }
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
            if (ctx.variable() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.variable()));
            }
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoin(HqlParser.JoinContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.joinType()));
        tokens.add(new JpaQueryParsingToken(ctx.JOIN()));
        if (ctx.FETCH() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.FETCH()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.joinTarget()));
        if (ctx.joinRestriction() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.joinRestriction()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoinPath(HqlParser.JoinPathContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.path()));
        if (ctx.variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoinSubquery(HqlParser.JoinSubqueryContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.LATERAL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LATERAL()));
        }
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        if (ctx.variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitUpdateStatement(HqlParser.UpdateStatementContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.UPDATE()));
        if (ctx.VERSIONED() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.VERSIONED()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.targetEntity()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.setClause()));
        if (ctx.whereClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.whereClause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitTargetEntity(HqlParser.TargetEntityContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.entityName()));
        if (ctx.variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSetClause(HqlParser.SetClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.SET()));
        ctx.assignment().forEach(assignmentContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)assignmentContext));
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitAssignment(HqlParser.AssignmentContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.simplePath()));
        tokens.add(JpaQueryParsingToken.TOKEN_EQUALS);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expressionOrPredicate()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDeleteStatement(HqlParser.DeleteStatementContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.DELETE()));
        if (ctx.FROM() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.FROM()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.targetEntity()));
        if (ctx.whereClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.whereClause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitInsertStatement(HqlParser.InsertStatementContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.INSERT()));
        if (ctx.INTO() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.INTO()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.targetEntity()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.targetFields()));
        if (ctx.queryExpression() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.queryExpression()));
        } else if (ctx.valuesList() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.valuesList()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitTargetFields(HqlParser.TargetFieldsContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        ctx.simplePath().forEach(simplePathContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)simplePathContext));
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitValuesList(HqlParser.ValuesListContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.VALUES()));
        ctx.values().forEach(valuesContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)valuesContext));
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitValues(HqlParser.ValuesContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        ctx.expression().forEach(expressionContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)expressionContext));
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitInstantiation(HqlParser.InstantiationContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.NEW()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.instantiationTarget()));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.instantiationArguments()));
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitAlias(HqlParser.AliasContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.AS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identifier()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitGroupedItem(HqlParser.GroupedItemContext ctx) {
        if (ctx.identifier() != null) {
            return (List)this.visit((ParseTree)ctx.identifier());
        }
        if (ctx.INTEGER_LITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.INTEGER_LITERAL()));
        }
        if (ctx.expression() != null) {
            return (List)this.visit((ParseTree)ctx.expression());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitSortedItem(HqlParser.SortedItemContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.sortExpression()));
        if (ctx.sortDirection() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.sortDirection()));
        }
        if (ctx.nullsPrecedence() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.nullsPrecedence()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSortExpression(HqlParser.SortExpressionContext ctx) {
        if (ctx.identifier() != null) {
            return (List)this.visit((ParseTree)ctx.identifier());
        }
        if (ctx.INTEGER_LITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.INTEGER_LITERAL()));
        }
        if (ctx.expression() != null) {
            return (List)this.visit((ParseTree)ctx.expression());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitSortDirection(HqlParser.SortDirectionContext ctx) {
        if (ctx.ASC() != null) {
            return List.of(new JpaQueryParsingToken(ctx.ASC()));
        }
        if (ctx.DESC() != null) {
            return List.of(new JpaQueryParsingToken(ctx.DESC()));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitNullsPrecedence(HqlParser.NullsPrecedenceContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.NULLS()));
        if (ctx.FIRST() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.FIRST()));
        } else if (ctx.LAST() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LAST()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitLimitClause(HqlParser.LimitClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.LIMIT()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.parameterOrIntegerLiteral()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitOffsetClause(HqlParser.OffsetClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.OFFSET()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.parameterOrIntegerLiteral()));
        if (ctx.ROW() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ROW()));
        } else if (ctx.ROWS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ROWS()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFetchClause(HqlParser.FetchClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.FETCH()));
        if (ctx.FIRST() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.FIRST()));
        } else if (ctx.NEXT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NEXT()));
        }
        if (ctx.parameterOrIntegerLiteral() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.parameterOrIntegerLiteral()));
        } else if (ctx.parameterOrNumberLiteral() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.parameterOrNumberLiteral()));
            tokens.add(JpaQueryParsingToken.TOKEN_PERCENT);
        }
        if (ctx.ROW() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ROW()));
        } else if (ctx.ROWS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ROWS()));
        }
        if (ctx.ONLY() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ONLY()));
        } else if (ctx.WITH() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.WITH()));
            tokens.add(new JpaQueryParsingToken(ctx.TIES()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSubquery(HqlParser.SubqueryContext ctx) {
        return (List)this.visit((ParseTree)ctx.queryExpression());
    }

    @Override
    public List<JpaQueryParsingToken> visitSelectClause(HqlParser.SelectClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.SELECT()));
        if (ctx.DISTINCT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.DISTINCT()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.selectionList()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSelectionList(HqlParser.SelectionListContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        ctx.selection().forEach(selectionContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)selectionContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSelection(HqlParser.SelectionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.selectExpression()));
        if (ctx.variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSelectExpression(HqlParser.SelectExpressionContext ctx) {
        if (ctx.instantiation() != null) {
            return (List)this.visit((ParseTree)ctx.instantiation());
        }
        if (ctx.mapEntrySelection() != null) {
            return (List)this.visit((ParseTree)ctx.mapEntrySelection());
        }
        if (ctx.jpaSelectObjectSyntax() != null) {
            return (List)this.visit((ParseTree)ctx.jpaSelectObjectSyntax());
        }
        if (ctx.expressionOrPredicate() != null) {
            return (List)this.visit((ParseTree)ctx.expressionOrPredicate());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.ENTRY()));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.path()));
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.OBJECT(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identifier()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitWhereClause(HqlParser.WhereClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.WHERE()));
        ctx.predicate().forEach(predicateContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)predicateContext));
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoinType(HqlParser.JoinTypeContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.INNER() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.INNER()));
        }
        if (ctx.LEFT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LEFT()));
        }
        if (ctx.RIGHT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.RIGHT()));
        }
        if (ctx.FULL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.FULL()));
        }
        if (ctx.OUTER() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.OUTER()));
        }
        if (ctx.CROSS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.CROSS()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCrossJoin(HqlParser.CrossJoinContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.CROSS()));
        tokens.add(new JpaQueryParsingToken(ctx.JOIN()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.entityName()));
        if (ctx.variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJoinRestriction(HqlParser.JoinRestrictionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.ON() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ON()));
        } else if (ctx.WITH() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.WITH()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.predicate()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        tokens.add(new JpaQueryParsingToken(ctx.IN(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.path()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        if (ctx.variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitGroupByClause(HqlParser.GroupByClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.GROUP()));
        tokens.add(new JpaQueryParsingToken(ctx.BY()));
        ctx.groupedItem().forEach(groupedItemContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)groupedItemContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitOrderByClause(HqlParser.OrderByClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.ORDER()));
        tokens.add(new JpaQueryParsingToken(ctx.BY()));
        ctx.sortedItem().forEach(sortedItemContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)sortedItemContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitHavingClause(HqlParser.HavingClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.HAVING()));
        ctx.predicate().forEach(predicateContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)predicateContext));
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSetOperator(HqlParser.SetOperatorContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.UNION() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.UNION()));
        } else if (ctx.INTERSECT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.INTERSECT()));
        } else if (ctx.EXCEPT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.EXCEPT()));
        }
        if (ctx.ALL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ALL()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitLiteral(HqlParser.LiteralContext ctx) {
        if (ctx.NULL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.NULL()));
        }
        if (ctx.booleanLiteral() != null) {
            return (List)this.visit((ParseTree)ctx.booleanLiteral());
        }
        if (ctx.stringLiteral() != null) {
            return (List)this.visit((ParseTree)ctx.stringLiteral());
        }
        if (ctx.numericLiteral() != null) {
            return (List)this.visit((ParseTree)ctx.numericLiteral());
        }
        if (ctx.dateTimeLiteral() != null) {
            return (List)this.visit((ParseTree)ctx.dateTimeLiteral());
        }
        if (ctx.binaryLiteral() != null) {
            return (List)this.visit((ParseTree)ctx.binaryLiteral());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitBooleanLiteral(HqlParser.BooleanLiteralContext ctx) {
        if (ctx.TRUE() != null) {
            return List.of(new JpaQueryParsingToken(ctx.TRUE()));
        }
        if (ctx.FALSE() != null) {
            return List.of(new JpaQueryParsingToken(ctx.FALSE()));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitStringLiteral(HqlParser.StringLiteralContext ctx) {
        if (ctx.STRINGLITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.STRINGLITERAL()));
        }
        if (ctx.CHARACTER() != null) {
            return List.of(new JpaQueryParsingToken(ctx.CHARACTER()));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitNumericLiteral(HqlParser.NumericLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.INTEGER_LITERAL()));
        }
        if (ctx.FLOAT_LITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.FLOAT_LITERAL()));
        }
        if (ctx.HEXLITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.HEXLITERAL()));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitDateTimeLiteral(HqlParser.DateTimeLiteralContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.LOCAL_DATE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LOCAL_DATE()));
        } else if (ctx.LOCAL_TIME() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LOCAL_TIME()));
        } else if (ctx.LOCAL_DATETIME() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LOCAL_DATETIME()));
        } else if (ctx.CURRENT_DATE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.CURRENT_DATE()));
        } else if (ctx.CURRENT_TIME() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.CURRENT_TIME()));
        } else if (ctx.CURRENT_TIMESTAMP() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.CURRENT_TIMESTAMP()));
        } else if (ctx.OFFSET_DATETIME() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.OFFSET_DATETIME()));
        } else {
            if (ctx.LOCAL() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.LOCAL()));
            } else if (ctx.CURRENT() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.CURRENT()));
            } else if (ctx.OFFSET() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.OFFSET()));
            }
            if (ctx.DATE() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.DATE()));
            } else if (ctx.TIME() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.TIME()));
            } else if (ctx.DATETIME() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.DATETIME()));
            }
            if (ctx.INSTANT() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.INSTANT()));
            }
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDatetimeField(HqlParser.DatetimeFieldContext ctx) {
        if (ctx.YEAR() != null) {
            return List.of(new JpaQueryParsingToken(ctx.YEAR()));
        }
        if (ctx.MONTH() != null) {
            return List.of(new JpaQueryParsingToken(ctx.MONTH()));
        }
        if (ctx.DAY() != null) {
            return List.of(new JpaQueryParsingToken(ctx.DAY()));
        }
        if (ctx.WEEK() != null) {
            return List.of(new JpaQueryParsingToken(ctx.WEEK()));
        }
        if (ctx.QUARTER() != null) {
            return List.of(new JpaQueryParsingToken(ctx.QUARTER()));
        }
        if (ctx.HOUR() != null) {
            return List.of(new JpaQueryParsingToken(ctx.HOUR()));
        }
        if (ctx.MINUTE() != null) {
            return List.of(new JpaQueryParsingToken(ctx.MINUTE()));
        }
        if (ctx.SECOND() != null) {
            return List.of(new JpaQueryParsingToken(ctx.SECOND()));
        }
        if (ctx.NANOSECOND() != null) {
            return List.of(new JpaQueryParsingToken(ctx.NANOSECOND()));
        }
        if (ctx.EPOCH() != null) {
            return List.of(new JpaQueryParsingToken(ctx.EPOCH()));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitBinaryLiteral(HqlParser.BinaryLiteralContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.BINARY_LITERAL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.BINARY_LITERAL()));
        } else if (ctx.HEXLITERAL() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_BRACE);
            ctx.HEXLITERAL().forEach(terminalNode -> {
                tokens.add(new JpaQueryParsingToken((TerminalNode)terminalNode));
                JpaQueryParsingToken.NOSPACE(tokens);
                tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            });
            JpaQueryParsingToken.CLIP(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_BRACE);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitPlainPrimaryExpression(HqlParser.PlainPrimaryExpressionContext ctx) {
        return (List)this.visit((ParseTree)ctx.primaryExpression());
    }

    @Override
    public List<JpaQueryParsingToken> visitTupleExpression(HqlParser.TupleExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        ctx.expressionOrPredicate().forEach(expressionOrPredicateContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)expressionOrPredicateContext));
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitHqlConcatenationExpression(HqlParser.HqlConcatenationExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(0)));
        tokens.add(JpaQueryParsingToken.TOKEN_DOUBLE_PIPE);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(1)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDayOfWeekExpression(HqlParser.DayOfWeekExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.DAY()));
        tokens.add(new JpaQueryParsingToken(ctx.OF()));
        tokens.add(new JpaQueryParsingToken(ctx.WEEK()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDayOfMonthExpression(HqlParser.DayOfMonthExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.DAY()));
        tokens.add(new JpaQueryParsingToken(ctx.OF()));
        tokens.add(new JpaQueryParsingToken(ctx.MONTH()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitWeekOfYearExpression(HqlParser.WeekOfYearExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.WEEK()));
        tokens.add(new JpaQueryParsingToken(ctx.OF()));
        tokens.add(new JpaQueryParsingToken(ctx.YEAR()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitGroupedExpression(HqlParser.GroupedExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitAdditionExpression(HqlParser.AdditionExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(0)));
        tokens.add(new JpaQueryParsingToken(ctx.op));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(1)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSignedNumericLiteral(HqlParser.SignedNumericLiteralContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.op, false));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.numericLiteral()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(0)));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(new JpaQueryParsingToken(ctx.op, false));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(1)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSubqueryExpression(HqlParser.SubqueryExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSignedExpression(HqlParser.SignedExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.op, false));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitToDurationExpression(HqlParser.ToDurationExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.datetimeField()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFromDurationExpression(HqlParser.FromDurationExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        tokens.add(new JpaQueryParsingToken(ctx.BY()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.datetimeField()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCaseExpression(HqlParser.CaseExpressionContext ctx) {
        return (List)this.visit((ParseTree)ctx.caseList());
    }

    @Override
    public List<JpaQueryParsingToken> visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        return (List)this.visit((ParseTree)ctx.literal());
    }

    @Override
    public List<JpaQueryParsingToken> visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        return (List)this.visit((ParseTree)ctx.parameter());
    }

    @Override
    public List<JpaQueryParsingToken> visitFunctionExpression(HqlParser.FunctionExpressionContext ctx) {
        return (List)this.visit((ParseTree)ctx.function());
    }

    @Override
    public List<JpaQueryParsingToken> visitGeneralPathExpression(HqlParser.GeneralPathExpressionContext ctx) {
        return (List)this.visit((ParseTree)ctx.generalPathFragment());
    }

    @Override
    public List<JpaQueryParsingToken> visitIdentificationVariable(HqlParser.IdentificationVariableContext ctx) {
        if (ctx.identifier() != null) {
            return (List)this.visit((ParseTree)ctx.identifier());
        }
        if (ctx.simplePath() != null) {
            return (List)this.visit((ParseTree)ctx.simplePath());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitPath(HqlParser.PathContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.treatedPath() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.treatedPath()));
            if (ctx.pathContinutation() != null) {
                JpaQueryParsingToken.NOSPACE(tokens);
                tokens.addAll((Collection)this.visit((ParseTree)ctx.pathContinutation()));
            }
        } else if (ctx.generalPathFragment() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.generalPathFragment()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.simplePath()));
        if (ctx.indexedPathAccessFragment() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.indexedPathAccessFragment()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitIndexedPathAccessFragment(HqlParser.IndexedPathAccessFragmentContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_SQUARE_BRACKET);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_SQUARE_BRACKET);
        if (ctx.generalPathFragment() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_DOT);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.generalPathFragment()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSimplePath(HqlParser.SimplePathContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identifier()));
        JpaQueryParsingToken.NOSPACE(tokens);
        ctx.simplePathElement().forEach(simplePathElementContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)simplePathElementContext));
            JpaQueryParsingToken.NOSPACE(tokens);
        });
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSimplePathElement(HqlParser.SimplePathElementContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identifier()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCaseList(HqlParser.CaseListContext ctx) {
        if (ctx.simpleCaseExpression() != null) {
            return (List)this.visit((ParseTree)ctx.simpleCaseExpression());
        }
        if (ctx.searchedCaseExpression() != null) {
            return (List)this.visit((ParseTree)ctx.searchedCaseExpression());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitSimpleCaseExpression(HqlParser.SimpleCaseExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.CASE()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expressionOrPredicate(0)));
        ctx.caseWhenExpressionClause().forEach(caseWhenExpressionClauseContext -> tokens.addAll((Collection)this.visit((ParseTree)caseWhenExpressionClauseContext)));
        if (ctx.ELSE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ELSE()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.expressionOrPredicate(1)));
        }
        tokens.add(new JpaQueryParsingToken(ctx.END()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSearchedCaseExpression(HqlParser.SearchedCaseExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.CASE()));
        ctx.caseWhenPredicateClause().forEach(caseWhenPredicateClauseContext -> tokens.addAll((Collection)this.visit((ParseTree)caseWhenPredicateClauseContext)));
        if (ctx.ELSE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ELSE()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.expressionOrPredicate()));
        }
        tokens.add(new JpaQueryParsingToken(ctx.END()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCaseWhenExpressionClause(HqlParser.CaseWhenExpressionClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.WHEN()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        tokens.add(new JpaQueryParsingToken(ctx.THEN()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expressionOrPredicate()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCaseWhenPredicateClause(HqlParser.CaseWhenPredicateClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.WHEN()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.predicate()));
        tokens.add(new JpaQueryParsingToken(ctx.THEN()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expressionOrPredicate()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitGenericFunction(HqlParser.GenericFunctionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.functionName()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        if (ctx.functionArguments() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.functionArguments()));
        } else if (ctx.ASTERISK() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ASTERISK()));
        }
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinutation() != null) {
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.pathContinutation()));
        }
        if (ctx.filterClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.filterClause()));
        }
        if (ctx.withinGroup() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.withinGroup()));
        }
        if (ctx.overClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.overClause()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFunctionWithSubquery(HqlParser.FunctionWithSubqueryContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.functionName()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCastFunctionInvocation(HqlParser.CastFunctionInvocationContext ctx) {
        return (List)this.visit((ParseTree)ctx.castFunction());
    }

    @Override
    public List<JpaQueryParsingToken> visitExtractFunctionInvocation(HqlParser.ExtractFunctionInvocationContext ctx) {
        return (List)this.visit((ParseTree)ctx.extractFunction());
    }

    @Override
    public List<JpaQueryParsingToken> visitTrimFunctionInvocation(HqlParser.TrimFunctionInvocationContext ctx) {
        return (List)this.visit((ParseTree)ctx.trimFunction());
    }

    @Override
    public List<JpaQueryParsingToken> visitEveryFunctionInvocation(HqlParser.EveryFunctionInvocationContext ctx) {
        return (List)this.visit((ParseTree)ctx.everyFunction());
    }

    @Override
    public List<JpaQueryParsingToken> visitAnyFunctionInvocation(HqlParser.AnyFunctionInvocationContext ctx) {
        return (List)this.visit((ParseTree)ctx.anyFunction());
    }

    @Override
    public List<JpaQueryParsingToken> visitTreatedPathInvocation(HqlParser.TreatedPathInvocationContext ctx) {
        return (List)this.visit((ParseTree)ctx.treatedPath());
    }

    @Override
    public List<JpaQueryParsingToken> visitFunctionArguments(HqlParser.FunctionArgumentsContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.DISTINCT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.DISTINCT()));
        }
        ctx.expressionOrPredicate().forEach(expressionOrPredicateContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)expressionOrPredicateContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFilterClause(HqlParser.FilterClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.FILTER()));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.whereClause()));
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitWithinGroup(HqlParser.WithinGroupContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.WITHIN()));
        tokens.add(new JpaQueryParsingToken(ctx.GROUP()));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.orderByClause()));
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitOverClause(HqlParser.OverClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.OVER()));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        if (ctx.partitionClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.partitionClause()));
        }
        if (ctx.orderByClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.orderByClause()));
            JpaQueryParsingToken.SPACE(tokens);
        }
        if (ctx.frameClause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.frameClause()));
        }
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitPartitionClause(HqlParser.PartitionClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.PARTITION()));
        tokens.add(new JpaQueryParsingToken(ctx.BY()));
        ctx.expression().forEach(expressionContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)expressionContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitFrameClause(HqlParser.FrameClauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.RANGE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.RANGE()));
        } else if (ctx.ROWS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ROWS()));
        } else if (ctx.GROUPS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.GROUPS()));
        }
        if (ctx.BETWEEN() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.BETWEEN()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.frameStart()));
        if (ctx.AND() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.AND()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.frameEnd()));
        }
        if (ctx.frameExclusion() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.frameExclusion()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitUnboundedPrecedingFrameStart(HqlParser.UnboundedPrecedingFrameStartContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.UNBOUNDED()));
        tokens.add(new JpaQueryParsingToken(ctx.PRECEDING()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitExpressionPrecedingFrameStart(HqlParser.ExpressionPrecedingFrameStartContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        tokens.add(new JpaQueryParsingToken(ctx.PRECEDING()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCurrentRowFrameStart(HqlParser.CurrentRowFrameStartContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.CURRENT()));
        tokens.add(new JpaQueryParsingToken(ctx.ROW()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitExpressionFollowingFrameStart(HqlParser.ExpressionFollowingFrameStartContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        tokens.add(new JpaQueryParsingToken(ctx.FOLLOWING()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCurrentRowFrameExclusion(HqlParser.CurrentRowFrameExclusionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.EXCLUDE()));
        tokens.add(new JpaQueryParsingToken(ctx.CURRENT()));
        tokens.add(new JpaQueryParsingToken(ctx.ROW()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitGroupFrameExclusion(HqlParser.GroupFrameExclusionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.EXCLUDE()));
        tokens.add(new JpaQueryParsingToken(ctx.GROUP()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitTiesFrameExclusion(HqlParser.TiesFrameExclusionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.EXCLUDE()));
        tokens.add(new JpaQueryParsingToken(ctx.TIES()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitNoOthersFrameExclusion(HqlParser.NoOthersFrameExclusionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.EXCLUDE()));
        tokens.add(new JpaQueryParsingToken(ctx.NO()));
        tokens.add(new JpaQueryParsingToken(ctx.OTHERS()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitExpressionPrecedingFrameEnd(HqlParser.ExpressionPrecedingFrameEndContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        tokens.add(new JpaQueryParsingToken(ctx.PRECEDING()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCurrentRowFrameEnd(HqlParser.CurrentRowFrameEndContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.CURRENT()));
        tokens.add(new JpaQueryParsingToken(ctx.ROW()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitExpressionFollowingFrameEnd(HqlParser.ExpressionFollowingFrameEndContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        tokens.add(new JpaQueryParsingToken(ctx.FOLLOWING()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitUnboundedFollowingFrameEnd(HqlParser.UnboundedFollowingFrameEndContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.UNBOUNDED()));
        tokens.add(new JpaQueryParsingToken(ctx.FOLLOWING()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCastFunction(HqlParser.CastFunctionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.CAST(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        tokens.add(new JpaQueryParsingToken(ctx.AS()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.castTarget()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCastTarget(HqlParser.CastTargetContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.castTargetType()));
        if (ctx.INTEGER_LITERAL() != null && !ctx.INTEGER_LITERAL().isEmpty()) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            ctx.INTEGER_LITERAL().forEach(terminalNode -> {
                tokens.add(new JpaQueryParsingToken((TerminalNode)terminalNode));
                tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            });
            JpaQueryParsingToken.CLIP(tokens);
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitCastTargetType(HqlParser.CastTargetTypeContext ctx) {
        return List.of(new JpaQueryParsingToken(ctx.fullTargetName));
    }

    @Override
    public List<JpaQueryParsingToken> visitExtractFunction(HqlParser.ExtractFunctionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.EXTRACT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.EXTRACT(), false));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(0)));
            tokens.add(new JpaQueryParsingToken(ctx.FROM()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(1)));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.dateTimeFunction() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.dateTimeFunction()));
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(0)));
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.TRIM()));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        if (ctx.LEADING() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LEADING()));
        } else if (ctx.TRAILING() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.TRAILING()));
        } else if (ctx.BOTH() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.BOTH()));
        }
        if (ctx.stringLiteral() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.stringLiteral()));
        }
        if (ctx.FROM() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.FROM()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitDateTimeFunction(HqlParser.DateTimeFunctionContext ctx) {
        return List.of(new JpaQueryParsingToken(ctx.d));
    }

    @Override
    public List<JpaQueryParsingToken> visitEveryFunction(HqlParser.EveryFunctionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.every));
        if (ctx.ELEMENTS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ELEMENTS()));
        } else if (ctx.INDICES() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.INDICES()));
        }
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        if (ctx.predicate() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.predicate()));
        } else if (ctx.subquery() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
        } else if (ctx.simplePath() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.simplePath()));
        }
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitAnyFunction(HqlParser.AnyFunctionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.any));
        if (ctx.ELEMENTS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ELEMENTS()));
        } else if (ctx.INDICES() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.INDICES()));
        }
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        if (ctx.predicate() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.predicate()));
        } else if (ctx.subquery() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
        } else if (ctx.simplePath() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.simplePath()));
        }
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitTreatedPath(HqlParser.TreatedPathContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(new JpaQueryParsingToken(ctx.TREAT(), false));
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.path()));
        tokens.add(new JpaQueryParsingToken(ctx.AS()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.simplePath()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        if (ctx.pathContinutation() != null) {
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.pathContinutation()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitPathContinutation(HqlParser.PathContinutationContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.simplePath()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitIsBooleanPredicate(HqlParser.IsBooleanPredicateContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        tokens.add(new JpaQueryParsingToken(ctx.IS()));
        if (ctx.NOT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NOT()));
        }
        if (ctx.NULL() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NULL()));
        }
        if (ctx.TRUE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.TRUE()));
        }
        if (ctx.FALSE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.FALSE()));
        }
        if (ctx.EMPTY() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.EMPTY()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitMemberOfPredicate(HqlParser.MemberOfPredicateContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        if (ctx.NOT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NOT()));
        }
        if (ctx.MEMBER() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.MEMBER()));
        }
        if (ctx.OF() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.OF()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.path()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitIsDistinctFromPredicate(HqlParser.IsDistinctFromPredicateContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>(16);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(0)));
        tokens.add(new JpaQueryParsingToken(ctx.IS()));
        if (ctx.NOT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NOT()));
        }
        if (ctx.DISTINCT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.DISTINCT()));
            tokens.add(new JpaQueryParsingToken(ctx.FROM()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(1)));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx) {
        return (List)this.visit((ParseTree)ctx.betweenExpression());
    }

    @Override
    public List<JpaQueryParsingToken> visitContainsPredicate(HqlParser.ContainsPredicateContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(0)));
        if (ctx.NOT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.NOT()));
        }
        if (ctx.CONTAINS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.CONTAINS()));
        }
        if (ctx.INCLUDES() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.INCLUDES()));
        }
        if (ctx.INTERSECTS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.INTERSECTS()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(1)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.predicate(0)));
        tokens.add(new JpaQueryParsingToken(ctx.OR()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.predicate(1)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitRelationalPredicate(HqlParser.RelationalPredicateContext ctx) {
        return (List)this.visit((ParseTree)ctx.relationalExpression());
    }

    @Override
    public List<JpaQueryParsingToken> visitExistsPredicate(HqlParser.ExistsPredicateContext ctx) {
        return (List)this.visit((ParseTree)ctx.existsExpression());
    }

    @Override
    public List<JpaQueryParsingToken> visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.predicate(0)));
        tokens.add(new JpaQueryParsingToken(ctx.AND()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.predicate(1)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.predicate()));
        JpaQueryParsingToken.NOSPACE(tokens);
        tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        return (List)this.visit((ParseTree)ctx.stringPatternMatching());
    }

    @Override
    public List<JpaQueryParsingToken> visitInPredicate(HqlParser.InPredicateContext ctx) {
        return (List)this.visit((ParseTree)ctx.inExpression());
    }

    @Override
    public List<JpaQueryParsingToken> visitNotPredicate(HqlParser.NotPredicateContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.add(JpaQueryParsingToken.TOKEN_NOT);
        tokens.addAll((Collection)this.visit((ParseTree)ctx.predicate()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitExpressionPredicate(HqlParser.ExpressionPredicateContext ctx) {
        return (List)this.visit((ParseTree)ctx.expression());
    }

    @Override
    public List<JpaQueryParsingToken> visitExpressionOrPredicate(HqlParser.ExpressionOrPredicateContext ctx) {
        if (ctx.expression() != null) {
            return (List)this.visit((ParseTree)ctx.expression());
        }
        if (ctx.predicate() != null) {
            return (List)this.visit((ParseTree)ctx.predicate());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitRelationalExpression(HqlParser.RelationalExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(0)));
        tokens.add(new JpaQueryParsingToken(ctx.op));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(1)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitBetweenExpression(HqlParser.BetweenExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(0)));
        if (ctx.NOT() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_NOT);
        }
        tokens.add(new JpaQueryParsingToken(ctx.BETWEEN()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(1)));
        tokens.add(new JpaQueryParsingToken(ctx.AND()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(2)));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitStringPatternMatching(HqlParser.StringPatternMatchingContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(0)));
        if (ctx.NOT() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_NOT);
        }
        if (ctx.LIKE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.LIKE()));
        } else if (ctx.ILIKE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ILIKE()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression(1)));
        if (ctx.ESCAPE() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.ESCAPE()));
            if (ctx.stringLiteral() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.stringLiteral()));
            } else if (ctx.parameter() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.parameter()));
            }
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitInExpression(HqlParser.InExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        if (ctx.NOT() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_NOT);
        }
        tokens.add(new JpaQueryParsingToken(ctx.IN()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.inList()));
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitInList(HqlParser.InListContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.simplePath() != null) {
            if (ctx.ELEMENTS() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.ELEMENTS()));
            } else if (ctx.INDICES() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.INDICES()));
            }
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.simplePath()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.subquery() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.subquery()));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.parameter() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.parameter()));
        } else if (ctx.expressionOrPredicate() != null) {
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            ctx.expressionOrPredicate().forEach(expressionOrPredicateContext -> {
                tokens.addAll((Collection)this.visit((ParseTree)expressionOrPredicateContext));
                JpaQueryParsingToken.NOSPACE(tokens);
                tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
            });
            JpaQueryParsingToken.CLIP(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitExistsExpression(HqlParser.ExistsExpressionContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.simplePath() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.EXISTS()));
            if (ctx.ELEMENTS() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.ELEMENTS()));
            } else if (ctx.INDICES() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.INDICES()));
            }
            tokens.add(JpaQueryParsingToken.TOKEN_OPEN_PAREN);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.simplePath()));
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else if (ctx.expression() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.EXISTS()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.expression()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitInstantiationTarget(HqlParser.InstantiationTargetContext ctx) {
        if (ctx.LIST() != null) {
            return List.of(new JpaQueryParsingToken(ctx.LIST()));
        }
        if (ctx.MAP() != null) {
            return List.of(new JpaQueryParsingToken(ctx.MAP()));
        }
        if (ctx.simplePath() != null) {
            List tokens = (List)this.visit((ParseTree)ctx.simplePath());
            JpaQueryParsingToken.NOSPACE(tokens);
            return tokens;
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitInstantiationArguments(HqlParser.InstantiationArgumentsContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        ctx.instantiationArgument().forEach(instantiationArgumentContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)instantiationArgumentContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitInstantiationArgument(HqlParser.InstantiationArgumentContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.expressionOrPredicate() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.expressionOrPredicate()));
        } else if (ctx.instantiation() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.instantiation()));
        }
        if (ctx.variable() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.variable()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitParameterOrIntegerLiteral(HqlParser.ParameterOrIntegerLiteralContext ctx) {
        if (ctx.parameter() != null) {
            return (List)this.visit((ParseTree)ctx.parameter());
        }
        if (ctx.INTEGER_LITERAL() != null) {
            return List.of(new JpaQueryParsingToken(ctx.INTEGER_LITERAL()));
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx) {
        if (ctx.parameter() != null) {
            return (List)this.visit((ParseTree)ctx.parameter());
        }
        if (ctx.numericLiteral() != null) {
            return (List)this.visit((ParseTree)ctx.numericLiteral());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitVariable(HqlParser.VariableContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.identifier() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identifier()));
        } else if (ctx.reservedWord() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.reservedWord()));
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitParameter(HqlParser.ParameterContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        if (ctx.prefix.getText().equals(":")) {
            tokens.add(JpaQueryParsingToken.TOKEN_COLON);
            tokens.addAll((Collection)this.visit((ParseTree)ctx.identifier()));
        } else if (ctx.prefix.getText().equals("?")) {
            tokens.add(JpaQueryParsingToken.TOKEN_QUESTION_MARK);
            if (ctx.INTEGER_LITERAL() != null) {
                tokens.add(new JpaQueryParsingToken(ctx.INTEGER_LITERAL()));
            }
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitEntityName(HqlParser.EntityNameContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        ctx.identifier().forEach(identifierContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)identifierContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        });
        JpaQueryParsingToken.CLIP(tokens);
        JpaQueryParsingToken.SPACE(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitIdentifier(HqlParser.IdentifierContext ctx) {
        if (ctx.reservedWord() != null) {
            return (List)this.visit((ParseTree)ctx.reservedWord());
        }
        return List.of();
    }

    @Override
    public List<JpaQueryParsingToken> visitCharacter(HqlParser.CharacterContext ctx) {
        return List.of(new JpaQueryParsingToken(ctx.CHARACTER()));
    }

    @Override
    public List<JpaQueryParsingToken> visitFunctionName(HqlParser.FunctionNameContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = new ArrayList<JpaQueryParsingToken>();
        ctx.reservedWord().forEach(reservedWordContext -> {
            tokens.addAll((Collection)this.visit((ParseTree)reservedWordContext));
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_DOT);
        });
        JpaQueryParsingToken.CLIP(tokens);
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitReservedWord(HqlParser.ReservedWordContext ctx) {
        if (ctx.IDENTIFICATION_VARIABLE() != null) {
            return List.of(new JpaQueryParsingToken(ctx.IDENTIFICATION_VARIABLE()));
        }
        return List.of(new JpaQueryParsingToken(ctx.f));
    }
}

