// Generated from org/springframework/data/jpa/repository/query/Eql.g4 by ANTLR 4.13.2
package org.springframework.data.jpa.repository.query;

/**
 * Implementation of EclipseLink Query Language (EQL)
 * See:
 * * https://eclipse.dev/eclipselink/documentation/3.0/jpa/extensions/jpql.htm
 * * https://wiki.eclipse.org/EclipseLink/UserGuide/JPA/Basic_JPA_Development/Querying/JPQL
 *
 * @author Greg Turnquist
 * @author Christoph Strobl
 * @since 3.2
 */

import org.antlr.v4.runtime.tree.ParseTreeListener;

/**
 * This interface defines a complete listener for a parse tree produced by
 * {@link EqlParser}.
 */
interface EqlListener extends ParseTreeListener {
	/**
	 * Enter a parse tree produced by {@link EqlParser#start}.
	 * @param ctx the parse tree
	 */
	void enterStart(EqlParser.StartContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#start}.
	 * @param ctx the parse tree
	 */
	void exitStart(EqlParser.StartContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#ql_statement}.
	 * @param ctx the parse tree
	 */
	void enterQl_statement(EqlParser.Ql_statementContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#ql_statement}.
	 * @param ctx the parse tree
	 */
	void exitQl_statement(EqlParser.Ql_statementContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#select_statement}.
	 * @param ctx the parse tree
	 */
	void enterSelect_statement(EqlParser.Select_statementContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#select_statement}.
	 * @param ctx the parse tree
	 */
	void exitSelect_statement(EqlParser.Select_statementContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#setOperator}.
	 * @param ctx the parse tree
	 */
	void enterSetOperator(EqlParser.SetOperatorContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#setOperator}.
	 * @param ctx the parse tree
	 */
	void exitSetOperator(EqlParser.SetOperatorContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#set_fuction}.
	 * @param ctx the parse tree
	 */
	void enterSet_fuction(EqlParser.Set_fuctionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#set_fuction}.
	 * @param ctx the parse tree
	 */
	void exitSet_fuction(EqlParser.Set_fuctionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#update_statement}.
	 * @param ctx the parse tree
	 */
	void enterUpdate_statement(EqlParser.Update_statementContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#update_statement}.
	 * @param ctx the parse tree
	 */
	void exitUpdate_statement(EqlParser.Update_statementContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#delete_statement}.
	 * @param ctx the parse tree
	 */
	void enterDelete_statement(EqlParser.Delete_statementContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#delete_statement}.
	 * @param ctx the parse tree
	 */
	void exitDelete_statement(EqlParser.Delete_statementContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#from_clause}.
	 * @param ctx the parse tree
	 */
	void enterFrom_clause(EqlParser.From_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#from_clause}.
	 * @param ctx the parse tree
	 */
	void exitFrom_clause(EqlParser.From_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#identificationVariableDeclarationOrCollectionMemberDeclaration}.
	 * @param ctx the parse tree
	 */
	void enterIdentificationVariableDeclarationOrCollectionMemberDeclaration(EqlParser.IdentificationVariableDeclarationOrCollectionMemberDeclarationContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#identificationVariableDeclarationOrCollectionMemberDeclaration}.
	 * @param ctx the parse tree
	 */
	void exitIdentificationVariableDeclarationOrCollectionMemberDeclaration(EqlParser.IdentificationVariableDeclarationOrCollectionMemberDeclarationContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#identification_variable_declaration}.
	 * @param ctx the parse tree
	 */
	void enterIdentification_variable_declaration(EqlParser.Identification_variable_declarationContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#identification_variable_declaration}.
	 * @param ctx the parse tree
	 */
	void exitIdentification_variable_declaration(EqlParser.Identification_variable_declarationContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#range_variable_declaration}.
	 * @param ctx the parse tree
	 */
	void enterRange_variable_declaration(EqlParser.Range_variable_declarationContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#range_variable_declaration}.
	 * @param ctx the parse tree
	 */
	void exitRange_variable_declaration(EqlParser.Range_variable_declarationContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#join}.
	 * @param ctx the parse tree
	 */
	void enterJoin(EqlParser.JoinContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#join}.
	 * @param ctx the parse tree
	 */
	void exitJoin(EqlParser.JoinContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#fetch_join}.
	 * @param ctx the parse tree
	 */
	void enterFetch_join(EqlParser.Fetch_joinContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#fetch_join}.
	 * @param ctx the parse tree
	 */
	void exitFetch_join(EqlParser.Fetch_joinContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#join_spec}.
	 * @param ctx the parse tree
	 */
	void enterJoin_spec(EqlParser.Join_specContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#join_spec}.
	 * @param ctx the parse tree
	 */
	void exitJoin_spec(EqlParser.Join_specContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#join_condition}.
	 * @param ctx the parse tree
	 */
	void enterJoin_condition(EqlParser.Join_conditionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#join_condition}.
	 * @param ctx the parse tree
	 */
	void exitJoin_condition(EqlParser.Join_conditionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#join_association_path_expression}.
	 * @param ctx the parse tree
	 */
	void enterJoin_association_path_expression(EqlParser.Join_association_path_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#join_association_path_expression}.
	 * @param ctx the parse tree
	 */
	void exitJoin_association_path_expression(EqlParser.Join_association_path_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#join_collection_valued_path_expression}.
	 * @param ctx the parse tree
	 */
	void enterJoin_collection_valued_path_expression(EqlParser.Join_collection_valued_path_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#join_collection_valued_path_expression}.
	 * @param ctx the parse tree
	 */
	void exitJoin_collection_valued_path_expression(EqlParser.Join_collection_valued_path_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#join_single_valued_path_expression}.
	 * @param ctx the parse tree
	 */
	void enterJoin_single_valued_path_expression(EqlParser.Join_single_valued_path_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#join_single_valued_path_expression}.
	 * @param ctx the parse tree
	 */
	void exitJoin_single_valued_path_expression(EqlParser.Join_single_valued_path_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#collection_member_declaration}.
	 * @param ctx the parse tree
	 */
	void enterCollection_member_declaration(EqlParser.Collection_member_declarationContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#collection_member_declaration}.
	 * @param ctx the parse tree
	 */
	void exitCollection_member_declaration(EqlParser.Collection_member_declarationContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#qualified_identification_variable}.
	 * @param ctx the parse tree
	 */
	void enterQualified_identification_variable(EqlParser.Qualified_identification_variableContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#qualified_identification_variable}.
	 * @param ctx the parse tree
	 */
	void exitQualified_identification_variable(EqlParser.Qualified_identification_variableContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#map_field_identification_variable}.
	 * @param ctx the parse tree
	 */
	void enterMap_field_identification_variable(EqlParser.Map_field_identification_variableContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#map_field_identification_variable}.
	 * @param ctx the parse tree
	 */
	void exitMap_field_identification_variable(EqlParser.Map_field_identification_variableContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#single_valued_path_expression}.
	 * @param ctx the parse tree
	 */
	void enterSingle_valued_path_expression(EqlParser.Single_valued_path_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#single_valued_path_expression}.
	 * @param ctx the parse tree
	 */
	void exitSingle_valued_path_expression(EqlParser.Single_valued_path_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#general_identification_variable}.
	 * @param ctx the parse tree
	 */
	void enterGeneral_identification_variable(EqlParser.General_identification_variableContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#general_identification_variable}.
	 * @param ctx the parse tree
	 */
	void exitGeneral_identification_variable(EqlParser.General_identification_variableContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#general_subpath}.
	 * @param ctx the parse tree
	 */
	void enterGeneral_subpath(EqlParser.General_subpathContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#general_subpath}.
	 * @param ctx the parse tree
	 */
	void exitGeneral_subpath(EqlParser.General_subpathContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#simple_subpath}.
	 * @param ctx the parse tree
	 */
	void enterSimple_subpath(EqlParser.Simple_subpathContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#simple_subpath}.
	 * @param ctx the parse tree
	 */
	void exitSimple_subpath(EqlParser.Simple_subpathContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#treated_subpath}.
	 * @param ctx the parse tree
	 */
	void enterTreated_subpath(EqlParser.Treated_subpathContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#treated_subpath}.
	 * @param ctx the parse tree
	 */
	void exitTreated_subpath(EqlParser.Treated_subpathContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#state_field_path_expression}.
	 * @param ctx the parse tree
	 */
	void enterState_field_path_expression(EqlParser.State_field_path_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#state_field_path_expression}.
	 * @param ctx the parse tree
	 */
	void exitState_field_path_expression(EqlParser.State_field_path_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#state_valued_path_expression}.
	 * @param ctx the parse tree
	 */
	void enterState_valued_path_expression(EqlParser.State_valued_path_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#state_valued_path_expression}.
	 * @param ctx the parse tree
	 */
	void exitState_valued_path_expression(EqlParser.State_valued_path_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#single_valued_object_path_expression}.
	 * @param ctx the parse tree
	 */
	void enterSingle_valued_object_path_expression(EqlParser.Single_valued_object_path_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#single_valued_object_path_expression}.
	 * @param ctx the parse tree
	 */
	void exitSingle_valued_object_path_expression(EqlParser.Single_valued_object_path_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#collection_valued_path_expression}.
	 * @param ctx the parse tree
	 */
	void enterCollection_valued_path_expression(EqlParser.Collection_valued_path_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#collection_valued_path_expression}.
	 * @param ctx the parse tree
	 */
	void exitCollection_valued_path_expression(EqlParser.Collection_valued_path_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#update_clause}.
	 * @param ctx the parse tree
	 */
	void enterUpdate_clause(EqlParser.Update_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#update_clause}.
	 * @param ctx the parse tree
	 */
	void exitUpdate_clause(EqlParser.Update_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#update_item}.
	 * @param ctx the parse tree
	 */
	void enterUpdate_item(EqlParser.Update_itemContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#update_item}.
	 * @param ctx the parse tree
	 */
	void exitUpdate_item(EqlParser.Update_itemContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#new_value}.
	 * @param ctx the parse tree
	 */
	void enterNew_value(EqlParser.New_valueContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#new_value}.
	 * @param ctx the parse tree
	 */
	void exitNew_value(EqlParser.New_valueContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#delete_clause}.
	 * @param ctx the parse tree
	 */
	void enterDelete_clause(EqlParser.Delete_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#delete_clause}.
	 * @param ctx the parse tree
	 */
	void exitDelete_clause(EqlParser.Delete_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#select_clause}.
	 * @param ctx the parse tree
	 */
	void enterSelect_clause(EqlParser.Select_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#select_clause}.
	 * @param ctx the parse tree
	 */
	void exitSelect_clause(EqlParser.Select_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#select_item}.
	 * @param ctx the parse tree
	 */
	void enterSelect_item(EqlParser.Select_itemContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#select_item}.
	 * @param ctx the parse tree
	 */
	void exitSelect_item(EqlParser.Select_itemContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#select_expression}.
	 * @param ctx the parse tree
	 */
	void enterSelect_expression(EqlParser.Select_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#select_expression}.
	 * @param ctx the parse tree
	 */
	void exitSelect_expression(EqlParser.Select_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#constructor_expression}.
	 * @param ctx the parse tree
	 */
	void enterConstructor_expression(EqlParser.Constructor_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#constructor_expression}.
	 * @param ctx the parse tree
	 */
	void exitConstructor_expression(EqlParser.Constructor_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#constructor_item}.
	 * @param ctx the parse tree
	 */
	void enterConstructor_item(EqlParser.Constructor_itemContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#constructor_item}.
	 * @param ctx the parse tree
	 */
	void exitConstructor_item(EqlParser.Constructor_itemContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#aggregate_expression}.
	 * @param ctx the parse tree
	 */
	void enterAggregate_expression(EqlParser.Aggregate_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#aggregate_expression}.
	 * @param ctx the parse tree
	 */
	void exitAggregate_expression(EqlParser.Aggregate_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#where_clause}.
	 * @param ctx the parse tree
	 */
	void enterWhere_clause(EqlParser.Where_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#where_clause}.
	 * @param ctx the parse tree
	 */
	void exitWhere_clause(EqlParser.Where_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#groupby_clause}.
	 * @param ctx the parse tree
	 */
	void enterGroupby_clause(EqlParser.Groupby_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#groupby_clause}.
	 * @param ctx the parse tree
	 */
	void exitGroupby_clause(EqlParser.Groupby_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#groupby_item}.
	 * @param ctx the parse tree
	 */
	void enterGroupby_item(EqlParser.Groupby_itemContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#groupby_item}.
	 * @param ctx the parse tree
	 */
	void exitGroupby_item(EqlParser.Groupby_itemContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#having_clause}.
	 * @param ctx the parse tree
	 */
	void enterHaving_clause(EqlParser.Having_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#having_clause}.
	 * @param ctx the parse tree
	 */
	void exitHaving_clause(EqlParser.Having_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#orderby_clause}.
	 * @param ctx the parse tree
	 */
	void enterOrderby_clause(EqlParser.Orderby_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#orderby_clause}.
	 * @param ctx the parse tree
	 */
	void exitOrderby_clause(EqlParser.Orderby_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#orderby_item}.
	 * @param ctx the parse tree
	 */
	void enterOrderby_item(EqlParser.Orderby_itemContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#orderby_item}.
	 * @param ctx the parse tree
	 */
	void exitOrderby_item(EqlParser.Orderby_itemContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#nullsPrecedence}.
	 * @param ctx the parse tree
	 */
	void enterNullsPrecedence(EqlParser.NullsPrecedenceContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#nullsPrecedence}.
	 * @param ctx the parse tree
	 */
	void exitNullsPrecedence(EqlParser.NullsPrecedenceContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#subquery}.
	 * @param ctx the parse tree
	 */
	void enterSubquery(EqlParser.SubqueryContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#subquery}.
	 * @param ctx the parse tree
	 */
	void exitSubquery(EqlParser.SubqueryContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#subquery_from_clause}.
	 * @param ctx the parse tree
	 */
	void enterSubquery_from_clause(EqlParser.Subquery_from_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#subquery_from_clause}.
	 * @param ctx the parse tree
	 */
	void exitSubquery_from_clause(EqlParser.Subquery_from_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#subselect_identification_variable_declaration}.
	 * @param ctx the parse tree
	 */
	void enterSubselect_identification_variable_declaration(EqlParser.Subselect_identification_variable_declarationContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#subselect_identification_variable_declaration}.
	 * @param ctx the parse tree
	 */
	void exitSubselect_identification_variable_declaration(EqlParser.Subselect_identification_variable_declarationContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#derived_path_expression}.
	 * @param ctx the parse tree
	 */
	void enterDerived_path_expression(EqlParser.Derived_path_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#derived_path_expression}.
	 * @param ctx the parse tree
	 */
	void exitDerived_path_expression(EqlParser.Derived_path_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#general_derived_path}.
	 * @param ctx the parse tree
	 */
	void enterGeneral_derived_path(EqlParser.General_derived_pathContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#general_derived_path}.
	 * @param ctx the parse tree
	 */
	void exitGeneral_derived_path(EqlParser.General_derived_pathContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#simple_derived_path}.
	 * @param ctx the parse tree
	 */
	void enterSimple_derived_path(EqlParser.Simple_derived_pathContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#simple_derived_path}.
	 * @param ctx the parse tree
	 */
	void exitSimple_derived_path(EqlParser.Simple_derived_pathContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#treated_derived_path}.
	 * @param ctx the parse tree
	 */
	void enterTreated_derived_path(EqlParser.Treated_derived_pathContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#treated_derived_path}.
	 * @param ctx the parse tree
	 */
	void exitTreated_derived_path(EqlParser.Treated_derived_pathContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#derived_collection_member_declaration}.
	 * @param ctx the parse tree
	 */
	void enterDerived_collection_member_declaration(EqlParser.Derived_collection_member_declarationContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#derived_collection_member_declaration}.
	 * @param ctx the parse tree
	 */
	void exitDerived_collection_member_declaration(EqlParser.Derived_collection_member_declarationContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#simple_select_clause}.
	 * @param ctx the parse tree
	 */
	void enterSimple_select_clause(EqlParser.Simple_select_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#simple_select_clause}.
	 * @param ctx the parse tree
	 */
	void exitSimple_select_clause(EqlParser.Simple_select_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#simple_select_expression}.
	 * @param ctx the parse tree
	 */
	void enterSimple_select_expression(EqlParser.Simple_select_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#simple_select_expression}.
	 * @param ctx the parse tree
	 */
	void exitSimple_select_expression(EqlParser.Simple_select_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#scalar_expression}.
	 * @param ctx the parse tree
	 */
	void enterScalar_expression(EqlParser.Scalar_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#scalar_expression}.
	 * @param ctx the parse tree
	 */
	void exitScalar_expression(EqlParser.Scalar_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#conditional_expression}.
	 * @param ctx the parse tree
	 */
	void enterConditional_expression(EqlParser.Conditional_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#conditional_expression}.
	 * @param ctx the parse tree
	 */
	void exitConditional_expression(EqlParser.Conditional_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#conditional_term}.
	 * @param ctx the parse tree
	 */
	void enterConditional_term(EqlParser.Conditional_termContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#conditional_term}.
	 * @param ctx the parse tree
	 */
	void exitConditional_term(EqlParser.Conditional_termContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#conditional_factor}.
	 * @param ctx the parse tree
	 */
	void enterConditional_factor(EqlParser.Conditional_factorContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#conditional_factor}.
	 * @param ctx the parse tree
	 */
	void exitConditional_factor(EqlParser.Conditional_factorContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#conditional_primary}.
	 * @param ctx the parse tree
	 */
	void enterConditional_primary(EqlParser.Conditional_primaryContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#conditional_primary}.
	 * @param ctx the parse tree
	 */
	void exitConditional_primary(EqlParser.Conditional_primaryContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#simple_cond_expression}.
	 * @param ctx the parse tree
	 */
	void enterSimple_cond_expression(EqlParser.Simple_cond_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#simple_cond_expression}.
	 * @param ctx the parse tree
	 */
	void exitSimple_cond_expression(EqlParser.Simple_cond_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#between_expression}.
	 * @param ctx the parse tree
	 */
	void enterBetween_expression(EqlParser.Between_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#between_expression}.
	 * @param ctx the parse tree
	 */
	void exitBetween_expression(EqlParser.Between_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#in_expression}.
	 * @param ctx the parse tree
	 */
	void enterIn_expression(EqlParser.In_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#in_expression}.
	 * @param ctx the parse tree
	 */
	void exitIn_expression(EqlParser.In_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#in_item}.
	 * @param ctx the parse tree
	 */
	void enterIn_item(EqlParser.In_itemContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#in_item}.
	 * @param ctx the parse tree
	 */
	void exitIn_item(EqlParser.In_itemContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#like_expression}.
	 * @param ctx the parse tree
	 */
	void enterLike_expression(EqlParser.Like_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#like_expression}.
	 * @param ctx the parse tree
	 */
	void exitLike_expression(EqlParser.Like_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#null_comparison_expression}.
	 * @param ctx the parse tree
	 */
	void enterNull_comparison_expression(EqlParser.Null_comparison_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#null_comparison_expression}.
	 * @param ctx the parse tree
	 */
	void exitNull_comparison_expression(EqlParser.Null_comparison_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#empty_collection_comparison_expression}.
	 * @param ctx the parse tree
	 */
	void enterEmpty_collection_comparison_expression(EqlParser.Empty_collection_comparison_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#empty_collection_comparison_expression}.
	 * @param ctx the parse tree
	 */
	void exitEmpty_collection_comparison_expression(EqlParser.Empty_collection_comparison_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#collection_member_expression}.
	 * @param ctx the parse tree
	 */
	void enterCollection_member_expression(EqlParser.Collection_member_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#collection_member_expression}.
	 * @param ctx the parse tree
	 */
	void exitCollection_member_expression(EqlParser.Collection_member_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#entity_or_value_expression}.
	 * @param ctx the parse tree
	 */
	void enterEntity_or_value_expression(EqlParser.Entity_or_value_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#entity_or_value_expression}.
	 * @param ctx the parse tree
	 */
	void exitEntity_or_value_expression(EqlParser.Entity_or_value_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#simple_entity_or_value_expression}.
	 * @param ctx the parse tree
	 */
	void enterSimple_entity_or_value_expression(EqlParser.Simple_entity_or_value_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#simple_entity_or_value_expression}.
	 * @param ctx the parse tree
	 */
	void exitSimple_entity_or_value_expression(EqlParser.Simple_entity_or_value_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#exists_expression}.
	 * @param ctx the parse tree
	 */
	void enterExists_expression(EqlParser.Exists_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#exists_expression}.
	 * @param ctx the parse tree
	 */
	void exitExists_expression(EqlParser.Exists_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#all_or_any_expression}.
	 * @param ctx the parse tree
	 */
	void enterAll_or_any_expression(EqlParser.All_or_any_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#all_or_any_expression}.
	 * @param ctx the parse tree
	 */
	void exitAll_or_any_expression(EqlParser.All_or_any_expressionContext ctx);
	/**
	 * Enter a parse tree produced by the {@code StringComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void enterStringComparison(EqlParser.StringComparisonContext ctx);
	/**
	 * Exit a parse tree produced by the {@code StringComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void exitStringComparison(EqlParser.StringComparisonContext ctx);
	/**
	 * Enter a parse tree produced by the {@code BooleanComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void enterBooleanComparison(EqlParser.BooleanComparisonContext ctx);
	/**
	 * Exit a parse tree produced by the {@code BooleanComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void exitBooleanComparison(EqlParser.BooleanComparisonContext ctx);
	/**
	 * Enter a parse tree produced by the {@code DirectBooleanCheck}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void enterDirectBooleanCheck(EqlParser.DirectBooleanCheckContext ctx);
	/**
	 * Exit a parse tree produced by the {@code DirectBooleanCheck}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void exitDirectBooleanCheck(EqlParser.DirectBooleanCheckContext ctx);
	/**
	 * Enter a parse tree produced by the {@code EnumComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void enterEnumComparison(EqlParser.EnumComparisonContext ctx);
	/**
	 * Exit a parse tree produced by the {@code EnumComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void exitEnumComparison(EqlParser.EnumComparisonContext ctx);
	/**
	 * Enter a parse tree produced by the {@code DatetimeComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void enterDatetimeComparison(EqlParser.DatetimeComparisonContext ctx);
	/**
	 * Exit a parse tree produced by the {@code DatetimeComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void exitDatetimeComparison(EqlParser.DatetimeComparisonContext ctx);
	/**
	 * Enter a parse tree produced by the {@code EntityComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void enterEntityComparison(EqlParser.EntityComparisonContext ctx);
	/**
	 * Exit a parse tree produced by the {@code EntityComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void exitEntityComparison(EqlParser.EntityComparisonContext ctx);
	/**
	 * Enter a parse tree produced by the {@code ArithmeticComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void enterArithmeticComparison(EqlParser.ArithmeticComparisonContext ctx);
	/**
	 * Exit a parse tree produced by the {@code ArithmeticComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void exitArithmeticComparison(EqlParser.ArithmeticComparisonContext ctx);
	/**
	 * Enter a parse tree produced by the {@code EntityTypeComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void enterEntityTypeComparison(EqlParser.EntityTypeComparisonContext ctx);
	/**
	 * Exit a parse tree produced by the {@code EntityTypeComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void exitEntityTypeComparison(EqlParser.EntityTypeComparisonContext ctx);
	/**
	 * Enter a parse tree produced by the {@code RegexpComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void enterRegexpComparison(EqlParser.RegexpComparisonContext ctx);
	/**
	 * Exit a parse tree produced by the {@code RegexpComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 */
	void exitRegexpComparison(EqlParser.RegexpComparisonContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#comparison_operator}.
	 * @param ctx the parse tree
	 */
	void enterComparison_operator(EqlParser.Comparison_operatorContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#comparison_operator}.
	 * @param ctx the parse tree
	 */
	void exitComparison_operator(EqlParser.Comparison_operatorContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#arithmetic_expression}.
	 * @param ctx the parse tree
	 */
	void enterArithmetic_expression(EqlParser.Arithmetic_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#arithmetic_expression}.
	 * @param ctx the parse tree
	 */
	void exitArithmetic_expression(EqlParser.Arithmetic_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#arithmetic_term}.
	 * @param ctx the parse tree
	 */
	void enterArithmetic_term(EqlParser.Arithmetic_termContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#arithmetic_term}.
	 * @param ctx the parse tree
	 */
	void exitArithmetic_term(EqlParser.Arithmetic_termContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#arithmetic_factor}.
	 * @param ctx the parse tree
	 */
	void enterArithmetic_factor(EqlParser.Arithmetic_factorContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#arithmetic_factor}.
	 * @param ctx the parse tree
	 */
	void exitArithmetic_factor(EqlParser.Arithmetic_factorContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#arithmetic_primary}.
	 * @param ctx the parse tree
	 */
	void enterArithmetic_primary(EqlParser.Arithmetic_primaryContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#arithmetic_primary}.
	 * @param ctx the parse tree
	 */
	void exitArithmetic_primary(EqlParser.Arithmetic_primaryContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#string_expression}.
	 * @param ctx the parse tree
	 */
	void enterString_expression(EqlParser.String_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#string_expression}.
	 * @param ctx the parse tree
	 */
	void exitString_expression(EqlParser.String_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#datetime_expression}.
	 * @param ctx the parse tree
	 */
	void enterDatetime_expression(EqlParser.Datetime_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#datetime_expression}.
	 * @param ctx the parse tree
	 */
	void exitDatetime_expression(EqlParser.Datetime_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#boolean_expression}.
	 * @param ctx the parse tree
	 */
	void enterBoolean_expression(EqlParser.Boolean_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#boolean_expression}.
	 * @param ctx the parse tree
	 */
	void exitBoolean_expression(EqlParser.Boolean_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#enum_expression}.
	 * @param ctx the parse tree
	 */
	void enterEnum_expression(EqlParser.Enum_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#enum_expression}.
	 * @param ctx the parse tree
	 */
	void exitEnum_expression(EqlParser.Enum_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#entity_expression}.
	 * @param ctx the parse tree
	 */
	void enterEntity_expression(EqlParser.Entity_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#entity_expression}.
	 * @param ctx the parse tree
	 */
	void exitEntity_expression(EqlParser.Entity_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#simple_entity_expression}.
	 * @param ctx the parse tree
	 */
	void enterSimple_entity_expression(EqlParser.Simple_entity_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#simple_entity_expression}.
	 * @param ctx the parse tree
	 */
	void exitSimple_entity_expression(EqlParser.Simple_entity_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#entity_type_expression}.
	 * @param ctx the parse tree
	 */
	void enterEntity_type_expression(EqlParser.Entity_type_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#entity_type_expression}.
	 * @param ctx the parse tree
	 */
	void exitEntity_type_expression(EqlParser.Entity_type_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#type_discriminator}.
	 * @param ctx the parse tree
	 */
	void enterType_discriminator(EqlParser.Type_discriminatorContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#type_discriminator}.
	 * @param ctx the parse tree
	 */
	void exitType_discriminator(EqlParser.Type_discriminatorContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#functions_returning_numerics}.
	 * @param ctx the parse tree
	 */
	void enterFunctions_returning_numerics(EqlParser.Functions_returning_numericsContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#functions_returning_numerics}.
	 * @param ctx the parse tree
	 */
	void exitFunctions_returning_numerics(EqlParser.Functions_returning_numericsContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#functions_returning_datetime}.
	 * @param ctx the parse tree
	 */
	void enterFunctions_returning_datetime(EqlParser.Functions_returning_datetimeContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#functions_returning_datetime}.
	 * @param ctx the parse tree
	 */
	void exitFunctions_returning_datetime(EqlParser.Functions_returning_datetimeContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#functions_returning_strings}.
	 * @param ctx the parse tree
	 */
	void enterFunctions_returning_strings(EqlParser.Functions_returning_stringsContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#functions_returning_strings}.
	 * @param ctx the parse tree
	 */
	void exitFunctions_returning_strings(EqlParser.Functions_returning_stringsContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#trim_specification}.
	 * @param ctx the parse tree
	 */
	void enterTrim_specification(EqlParser.Trim_specificationContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#trim_specification}.
	 * @param ctx the parse tree
	 */
	void exitTrim_specification(EqlParser.Trim_specificationContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#cast_function}.
	 * @param ctx the parse tree
	 */
	void enterCast_function(EqlParser.Cast_functionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#cast_function}.
	 * @param ctx the parse tree
	 */
	void exitCast_function(EqlParser.Cast_functionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#function_invocation}.
	 * @param ctx the parse tree
	 */
	void enterFunction_invocation(EqlParser.Function_invocationContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#function_invocation}.
	 * @param ctx the parse tree
	 */
	void exitFunction_invocation(EqlParser.Function_invocationContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#extract_datetime_field}.
	 * @param ctx the parse tree
	 */
	void enterExtract_datetime_field(EqlParser.Extract_datetime_fieldContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#extract_datetime_field}.
	 * @param ctx the parse tree
	 */
	void exitExtract_datetime_field(EqlParser.Extract_datetime_fieldContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#datetime_field}.
	 * @param ctx the parse tree
	 */
	void enterDatetime_field(EqlParser.Datetime_fieldContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#datetime_field}.
	 * @param ctx the parse tree
	 */
	void exitDatetime_field(EqlParser.Datetime_fieldContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#extract_datetime_part}.
	 * @param ctx the parse tree
	 */
	void enterExtract_datetime_part(EqlParser.Extract_datetime_partContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#extract_datetime_part}.
	 * @param ctx the parse tree
	 */
	void exitExtract_datetime_part(EqlParser.Extract_datetime_partContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#datetime_part}.
	 * @param ctx the parse tree
	 */
	void enterDatetime_part(EqlParser.Datetime_partContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#datetime_part}.
	 * @param ctx the parse tree
	 */
	void exitDatetime_part(EqlParser.Datetime_partContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#function_arg}.
	 * @param ctx the parse tree
	 */
	void enterFunction_arg(EqlParser.Function_argContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#function_arg}.
	 * @param ctx the parse tree
	 */
	void exitFunction_arg(EqlParser.Function_argContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#case_expression}.
	 * @param ctx the parse tree
	 */
	void enterCase_expression(EqlParser.Case_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#case_expression}.
	 * @param ctx the parse tree
	 */
	void exitCase_expression(EqlParser.Case_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#general_case_expression}.
	 * @param ctx the parse tree
	 */
	void enterGeneral_case_expression(EqlParser.General_case_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#general_case_expression}.
	 * @param ctx the parse tree
	 */
	void exitGeneral_case_expression(EqlParser.General_case_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#when_clause}.
	 * @param ctx the parse tree
	 */
	void enterWhen_clause(EqlParser.When_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#when_clause}.
	 * @param ctx the parse tree
	 */
	void exitWhen_clause(EqlParser.When_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#simple_case_expression}.
	 * @param ctx the parse tree
	 */
	void enterSimple_case_expression(EqlParser.Simple_case_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#simple_case_expression}.
	 * @param ctx the parse tree
	 */
	void exitSimple_case_expression(EqlParser.Simple_case_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#case_operand}.
	 * @param ctx the parse tree
	 */
	void enterCase_operand(EqlParser.Case_operandContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#case_operand}.
	 * @param ctx the parse tree
	 */
	void exitCase_operand(EqlParser.Case_operandContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#simple_when_clause}.
	 * @param ctx the parse tree
	 */
	void enterSimple_when_clause(EqlParser.Simple_when_clauseContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#simple_when_clause}.
	 * @param ctx the parse tree
	 */
	void exitSimple_when_clause(EqlParser.Simple_when_clauseContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#coalesce_expression}.
	 * @param ctx the parse tree
	 */
	void enterCoalesce_expression(EqlParser.Coalesce_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#coalesce_expression}.
	 * @param ctx the parse tree
	 */
	void exitCoalesce_expression(EqlParser.Coalesce_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#nullif_expression}.
	 * @param ctx the parse tree
	 */
	void enterNullif_expression(EqlParser.Nullif_expressionContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#nullif_expression}.
	 * @param ctx the parse tree
	 */
	void exitNullif_expression(EqlParser.Nullif_expressionContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#type_literal}.
	 * @param ctx the parse tree
	 */
	void enterType_literal(EqlParser.Type_literalContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#type_literal}.
	 * @param ctx the parse tree
	 */
	void exitType_literal(EqlParser.Type_literalContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#trim_character}.
	 * @param ctx the parse tree
	 */
	void enterTrim_character(EqlParser.Trim_characterContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#trim_character}.
	 * @param ctx the parse tree
	 */
	void exitTrim_character(EqlParser.Trim_characterContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#identification_variable}.
	 * @param ctx the parse tree
	 */
	void enterIdentification_variable(EqlParser.Identification_variableContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#identification_variable}.
	 * @param ctx the parse tree
	 */
	void exitIdentification_variable(EqlParser.Identification_variableContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#constructor_name}.
	 * @param ctx the parse tree
	 */
	void enterConstructor_name(EqlParser.Constructor_nameContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#constructor_name}.
	 * @param ctx the parse tree
	 */
	void exitConstructor_name(EqlParser.Constructor_nameContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#literal}.
	 * @param ctx the parse tree
	 */
	void enterLiteral(EqlParser.LiteralContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#literal}.
	 * @param ctx the parse tree
	 */
	void exitLiteral(EqlParser.LiteralContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#input_parameter}.
	 * @param ctx the parse tree
	 */
	void enterInput_parameter(EqlParser.Input_parameterContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#input_parameter}.
	 * @param ctx the parse tree
	 */
	void exitInput_parameter(EqlParser.Input_parameterContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#pattern_value}.
	 * @param ctx the parse tree
	 */
	void enterPattern_value(EqlParser.Pattern_valueContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#pattern_value}.
	 * @param ctx the parse tree
	 */
	void exitPattern_value(EqlParser.Pattern_valueContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#date_time_timestamp_literal}.
	 * @param ctx the parse tree
	 */
	void enterDate_time_timestamp_literal(EqlParser.Date_time_timestamp_literalContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#date_time_timestamp_literal}.
	 * @param ctx the parse tree
	 */
	void exitDate_time_timestamp_literal(EqlParser.Date_time_timestamp_literalContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#entity_type_literal}.
	 * @param ctx the parse tree
	 */
	void enterEntity_type_literal(EqlParser.Entity_type_literalContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#entity_type_literal}.
	 * @param ctx the parse tree
	 */
	void exitEntity_type_literal(EqlParser.Entity_type_literalContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#escape_character}.
	 * @param ctx the parse tree
	 */
	void enterEscape_character(EqlParser.Escape_characterContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#escape_character}.
	 * @param ctx the parse tree
	 */
	void exitEscape_character(EqlParser.Escape_characterContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#numeric_literal}.
	 * @param ctx the parse tree
	 */
	void enterNumeric_literal(EqlParser.Numeric_literalContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#numeric_literal}.
	 * @param ctx the parse tree
	 */
	void exitNumeric_literal(EqlParser.Numeric_literalContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#boolean_literal}.
	 * @param ctx the parse tree
	 */
	void enterBoolean_literal(EqlParser.Boolean_literalContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#boolean_literal}.
	 * @param ctx the parse tree
	 */
	void exitBoolean_literal(EqlParser.Boolean_literalContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#enum_literal}.
	 * @param ctx the parse tree
	 */
	void enterEnum_literal(EqlParser.Enum_literalContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#enum_literal}.
	 * @param ctx the parse tree
	 */
	void exitEnum_literal(EqlParser.Enum_literalContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#string_literal}.
	 * @param ctx the parse tree
	 */
	void enterString_literal(EqlParser.String_literalContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#string_literal}.
	 * @param ctx the parse tree
	 */
	void exitString_literal(EqlParser.String_literalContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#single_valued_embeddable_object_field}.
	 * @param ctx the parse tree
	 */
	void enterSingle_valued_embeddable_object_field(EqlParser.Single_valued_embeddable_object_fieldContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#single_valued_embeddable_object_field}.
	 * @param ctx the parse tree
	 */
	void exitSingle_valued_embeddable_object_field(EqlParser.Single_valued_embeddable_object_fieldContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#subtype}.
	 * @param ctx the parse tree
	 */
	void enterSubtype(EqlParser.SubtypeContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#subtype}.
	 * @param ctx the parse tree
	 */
	void exitSubtype(EqlParser.SubtypeContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#collection_valued_field}.
	 * @param ctx the parse tree
	 */
	void enterCollection_valued_field(EqlParser.Collection_valued_fieldContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#collection_valued_field}.
	 * @param ctx the parse tree
	 */
	void exitCollection_valued_field(EqlParser.Collection_valued_fieldContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#single_valued_object_field}.
	 * @param ctx the parse tree
	 */
	void enterSingle_valued_object_field(EqlParser.Single_valued_object_fieldContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#single_valued_object_field}.
	 * @param ctx the parse tree
	 */
	void exitSingle_valued_object_field(EqlParser.Single_valued_object_fieldContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#state_field}.
	 * @param ctx the parse tree
	 */
	void enterState_field(EqlParser.State_fieldContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#state_field}.
	 * @param ctx the parse tree
	 */
	void exitState_field(EqlParser.State_fieldContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#collection_value_field}.
	 * @param ctx the parse tree
	 */
	void enterCollection_value_field(EqlParser.Collection_value_fieldContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#collection_value_field}.
	 * @param ctx the parse tree
	 */
	void exitCollection_value_field(EqlParser.Collection_value_fieldContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#entity_name}.
	 * @param ctx the parse tree
	 */
	void enterEntity_name(EqlParser.Entity_nameContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#entity_name}.
	 * @param ctx the parse tree
	 */
	void exitEntity_name(EqlParser.Entity_nameContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#result_variable}.
	 * @param ctx the parse tree
	 */
	void enterResult_variable(EqlParser.Result_variableContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#result_variable}.
	 * @param ctx the parse tree
	 */
	void exitResult_variable(EqlParser.Result_variableContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#superquery_identification_variable}.
	 * @param ctx the parse tree
	 */
	void enterSuperquery_identification_variable(EqlParser.Superquery_identification_variableContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#superquery_identification_variable}.
	 * @param ctx the parse tree
	 */
	void exitSuperquery_identification_variable(EqlParser.Superquery_identification_variableContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#collection_valued_input_parameter}.
	 * @param ctx the parse tree
	 */
	void enterCollection_valued_input_parameter(EqlParser.Collection_valued_input_parameterContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#collection_valued_input_parameter}.
	 * @param ctx the parse tree
	 */
	void exitCollection_valued_input_parameter(EqlParser.Collection_valued_input_parameterContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#single_valued_input_parameter}.
	 * @param ctx the parse tree
	 */
	void enterSingle_valued_input_parameter(EqlParser.Single_valued_input_parameterContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#single_valued_input_parameter}.
	 * @param ctx the parse tree
	 */
	void exitSingle_valued_input_parameter(EqlParser.Single_valued_input_parameterContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#function_name}.
	 * @param ctx the parse tree
	 */
	void enterFunction_name(EqlParser.Function_nameContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#function_name}.
	 * @param ctx the parse tree
	 */
	void exitFunction_name(EqlParser.Function_nameContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#character_valued_input_parameter}.
	 * @param ctx the parse tree
	 */
	void enterCharacter_valued_input_parameter(EqlParser.Character_valued_input_parameterContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#character_valued_input_parameter}.
	 * @param ctx the parse tree
	 */
	void exitCharacter_valued_input_parameter(EqlParser.Character_valued_input_parameterContext ctx);
	/**
	 * Enter a parse tree produced by {@link EqlParser#reserved_word}.
	 * @param ctx the parse tree
	 */
	void enterReserved_word(EqlParser.Reserved_wordContext ctx);
	/**
	 * Exit a parse tree produced by {@link EqlParser#reserved_word}.
	 * @param ctx the parse tree
	 */
	void exitReserved_word(EqlParser.Reserved_wordContext ctx);
}