// Generated from org/springframework/data/jpa/repository/query/Eql.g4 by ANTLR 4.13.2
package org.springframework.data.jpa.repository.query;

/**
 * Implementation of EclipseLink Query Language (EQL)
 * See:
 * * https://eclipse.dev/eclipselink/documentation/3.0/jpa/extensions/jpql.htm
 * * https://wiki.eclipse.org/EclipseLink/UserGuide/JPA/Basic_JPA_Development/Querying/JPQL
 *
 * @author Greg Turnquist
 * @author Christoph Strobl
 * @since 3.2
 */

import org.antlr.v4.runtime.tree.ParseTreeVisitor;

/**
 * This interface defines a complete generic visitor for a parse tree produced
 * by {@link EqlParser}.
 *
 * @param <T> The return type of the visit operation. Use {@link Void} for
 * operations with no return type.
 */
interface EqlVisitor<T> extends ParseTreeVisitor<T> {
	/**
	 * Visit a parse tree produced by {@link EqlParser#start}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitStart(EqlParser.StartContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#ql_statement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitQl_statement(EqlParser.Ql_statementContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#select_statement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelect_statement(EqlParser.Select_statementContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#setOperator}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSetOperator(EqlParser.SetOperatorContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#set_fuction}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSet_fuction(EqlParser.Set_fuctionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#update_statement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitUpdate_statement(EqlParser.Update_statementContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#delete_statement}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDelete_statement(EqlParser.Delete_statementContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#from_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFrom_clause(EqlParser.From_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#identificationVariableDeclarationOrCollectionMemberDeclaration}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIdentificationVariableDeclarationOrCollectionMemberDeclaration(EqlParser.IdentificationVariableDeclarationOrCollectionMemberDeclarationContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#identification_variable_declaration}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIdentification_variable_declaration(EqlParser.Identification_variable_declarationContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#range_variable_declaration}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitRange_variable_declaration(EqlParser.Range_variable_declarationContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#join}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoin(EqlParser.JoinContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#fetch_join}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFetch_join(EqlParser.Fetch_joinContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#join_spec}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoin_spec(EqlParser.Join_specContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#join_condition}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoin_condition(EqlParser.Join_conditionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#join_association_path_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoin_association_path_expression(EqlParser.Join_association_path_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#join_collection_valued_path_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoin_collection_valued_path_expression(EqlParser.Join_collection_valued_path_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#join_single_valued_path_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitJoin_single_valued_path_expression(EqlParser.Join_single_valued_path_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#collection_member_declaration}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollection_member_declaration(EqlParser.Collection_member_declarationContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#qualified_identification_variable}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitQualified_identification_variable(EqlParser.Qualified_identification_variableContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#map_field_identification_variable}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitMap_field_identification_variable(EqlParser.Map_field_identification_variableContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#single_valued_path_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSingle_valued_path_expression(EqlParser.Single_valued_path_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#general_identification_variable}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGeneral_identification_variable(EqlParser.General_identification_variableContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#general_subpath}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGeneral_subpath(EqlParser.General_subpathContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#simple_subpath}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimple_subpath(EqlParser.Simple_subpathContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#treated_subpath}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTreated_subpath(EqlParser.Treated_subpathContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#state_field_path_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitState_field_path_expression(EqlParser.State_field_path_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#state_valued_path_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitState_valued_path_expression(EqlParser.State_valued_path_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#single_valued_object_path_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSingle_valued_object_path_expression(EqlParser.Single_valued_object_path_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#collection_valued_path_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollection_valued_path_expression(EqlParser.Collection_valued_path_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#update_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitUpdate_clause(EqlParser.Update_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#update_item}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitUpdate_item(EqlParser.Update_itemContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#new_value}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNew_value(EqlParser.New_valueContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#delete_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDelete_clause(EqlParser.Delete_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#select_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelect_clause(EqlParser.Select_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#select_item}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelect_item(EqlParser.Select_itemContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#select_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSelect_expression(EqlParser.Select_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#constructor_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitConstructor_expression(EqlParser.Constructor_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#constructor_item}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitConstructor_item(EqlParser.Constructor_itemContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#aggregate_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAggregate_expression(EqlParser.Aggregate_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#where_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitWhere_clause(EqlParser.Where_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#groupby_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGroupby_clause(EqlParser.Groupby_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#groupby_item}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGroupby_item(EqlParser.Groupby_itemContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#having_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitHaving_clause(EqlParser.Having_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#orderby_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOrderby_clause(EqlParser.Orderby_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#orderby_item}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitOrderby_item(EqlParser.Orderby_itemContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#nullsPrecedence}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNullsPrecedence(EqlParser.NullsPrecedenceContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#subquery}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubquery(EqlParser.SubqueryContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#subquery_from_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubquery_from_clause(EqlParser.Subquery_from_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#subselect_identification_variable_declaration}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubselect_identification_variable_declaration(EqlParser.Subselect_identification_variable_declarationContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#derived_path_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDerived_path_expression(EqlParser.Derived_path_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#general_derived_path}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGeneral_derived_path(EqlParser.General_derived_pathContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#simple_derived_path}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimple_derived_path(EqlParser.Simple_derived_pathContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#treated_derived_path}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTreated_derived_path(EqlParser.Treated_derived_pathContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#derived_collection_member_declaration}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDerived_collection_member_declaration(EqlParser.Derived_collection_member_declarationContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#simple_select_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimple_select_clause(EqlParser.Simple_select_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#simple_select_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimple_select_expression(EqlParser.Simple_select_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#scalar_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitScalar_expression(EqlParser.Scalar_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#conditional_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitConditional_expression(EqlParser.Conditional_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#conditional_term}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitConditional_term(EqlParser.Conditional_termContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#conditional_factor}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitConditional_factor(EqlParser.Conditional_factorContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#conditional_primary}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitConditional_primary(EqlParser.Conditional_primaryContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#simple_cond_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimple_cond_expression(EqlParser.Simple_cond_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#between_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitBetween_expression(EqlParser.Between_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#in_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIn_expression(EqlParser.In_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#in_item}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIn_item(EqlParser.In_itemContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#like_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLike_expression(EqlParser.Like_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#null_comparison_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNull_comparison_expression(EqlParser.Null_comparison_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#empty_collection_comparison_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEmpty_collection_comparison_expression(EqlParser.Empty_collection_comparison_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#collection_member_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollection_member_expression(EqlParser.Collection_member_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#entity_or_value_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntity_or_value_expression(EqlParser.Entity_or_value_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#simple_entity_or_value_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimple_entity_or_value_expression(EqlParser.Simple_entity_or_value_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#exists_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExists_expression(EqlParser.Exists_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#all_or_any_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitAll_or_any_expression(EqlParser.All_or_any_expressionContext ctx);
	/**
	 * Visit a parse tree produced by the {@code StringComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitStringComparison(EqlParser.StringComparisonContext ctx);
	/**
	 * Visit a parse tree produced by the {@code BooleanComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitBooleanComparison(EqlParser.BooleanComparisonContext ctx);
	/**
	 * Visit a parse tree produced by the {@code DirectBooleanCheck}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDirectBooleanCheck(EqlParser.DirectBooleanCheckContext ctx);
	/**
	 * Visit a parse tree produced by the {@code EnumComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEnumComparison(EqlParser.EnumComparisonContext ctx);
	/**
	 * Visit a parse tree produced by the {@code DatetimeComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDatetimeComparison(EqlParser.DatetimeComparisonContext ctx);
	/**
	 * Visit a parse tree produced by the {@code EntityComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityComparison(EqlParser.EntityComparisonContext ctx);
	/**
	 * Visit a parse tree produced by the {@code ArithmeticComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitArithmeticComparison(EqlParser.ArithmeticComparisonContext ctx);
	/**
	 * Visit a parse tree produced by the {@code EntityTypeComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntityTypeComparison(EqlParser.EntityTypeComparisonContext ctx);
	/**
	 * Visit a parse tree produced by the {@code RegexpComparison}
	 * labeled alternative in {@link EqlParser#comparison_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitRegexpComparison(EqlParser.RegexpComparisonContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#comparison_operator}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitComparison_operator(EqlParser.Comparison_operatorContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#arithmetic_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitArithmetic_expression(EqlParser.Arithmetic_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#arithmetic_term}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitArithmetic_term(EqlParser.Arithmetic_termContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#arithmetic_factor}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitArithmetic_factor(EqlParser.Arithmetic_factorContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#arithmetic_primary}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitArithmetic_primary(EqlParser.Arithmetic_primaryContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#string_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitString_expression(EqlParser.String_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#datetime_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDatetime_expression(EqlParser.Datetime_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#boolean_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitBoolean_expression(EqlParser.Boolean_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#enum_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEnum_expression(EqlParser.Enum_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#entity_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntity_expression(EqlParser.Entity_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#simple_entity_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimple_entity_expression(EqlParser.Simple_entity_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#entity_type_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntity_type_expression(EqlParser.Entity_type_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#type_discriminator}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitType_discriminator(EqlParser.Type_discriminatorContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#functions_returning_numerics}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFunctions_returning_numerics(EqlParser.Functions_returning_numericsContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#functions_returning_datetime}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFunctions_returning_datetime(EqlParser.Functions_returning_datetimeContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#functions_returning_strings}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFunctions_returning_strings(EqlParser.Functions_returning_stringsContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#trim_specification}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTrim_specification(EqlParser.Trim_specificationContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#cast_function}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCast_function(EqlParser.Cast_functionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#function_invocation}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFunction_invocation(EqlParser.Function_invocationContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#extract_datetime_field}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExtract_datetime_field(EqlParser.Extract_datetime_fieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#datetime_field}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDatetime_field(EqlParser.Datetime_fieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#extract_datetime_part}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitExtract_datetime_part(EqlParser.Extract_datetime_partContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#datetime_part}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDatetime_part(EqlParser.Datetime_partContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#function_arg}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFunction_arg(EqlParser.Function_argContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#case_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCase_expression(EqlParser.Case_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#general_case_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitGeneral_case_expression(EqlParser.General_case_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#when_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitWhen_clause(EqlParser.When_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#simple_case_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimple_case_expression(EqlParser.Simple_case_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#case_operand}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCase_operand(EqlParser.Case_operandContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#simple_when_clause}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSimple_when_clause(EqlParser.Simple_when_clauseContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#coalesce_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCoalesce_expression(EqlParser.Coalesce_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#nullif_expression}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNullif_expression(EqlParser.Nullif_expressionContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#type_literal}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitType_literal(EqlParser.Type_literalContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#trim_character}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitTrim_character(EqlParser.Trim_characterContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#identification_variable}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitIdentification_variable(EqlParser.Identification_variableContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#constructor_name}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitConstructor_name(EqlParser.Constructor_nameContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#literal}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitLiteral(EqlParser.LiteralContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#input_parameter}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitInput_parameter(EqlParser.Input_parameterContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#pattern_value}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitPattern_value(EqlParser.Pattern_valueContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#date_time_timestamp_literal}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitDate_time_timestamp_literal(EqlParser.Date_time_timestamp_literalContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#entity_type_literal}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntity_type_literal(EqlParser.Entity_type_literalContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#escape_character}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEscape_character(EqlParser.Escape_characterContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#numeric_literal}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitNumeric_literal(EqlParser.Numeric_literalContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#boolean_literal}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitBoolean_literal(EqlParser.Boolean_literalContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#enum_literal}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEnum_literal(EqlParser.Enum_literalContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#string_literal}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitString_literal(EqlParser.String_literalContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#single_valued_embeddable_object_field}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSingle_valued_embeddable_object_field(EqlParser.Single_valued_embeddable_object_fieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#subtype}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSubtype(EqlParser.SubtypeContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#collection_valued_field}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollection_valued_field(EqlParser.Collection_valued_fieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#single_valued_object_field}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSingle_valued_object_field(EqlParser.Single_valued_object_fieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#state_field}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitState_field(EqlParser.State_fieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#collection_value_field}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollection_value_field(EqlParser.Collection_value_fieldContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#entity_name}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitEntity_name(EqlParser.Entity_nameContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#result_variable}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitResult_variable(EqlParser.Result_variableContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#superquery_identification_variable}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSuperquery_identification_variable(EqlParser.Superquery_identification_variableContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#collection_valued_input_parameter}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCollection_valued_input_parameter(EqlParser.Collection_valued_input_parameterContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#single_valued_input_parameter}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitSingle_valued_input_parameter(EqlParser.Single_valued_input_parameterContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#function_name}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitFunction_name(EqlParser.Function_nameContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#character_valued_input_parameter}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitCharacter_valued_input_parameter(EqlParser.Character_valued_input_parameterContext ctx);
	/**
	 * Visit a parse tree produced by {@link EqlParser#reserved_word}.
	 * @param ctx the parse tree
	 * @return the visitor result
	 */
	T visitReserved_word(EqlParser.Reserved_wordContext ctx);
}