/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ParameterBinding {
    private final BindingIdentifier identifier;
    private final ParameterOrigin origin;

    ParameterBinding(BindingIdentifier identifier, ParameterOrigin origin) {
        Assert.notNull((Object)identifier, (String)"BindingIdentifier must not be null");
        Assert.notNull((Object)origin, (String)"ParameterOrigin must not be null");
        this.identifier = identifier;
        this.origin = origin;
    }

    public BindingIdentifier getIdentifier() {
        return this.identifier;
    }

    public ParameterOrigin getOrigin() {
        return this.origin;
    }

    @Nullable
    public String getName() {
        return this.identifier.hasName() ? this.identifier.getName() : null;
    }

    String getRequiredName() throws IllegalStateException {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        throw new IllegalStateException(String.format("Required name for %s not available", this));
    }

    @Nullable
    Integer getPosition() {
        return this.identifier.hasPosition() ? Integer.valueOf(this.identifier.getPosition()) : null;
    }

    int getRequiredPosition() throws IllegalStateException {
        Integer position = this.getPosition();
        if (position != null) {
            return position;
        }
        throw new IllegalStateException(String.format("Required position for %s not available", this));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterBinding that = (ParameterBinding)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.identifier, (Object)that.identifier)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.origin, (Object)that.origin);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.identifier);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.origin);
        return result;
    }

    public String toString() {
        return String.format("ParameterBinding [identifier: %s, origin: %s]", this.identifier, this.origin);
    }

    @Nullable
    public Object prepare(@Nullable Object valueToBind) {
        return valueToBind;
    }

    public boolean bindsTo(ParameterBinding other) {
        if (this.getIdentifier().equals(other.getIdentifier())) {
            return true;
        }
        if (this.identifier.hasName() && other.identifier.hasName() && this.identifier.getName().equals(other.identifier.getName())) {
            return true;
        }
        return this.identifier.hasPosition() && other.identifier.hasPosition() && this.identifier.getPosition() == other.identifier.getPosition();
    }

    public boolean isCompatibleWith(ParameterBinding other) {
        return other.getClass() == this.getClass() && other.getOrigin().equals(this.getOrigin());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface BindingIdentifier {
        public static BindingIdentifier of(String name) {
            Assert.hasText((String)name, (String)"Name must not be empty");
            return new Named(name);
        }

        public static BindingIdentifier of(int position) {
            Assert.isTrue((position > 0 ? 1 : 0) != 0, (String)"Index position must be greater zero");
            return new Indexed(position);
        }

        public static BindingIdentifier of(String name, int position) {
            Assert.hasText((String)name, (String)"Name must not be empty");
            return new NamedAndIndexed(name, position);
        }

        default public boolean hasName() {
            return false;
        }

        default public boolean hasPosition() {
            return false;
        }

        default public String getName() {
            throw new IllegalStateException("No name associated");
        }

        default public int getPosition() {
            throw new IllegalStateException("No position associated");
        }
    }

    public record Expression(ValueExpression expression) implements ParameterOrigin
    {
        @Override
        public boolean isMethodArgument() {
            return false;
        }

        @Override
        public boolean isExpression() {
            return true;
        }

        @Override
        public boolean isSynthetic() {
            return true;
        }
    }

    static class InParameterBinding
    extends ParameterBinding {
        InParameterBinding(BindingIdentifier identifier, ParameterOrigin origin) {
            super(identifier, origin);
        }

        @Override
        @Nullable
        public Object prepare(@Nullable Object value) {
            if (!ObjectUtils.isArray((Object)value)) {
                return value;
            }
            int length = Array.getLength(value);
            ArrayList<Object> result = new ArrayList<Object>(length);
            int i = 0;
            while (i < length) {
                result.add(Array.get(value, i));
                ++i;
            }
            return result;
        }
    }

    private record Indexed(int position) implements BindingIdentifier
    {
        @Override
        public boolean hasPosition() {
            return true;
        }

        @Override
        public int getPosition() {
            return this.position();
        }

        @Override
        public String toString() {
            return "[" + this.position() + "]";
        }
    }

    static class LikeParameterBinding
    extends ParameterBinding {
        private static final List<Part.Type> SUPPORTED_TYPES = Arrays.asList(Part.Type.CONTAINING, Part.Type.STARTING_WITH, Part.Type.ENDING_WITH, Part.Type.LIKE);
        private final Part.Type type;

        LikeParameterBinding(BindingIdentifier identifier, ParameterOrigin origin, Part.Type type) {
            super(identifier, origin);
            Assert.notNull((Object)type, (String)"Type must not be null");
            Assert.isTrue((boolean)SUPPORTED_TYPES.contains(type), (String)String.format("Type must be one of %s", StringUtils.collectionToCommaDelimitedString(SUPPORTED_TYPES)));
            this.type = type;
        }

        public Part.Type getType() {
            return this.type;
        }

        @Override
        @Nullable
        public Object prepare(@Nullable Object value) {
            Object unwrapped = PersistenceProvider.unwrapTypedParameterValue(value);
            if (unwrapped == null) {
                return null;
            }
            return switch (this.type) {
                case Part.Type.STARTING_WITH -> String.format("%s%%", unwrapped);
                case Part.Type.ENDING_WITH -> String.format("%%%s", unwrapped);
                case Part.Type.CONTAINING -> String.format("%%%s%%", unwrapped);
                default -> unwrapped;
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object obj) {
            void that;
            if (!(obj instanceof LikeParameterBinding)) {
                return false;
            }
            LikeParameterBinding likeParameterBinding = (LikeParameterBinding)obj;
            return super.equals(obj) && this.type.equals((Object)that.type);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result += ObjectUtils.nullSafeHashCode((Object)this.type);
        }

        @Override
        public String toString() {
            return String.format("LikeBinding [identifier: %s, origin: %s, type: %s]", this.getIdentifier(), this.getOrigin(), this.getType());
        }

        @Override
        public boolean isCompatibleWith(ParameterBinding binding) {
            if (super.isCompatibleWith(binding) && binding instanceof LikeParameterBinding) {
                LikeParameterBinding other = (LikeParameterBinding)binding;
                return this.getType() == other.getType();
            }
            return false;
        }

        static Part.Type getLikeTypeFrom(String expression) {
            Assert.hasText((String)expression, (String)"Expression must not be null or empty");
            if (expression.matches("%.*%")) {
                return Part.Type.CONTAINING;
            }
            if (expression.startsWith("%")) {
                return Part.Type.ENDING_WITH;
            }
            if (expression.endsWith("%")) {
                return Part.Type.STARTING_WITH;
            }
            return Part.Type.LIKE;
        }
    }

    public record MethodInvocationArgument(BindingIdentifier identifier) implements ParameterOrigin
    {
        @Override
        public boolean isMethodArgument() {
            return true;
        }

        @Override
        public boolean isExpression() {
            return false;
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }
    }

    private record Named(String name) implements BindingIdentifier
    {
        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String toString() {
            return this.name();
        }
    }

    private record NamedAndIndexed(String name, int position) implements BindingIdentifier
    {
        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public boolean hasPosition() {
            return true;
        }

        @Override
        public int getPosition() {
            return this.position();
        }

        @Override
        public String toString() {
            return "[" + this.name() + ", " + this.position() + "]";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ParameterOrigin {
        public static Expression ofExpression(ValueExpression expression) {
            return new Expression(expression);
        }

        public static Synthetic synthetic(@Nullable Object value, Object source) {
            return new Synthetic(value, source);
        }

        public static MethodInvocationArgument ofParameter(String name) {
            return ParameterOrigin.ofParameter(name, null);
        }

        public static MethodInvocationArgument ofParameter(@Nullable String name, @Nullable Integer position) {
            BindingIdentifier identifier;
            if (!ObjectUtils.isEmpty((Object)name) && position != null) {
                identifier = BindingIdentifier.of(name, position);
            } else if (!ObjectUtils.isEmpty((Object)name)) {
                identifier = BindingIdentifier.of(name);
            } else if (position != null) {
                identifier = BindingIdentifier.of(position);
            } else {
                throw new IllegalStateException("Neither name nor position available for binding");
            }
            return ParameterOrigin.ofParameter(identifier);
        }

        public static MethodInvocationArgument ofParameter(Parameter parameter) {
            return ParameterOrigin.ofParameter(parameter.getIndex() + 1);
        }

        public static MethodInvocationArgument ofParameter(int position) {
            return ParameterOrigin.ofParameter(BindingIdentifier.of(position));
        }

        public static MethodInvocationArgument ofParameter(BindingIdentifier identifier) {
            return new MethodInvocationArgument(identifier);
        }

        public boolean isMethodArgument();

        public boolean isExpression();

        public boolean isSynthetic();
    }

    static class PartTreeParameterBinding
    extends ParameterBinding {
        private final Class<?> parameterType;
        private final JpqlQueryTemplates templates;
        private final EscapeCharacter escape;
        private final Part.Type type;
        private final boolean ignoreCase;
        private final boolean noWildcards;

        public PartTreeParameterBinding(BindingIdentifier identifier, ParameterOrigin origin, Class<?> parameterType, Part part, @Nullable Object value, JpqlQueryTemplates templates, EscapeCharacter escape) {
            super(identifier, origin);
            this.parameterType = parameterType;
            this.templates = templates;
            this.escape = escape;
            this.type = value == null && (Part.Type.SIMPLE_PROPERTY.equals((Object)part.getType()) || Part.Type.NEGATING_SIMPLE_PROPERTY.equals((Object)part.getType())) ? Part.Type.IS_NULL : part.getType();
            this.ignoreCase = Part.IgnoreCaseType.ALWAYS.equals((Object)part.shouldIgnoreCase());
            this.noWildcards = part.getProperty().getLeafProperty().isCollection();
        }

        public boolean isIsNullParameter() {
            return Part.Type.IS_NULL.equals((Object)this.type);
        }

        @Override
        @Nullable
        public Object prepare(@Nullable Object value) {
            if (value == null || this.parameterType == null) {
                return value;
            }
            if (String.class.equals(this.parameterType) && !this.noWildcards) {
                return switch (this.type) {
                    case Part.Type.STARTING_WITH -> String.format("%s%%", this.escape.escape(value.toString()));
                    case Part.Type.ENDING_WITH -> String.format("%%%s", this.escape.escape(value.toString()));
                    case Part.Type.NOT_CONTAINING, Part.Type.CONTAINING -> String.format("%%%s%%", this.escape.escape(value.toString()));
                    default -> value;
                };
            }
            return Collection.class.isAssignableFrom(this.parameterType) ? this.potentiallyIgnoreCase(this.ignoreCase, PartTreeParameterBinding.toCollection(value)) : value;
        }

        @Nullable
        @Contract(value="false, _ -> param2; _, null -> null; true, !null -> new)")
        private Collection<?> potentiallyIgnoreCase(boolean ignoreCase, @Nullable Collection<?> collection) {
            if (!ignoreCase || CollectionUtils.isEmpty(collection)) {
                return collection;
            }
            return collection.stream().map(it -> it == null ? null : this.templates.ignoreCase((String)it)).collect(Collectors.toList());
        }

        @Nullable
        private static Collection<?> toCollection(@Nullable Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return collection.isEmpty() ? null : collection;
            }
            if (ObjectUtils.isArray((Object)value)) {
                List<Object> collection = Arrays.asList(ObjectUtils.toObjectArray((Object)value));
                return collection.isEmpty() ? null : collection;
            }
            return Collections.singleton(value);
        }
    }

    public record Synthetic(@Nullable Object value, Object source) implements ParameterOrigin
    {
        @Override
        public boolean isMethodArgument() {
            return false;
        }

        @Override
        public boolean isExpression() {
            return false;
        }

        @Override
        public boolean isSynthetic() {
            return true;
        }
    }
}

