/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.expression.Expression;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class ParameterMetadataProvider {
    private final Iterator<? extends Parameter> parameters;
    private final List<ParameterBinding> bindings;
    @Nullable
    private final Iterator<Object> bindableParameterValues;
    private final EscapeCharacter escape;
    private final JpqlQueryTemplates templates;
    private final JpaParameters jpaParameters;
    private int position;

    public ParameterMetadataProvider(JpaParametersParameterAccessor accessor, EscapeCharacter escape, JpqlQueryTemplates templates) {
        this(accessor.iterator(), accessor.getParameters(), escape, templates);
    }

    public ParameterMetadataProvider(JpaParameters parameters, EscapeCharacter escape, JpqlQueryTemplates templates) {
        this(null, parameters, escape, templates);
    }

    private ParameterMetadataProvider(@Nullable Iterator<Object> bindableParameterValues, JpaParameters parameters, EscapeCharacter escape, JpqlQueryTemplates templates) {
        Assert.notNull((Object)((Object)parameters), (String)"Parameters must not be null");
        Assert.notNull((Object)escape, (String)"EscapeCharacter must not be null");
        Assert.notNull((Object)templates, (String)"JpqlQueryTemplates must not be null");
        this.jpaParameters = parameters;
        this.parameters = ((JpaParameters)parameters.getBindableParameters()).iterator();
        this.bindings = new ArrayList<ParameterBinding>();
        this.bindableParameterValues = bindableParameterValues;
        this.escape = escape;
        this.templates = templates;
    }

    public List<ParameterBinding> getBindings() {
        return this.bindings;
    }

    public <T> ParameterBinding.PartTreeParameterBinding next(Part part) {
        Assert.isTrue((boolean)this.parameters.hasNext(), () -> String.format("No parameter available for part %s", part));
        Parameter parameter = this.parameters.next();
        return this.next(part, parameter.getType(), parameter);
    }

    public <T> ParameterBinding.PartTreeParameterBinding next(Part part, Class<T> type) {
        Parameter parameter = this.parameters.next();
        Class typeToUse = ClassUtils.isAssignable(type, (Class)parameter.getType()) ? parameter.getType() : type;
        return this.next(part, typeToUse, parameter);
    }

    private <T> ParameterBinding.PartTreeParameterBinding next(Part part, Class<T> type, Parameter parameter) {
        Assert.notNull(type, (String)"Type must not be null");
        Class reifiedType = Expression.class.equals(type) ? Object.class : type;
        Object value = this.bindableParameterValues == null ? ParameterMetadata.PLACEHOLDER : this.bindableParameterValues.next();
        int currentPosition = ++this.position;
        ParameterBinding.BindingIdentifier bindingIdentifier = ParameterBinding.BindingIdentifier.of(currentPosition);
        ParameterBinding.MethodInvocationArgument methodParameter = ParameterBinding.ParameterOrigin.ofParameter(bindingIdentifier);
        ParameterBinding.PartTreeParameterBinding binding = new ParameterBinding.PartTreeParameterBinding(bindingIdentifier, methodParameter, reifiedType, part, value, this.templates, this.escape);
        this.bindings.add(binding);
        return binding;
    }

    EscapeCharacter getEscape() {
        return this.escape;
    }

    public ParameterBinding nextSynthetic(Object value, Object source) {
        int currentPosition = ++this.position;
        return new ParameterBinding(ParameterBinding.BindingIdentifier.of(currentPosition), ParameterBinding.ParameterOrigin.synthetic(value, source));
    }

    public JpaParameters getParameters() {
        return this.jpaParameters;
    }

    public static class ParameterMetadata {
        static final Object PLACEHOLDER = new Object();
        private final Class<?> parameterType;
        private final Part.Type type;
        private final int position;
        private final JpqlQueryTemplates templates;
        private final EscapeCharacter escape;
        private final boolean ignoreCase;
        private final boolean noWildcards;

        public ParameterMetadata(Class<?> parameterType, Part part, @Nullable Object value, EscapeCharacter escape, int position, JpqlQueryTemplates templates) {
            this.parameterType = parameterType;
            this.position = position;
            this.templates = templates;
            this.type = value == null && (Part.Type.SIMPLE_PROPERTY.equals((Object)part.getType()) || Part.Type.NEGATING_SIMPLE_PROPERTY.equals((Object)part.getType())) ? Part.Type.IS_NULL : part.getType();
            this.ignoreCase = Part.IgnoreCaseType.ALWAYS.equals((Object)part.shouldIgnoreCase());
            this.noWildcards = part.getProperty().getLeafProperty().isCollection();
            this.escape = escape;
        }

        public int getPosition() {
            return this.position;
        }

        public Class<?> getParameterType() {
            return this.parameterType;
        }

        public boolean isIsNullParameter() {
            return Part.Type.IS_NULL.equals((Object)this.type);
        }

        @Nullable
        public Object prepare(@Nullable Object value) {
            if (value == null || this.parameterType == null) {
                return value;
            }
            if (String.class.equals(this.parameterType) && !this.noWildcards) {
                return switch (this.type) {
                    case Part.Type.STARTING_WITH -> String.format("%s%%", this.escape.escape(value.toString()));
                    case Part.Type.ENDING_WITH -> String.format("%%%s", this.escape.escape(value.toString()));
                    case Part.Type.NOT_CONTAINING, Part.Type.CONTAINING -> String.format("%%%s%%", this.escape.escape(value.toString()));
                    default -> value;
                };
            }
            return Collection.class.isAssignableFrom(this.parameterType) ? this.potentiallyIgnoreCase(this.ignoreCase, ParameterMetadata.toCollection(value)) : value;
        }

        @Nullable
        private static Collection<?> toCollection(@Nullable Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return collection.isEmpty() ? null : collection;
            }
            if (ObjectUtils.isArray((Object)value)) {
                List<Object> collection = Arrays.asList(ObjectUtils.toObjectArray((Object)value));
                return collection.isEmpty() ? null : collection;
            }
            return Collections.singleton(value);
        }

        @Nullable
        private Collection<?> potentiallyIgnoreCase(boolean ignoreCase, @Nullable Collection<?> collection) {
            if (!ignoreCase || CollectionUtils.isEmpty(collection)) {
                return collection;
            }
            return collection.stream().map(it -> it == null ? null : this.templates.ignoreCase((String)it)).collect(Collectors.toList());
        }
    }
}

