/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.ProcedureParameter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class StoredProcedureAttributes {
    static final String SYNTHETIC_OUTPUT_PARAMETER_NAME = "out";
    private final boolean namedStoredProcedure;
    private final String procedureName;
    private final List<ProcedureParameter> outputProcedureParameters;

    StoredProcedureAttributes(String procedureName, ProcedureParameter parameter) {
        this(procedureName, Collections.singletonList(parameter), false);
    }

    StoredProcedureAttributes(String procedureName, List<ProcedureParameter> outputProcedureParameters, boolean namedStoredProcedure) {
        Assert.notNull((Object)procedureName, (String)"ProcedureName must not be null");
        Assert.notNull(outputProcedureParameters, (String)"OutputProcedureParameters must not be null");
        Assert.isTrue((outputProcedureParameters.size() != 1 || outputProcedureParameters.get(0) != null ? 1 : 0) != 0, (String)"ProcedureParameters must not have size 1 with a null value");
        this.procedureName = procedureName;
        this.namedStoredProcedure = namedStoredProcedure;
        this.outputProcedureParameters = namedStoredProcedure ? outputProcedureParameters : this.getParametersWithCompletedNames(outputProcedureParameters);
    }

    private List<ProcedureParameter> getParametersWithCompletedNames(List<ProcedureParameter> procedureParameters) {
        return IntStream.range(0, procedureParameters.size()).mapToObj(i -> this.getParameterWithCompletedName((ProcedureParameter)procedureParameters.get(i), i)).collect(Collectors.toList());
    }

    private ProcedureParameter getParameterWithCompletedName(ProcedureParameter parameter, int i) {
        return new ProcedureParameter(this.completeOutputParameterName(i, parameter.getName()), parameter.getPosition(), parameter.getMode(), parameter.getType());
    }

    private String completeOutputParameterName(int i, @Nullable String paramName) {
        return StringUtils.hasText((String)paramName) ? paramName : this.createSyntheticParameterName(i);
    }

    private String createSyntheticParameterName(int i) {
        return SYNTHETIC_OUTPUT_PARAMETER_NAME + String.valueOf(i == 0 ? "" : Integer.valueOf(i));
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public boolean isNamedStoredProcedure() {
        return this.namedStoredProcedure;
    }

    public List<ProcedureParameter> getOutputProcedureParameters() {
        return this.outputProcedureParameters;
    }

    public boolean hasReturnValue() {
        if (this.getOutputProcedureParameters().isEmpty()) {
            return false;
        }
        for (ProcedureParameter parameter : this.getOutputProcedureParameters()) {
            if (ClassUtils.isVoidType(parameter.getType())) continue;
            return true;
        }
        return false;
    }
}

