/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.Entity;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultJpaEntityMetadata<T>
implements JpaEntityMetadata<T> {
    private final Class<T> domainType;
    @Nullable
    private final Entity entity;

    public DefaultJpaEntityMetadata(Class<T> domainType) {
        Assert.notNull(domainType, (String)"Domain type must not be null");
        this.domainType = domainType;
        this.entity = (Entity)AnnotatedElementUtils.findMergedAnnotation(domainType, Entity.class);
    }

    public Class<T> getJavaType() {
        return this.domainType;
    }

    @Override
    public String getEntityName() {
        return this.getEntityNameOr(DefaultJpaEntityMetadata::unqualify);
    }

    private String getEntityNameOr(Function<Class<?>, String> alternative) {
        return this.entity != null && StringUtils.hasText((String)this.entity.name()) ? this.entity.name() : alternative.apply(this.domainType);
    }

    static String unqualify(Class<?> clazz) {
        return DefaultJpaEntityMetadata.unqualify(clazz.getName());
    }

    static String unqualify(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        return loc < 0 ? qualifiedName : qualifiedName.substring(loc + 1);
    }
}

