/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.Parameter;
import jakarta.persistence.TemporalType;
import java.util.Iterator;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.ParametrizedQuery;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.util.Assert;

abstract class QueryParameterSetterFactory {
    QueryParameterSetterFactory() {
    }

    @Nullable
    abstract QueryParameterSetter create(ParameterBinding var1, ParametrizedQuery var2);

    static QueryParameterSetterFactory basic(JpaParameters parameters, boolean preferNamedParameters) {
        return new BasicQueryParameterSetterFactory(parameters, preferNamedParameters);
    }

    static QueryParameterSetterFactory forPartTreeQuery(JpaParameters parameters) {
        return new PartTreeQueryParameterSetterFactory(parameters);
    }

    static QueryParameterSetterFactory forSynthetic() {
        return new SyntheticParameterSetterFactory();
    }

    static QueryParameterSetterFactory parsing(ValueExpressionParser parser, ValueEvaluationContextProvider evaluationContextProvider) {
        return new ExpressionBasedQueryParameterSetterFactory(parser, evaluationContextProvider);
    }

    private static QueryParameterSetter createSetter(Function<JpaParametersParameterAccessor, @Nullable Object> valueExtractor, ParameterBinding binding, @Nullable JpaParameters.JpaParameter parameter) {
        TemporalType temporalType = parameter != null && parameter.isTemporalParameter() ? parameter.getRequiredTemporalType() : null;
        return QueryParameterSetter.create(valueExtractor.andThen(binding::prepare), ParameterImpl.of(parameter, binding), temporalType);
    }

    @Nullable
    static JpaParameters.JpaParameter findParameterForBinding(Parameters<JpaParameters, JpaParameters.JpaParameter> parameters, String name) {
        JpaParameters bindableParameters = (JpaParameters)parameters.getBindableParameters();
        Iterator iterator = bindableParameters.iterator();
        while (iterator.hasNext()) {
            JpaParameters.JpaParameter bindableParameter = (JpaParameters.JpaParameter)((Object)iterator.next());
            if (!name.equals(QueryParameterSetterFactory.getRequiredName(bindableParameter))) continue;
            return bindableParameter;
        }
        return null;
    }

    private static String getRequiredName(JpaParameters.JpaParameter p) {
        return (String)p.getName().orElseThrow(() -> new IllegalStateException("For queries with named parameters you need to provide names for method parameters; Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters"));
    }

    static JpaParameters.JpaParameter findParameterForBinding(Parameters<JpaParameters, JpaParameters.JpaParameter> parameters, int parameterIndex) {
        JpaParameters bindableParameters = (JpaParameters)parameters.getBindableParameters();
        Assert.isTrue((parameterIndex < bindableParameters.getNumberOfParameters() ? 1 : 0) != 0, () -> String.format("At least %s parameter(s) provided but only %s parameter(s) present in query", parameterIndex + 1, bindableParameters.getNumberOfParameters()));
        return (JpaParameters.JpaParameter)bindableParameters.getParameter(parameterIndex);
    }

    private static class BasicQueryParameterSetterFactory
    extends QueryParameterSetterFactory {
        private final JpaParameters parameters;
        private final boolean preferNamedParameters;

        BasicQueryParameterSetterFactory(JpaParameters parameters, boolean preferNamedParameters) {
            Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null");
            this.parameters = parameters;
            this.preferNamedParameters = preferNamedParameters;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public QueryParameterSetter create(ParameterBinding binding, ParametrizedQuery query) {
            void mia;
            Assert.notNull((Object)binding, (String)"Binding must not be null");
            ParameterBinding.ParameterOrigin parameterOrigin = binding.getOrigin();
            if (!(parameterOrigin instanceof ParameterBinding.MethodInvocationArgument)) {
                return null;
            }
            ParameterBinding.MethodInvocationArgument methodInvocationArgument = (ParameterBinding.MethodInvocationArgument)parameterOrigin;
            ParameterBinding.BindingIdentifier identifier = mia.identifier();
            JpaParameters.JpaParameter parameter = this.preferNamedParameters && identifier.hasName() ? BasicQueryParameterSetterFactory.findParameterForBinding((Parameters<JpaParameters, JpaParameters.JpaParameter>)this.parameters, identifier.getName()) : (identifier.hasPosition() ? BasicQueryParameterSetterFactory.findParameterForBinding((Parameters<JpaParameters, JpaParameters.JpaParameter>)this.parameters, identifier.getPosition() - 1) : null);
            return parameter == null ? QueryParameterSetter.NOOP : QueryParameterSetterFactory.createSetter(values -> this.getValue((JpaParametersParameterAccessor)((Object)values), parameter), binding, parameter);
        }

        @Nullable
        protected Object getValue(JpaParametersParameterAccessor accessor, org.springframework.data.repository.query.Parameter parameter) {
            return accessor.getValue(parameter);
        }
    }

    private static class ExpressionBasedQueryParameterSetterFactory
    extends QueryParameterSetterFactory {
        private final ValueExpressionParser parser;
        private final ValueEvaluationContextProvider evaluationContextProvider;

        ExpressionBasedQueryParameterSetterFactory(ValueExpressionParser parser, ValueEvaluationContextProvider evaluationContextProvider) {
            Assert.notNull((Object)parser, (String)"ValueExpressionParser must not be null");
            Assert.notNull((Object)evaluationContextProvider, (String)"ValueEvaluationContextProvider must not be null");
            this.parser = parser;
            this.evaluationContextProvider = evaluationContextProvider;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public QueryParameterSetter create(ParameterBinding binding, ParametrizedQuery parametrizedQuery) {
            void e;
            ParameterBinding.ParameterOrigin parameterOrigin = binding.getOrigin();
            if (!(parameterOrigin instanceof ParameterBinding.Expression)) {
                return null;
            }
            ParameterBinding.Expression expression = (ParameterBinding.Expression)parameterOrigin;
            return QueryParameterSetterFactory.createSetter(arg_0 -> this.lambda$0((ParameterBinding.Expression)e, arg_0), binding, null);
        }

        @Nullable
        private Object evaluateExpression(ValueExpression expression, JpaParametersParameterAccessor accessor) {
            ValueEvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext((Object)accessor.getValues());
            return expression.evaluate(evaluationContext);
        }

        private /* synthetic */ Object lambda$0(ParameterBinding.Expression expression, JpaParametersParameterAccessor values) {
            return this.evaluateExpression(expression.expression(), values);
        }
    }

    static class ParameterImpl<T>
    implements Parameter<T> {
        private final ParameterBinding.BindingIdentifier identifier;
        private final Class<T> parameterType;

        static Parameter<?> of(@Nullable JpaParameters.JpaParameter parameter, ParameterBinding binding) {
            Class type = parameter == null ? Object.class : parameter.getType();
            return new ParameterImpl(binding.getIdentifier(), type);
        }

        public ParameterImpl(ParameterBinding.BindingIdentifier identifier, Class<T> parameterType) {
            this.identifier = identifier;
            this.parameterType = parameterType;
        }

        @Nullable
        public String getName() {
            return this.identifier.hasName() ? this.identifier.getName() : null;
        }

        @Nullable
        public Integer getPosition() {
            return this.identifier.hasPosition() ? Integer.valueOf(this.identifier.getPosition()) : null;
        }

        public Class<T> getParameterType() {
            return this.parameterType;
        }
    }

    private static class PartTreeQueryParameterSetterFactory
    extends BasicQueryParameterSetterFactory {
        private final JpaParameters parameters;

        private PartTreeQueryParameterSetterFactory(JpaParameters parameters) {
            super(parameters, false);
            this.parameters = (JpaParameters)parameters.getBindableParameters();
        }

        @Override
        @Nullable
        public QueryParameterSetter create(ParameterBinding binding, ParametrizedQuery query) {
            if (binding instanceof ParameterBinding.PartTreeParameterBinding) {
                ParameterBinding.PartTreeParameterBinding ptb = (ParameterBinding.PartTreeParameterBinding)binding;
                if (ptb.isIsNullParameter()) {
                    return QueryParameterSetter.NOOP;
                }
                return super.create(binding, query);
            }
            if (binding instanceof ParameterMetadataProvider.ScoreParameterBinding) {
                return super.create(binding, query);
            }
            return null;
        }
    }

    private static class SyntheticParameterSetterFactory
    extends QueryParameterSetterFactory {
        private SyntheticParameterSetterFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public QueryParameterSetter create(ParameterBinding binding, ParametrizedQuery query) {
            void s;
            ParameterBinding.ParameterOrigin parameterOrigin = binding.getOrigin();
            if (!(parameterOrigin instanceof ParameterBinding.Synthetic)) {
                return null;
            }
            ParameterBinding.Synthetic synthetic = (ParameterBinding.Synthetic)parameterOrigin;
            return QueryParameterSetterFactory.createSetter(arg_0 -> SyntheticParameterSetterFactory.lambda$0((ParameterBinding.Synthetic)s, arg_0), binding, null);
        }

        private static /* synthetic */ Object lambda$0(ParameterBinding.Synthetic synthetic, JpaParametersParameterAccessor values) {
            return synthetic.value();
        }
    }
}

