/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.DefaultIdentifierGenerator;
import org.springframework.data.keyvalue.core.GeneratingIdAccessor;
import org.springframework.data.keyvalue.core.IdentifierGenerator;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.KeyValueCallback;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.KeyValuePersistenceExceptionTranslator;
import org.springframework.data.keyvalue.core.event.KeyValueEvent;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.keyvalue.core.mapping.context.KeyValueMappingContext;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class KeyValueTemplate
implements KeyValueOperations,
ApplicationEventPublisherAware {
    private static final PersistenceExceptionTranslator DEFAULT_PERSISTENCE_EXCEPTION_TRANSLATOR = new KeyValuePersistenceExceptionTranslator();
    private final KeyValueAdapter adapter;
    private final MappingContext<? extends KeyValuePersistentEntity<?>, ? extends KeyValuePersistentProperty> mappingContext;
    private final IdentifierGenerator identifierGenerator;
    private PersistenceExceptionTranslator exceptionTranslator = DEFAULT_PERSISTENCE_EXCEPTION_TRANSLATOR;
    private ApplicationEventPublisher eventPublisher;
    private boolean publishEvents = true;
    private Set<Class<? extends KeyValueEvent>> eventTypesToPublish = Collections.emptySet();

    public KeyValueTemplate(KeyValueAdapter adapter) {
        this(adapter, (MappingContext<? extends KeyValuePersistentEntity<?>, ? extends KeyValuePersistentProperty>)new KeyValueMappingContext());
    }

    public KeyValueTemplate(KeyValueAdapter adapter, MappingContext<? extends KeyValuePersistentEntity<?>, ? extends KeyValuePersistentProperty> mappingContext) {
        Assert.notNull((Object)adapter, (String)"Adapter must not be null!");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        this.adapter = adapter;
        this.mappingContext = mappingContext;
        this.identifierGenerator = DefaultIdentifierGenerator.INSTANCE;
    }

    public void setExceptionTranslator(PersistenceExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)exceptionTranslator, (String)"ExceptionTranslator must not be null.");
        this.exceptionTranslator = exceptionTranslator;
    }

    public void setEventTypesToPublish(Set<Class<? extends KeyValueEvent>> eventTypesToPublish) {
        if (CollectionUtils.isEmpty(eventTypesToPublish)) {
            this.publishEvents = false;
        } else {
            this.publishEvents = true;
            this.eventTypesToPublish = Collections.unmodifiableSet(eventTypesToPublish);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    @Override
    public <T> T insert(T objectToInsert) {
        PersistentEntity entity = this.mappingContext.getPersistentEntity(ClassUtils.getUserClass(objectToInsert));
        GeneratingIdAccessor generatingIdAccessor = new GeneratingIdAccessor(entity.getPropertyAccessor(objectToInsert), entity.getIdProperty(), this.identifierGenerator);
        Object id = generatingIdAccessor.getOrGenerateIdentifier();
        this.insert((Serializable)id, objectToInsert);
        return objectToInsert;
    }

    @Override
    public void insert(final Serializable id, final Object objectToInsert) {
        Assert.notNull((Object)id, (String)"Id for object to be inserted must not be null!");
        Assert.notNull((Object)objectToInsert, (String)"Object to be inserted must not be null!");
        final String keyspace = this.resolveKeySpace(objectToInsert.getClass());
        this.potentiallyPublishEvent(KeyValueEvent.beforeInsert(id, keyspace, objectToInsert.getClass(), objectToInsert));
        this.execute(new KeyValueCallback<Void>(){

            @Override
            public Void doInKeyValue(KeyValueAdapter adapter) {
                if (adapter.contains(id, (Serializable)((Object)keyspace))) {
                    throw new DuplicateKeyException(String.format("Cannot insert existing object with id %s!. Please use update.", id));
                }
                adapter.put(id, objectToInsert, (Serializable)((Object)keyspace));
                return null;
            }
        });
        this.potentiallyPublishEvent(KeyValueEvent.afterInsert(id, keyspace, objectToInsert.getClass(), objectToInsert));
    }

    @Override
    public void update(Object objectToUpdate) {
        PersistentEntity entity = this.mappingContext.getPersistentEntity(ClassUtils.getUserClass((Object)objectToUpdate));
        if (!entity.hasIdProperty()) {
            throw new InvalidDataAccessApiUsageException(String.format("Cannot determine id for type %s", ClassUtils.getUserClass((Object)objectToUpdate)));
        }
        this.update((Serializable)entity.getIdentifierAccessor(objectToUpdate).getIdentifier(), objectToUpdate);
    }

    @Override
    public void update(final Serializable id, final Object objectToUpdate) {
        Assert.notNull((Object)id, (String)"Id for object to be inserted must not be null!");
        Assert.notNull((Object)objectToUpdate, (String)"Object to be updated must not be null!");
        final String keyspace = this.resolveKeySpace(objectToUpdate.getClass());
        this.potentiallyPublishEvent(KeyValueEvent.beforeUpdate(id, keyspace, objectToUpdate.getClass(), objectToUpdate));
        Object existing = this.execute(new KeyValueCallback<Object>(){

            @Override
            public Object doInKeyValue(KeyValueAdapter adapter) {
                return adapter.put(id, objectToUpdate, (Serializable)((Object)keyspace));
            }
        });
        this.potentiallyPublishEvent(KeyValueEvent.afterUpdate(id, keyspace, objectToUpdate.getClass(), objectToUpdate, existing));
    }

    @Override
    public <T> Iterable<T> findAll(final Class<T> type) {
        Assert.notNull(type, (String)"Type to fetch must not be null!");
        return (Iterable)this.execute(new KeyValueCallback<Iterable<T>>(){

            @Override
            public Iterable<T> doInKeyValue(KeyValueAdapter adapter) {
                Iterable<?> values = adapter.getAllOf((Serializable)((Object)KeyValueTemplate.this.resolveKeySpace(type)));
                if (values == null) {
                    return Collections.emptySet();
                }
                ArrayList filtered = new ArrayList();
                for (Object candidate : values) {
                    if (!KeyValueTemplate.typeCheck(type, candidate)) continue;
                    filtered.add(candidate);
                }
                return filtered;
            }
        });
    }

    @Override
    public <T> T findById(final Serializable id, final Class<T> type) {
        Assert.notNull((Object)id, (String)"Id for object to be inserted must not be null!");
        Assert.notNull(type, (String)"Type to fetch must not be null!");
        final String keyspace = this.resolveKeySpace(type);
        this.potentiallyPublishEvent(KeyValueEvent.beforeGet(id, keyspace, type));
        T result = this.execute(new KeyValueCallback<T>(){

            @Override
            public T doInKeyValue(KeyValueAdapter adapter) {
                Object result = adapter.get(id, (Serializable)((Object)keyspace));
                if (result == null || KeyValueTemplate.typeCheck(type, result)) {
                    return result;
                }
                return null;
            }
        });
        this.potentiallyPublishEvent(KeyValueEvent.afterGet(id, keyspace, type, result));
        return result;
    }

    @Override
    public void delete(Class<?> type) {
        Assert.notNull(type, (String)"Type to delete must not be null!");
        final String keyspace = this.resolveKeySpace(type);
        this.potentiallyPublishEvent(KeyValueEvent.beforeDropKeySpace(keyspace, type));
        this.execute(new KeyValueCallback<Void>(){

            @Override
            public Void doInKeyValue(KeyValueAdapter adapter) {
                adapter.deleteAllOf((Serializable)((Object)keyspace));
                return null;
            }
        });
        this.potentiallyPublishEvent(KeyValueEvent.afterDropKeySpace(keyspace, type));
    }

    @Override
    public <T> T delete(T objectToDelete) {
        Class type = ClassUtils.getUserClass(objectToDelete);
        PersistentEntity entity = this.mappingContext.getPersistentEntity(type);
        return this.delete((Serializable)entity.getIdentifierAccessor(objectToDelete).getIdentifier(), type);
    }

    @Override
    public <T> T delete(final Serializable id, Class<T> type) {
        Assert.notNull((Object)id, (String)"Id for object to be deleted must not be null!");
        Assert.notNull(type, (String)"Type to delete must not be null!");
        final String keyspace = this.resolveKeySpace(type);
        this.potentiallyPublishEvent(KeyValueEvent.beforeDelete(id, keyspace, type));
        T result = this.execute(new KeyValueCallback<T>(){

            @Override
            public T doInKeyValue(KeyValueAdapter adapter) {
                return adapter.delete(id, (Serializable)((Object)keyspace));
            }
        });
        this.potentiallyPublishEvent(KeyValueEvent.afterDelete(id, keyspace, type, result));
        return result;
    }

    @Override
    public long count(Class<?> type) {
        Assert.notNull(type, (String)"Type for count must not be null!");
        return this.adapter.count((Serializable)((Object)this.resolveKeySpace(type)));
    }

    @Override
    public <T> T execute(KeyValueCallback<T> action) {
        Assert.notNull(action, (String)"KeyValueCallback must not be null!");
        try {
            return action.doInKeyValue(this.adapter);
        }
        catch (RuntimeException e) {
            throw this.resolveExceptionIfPossible(e);
        }
    }

    @Override
    public <T> Iterable<T> find(final KeyValueQuery<?> query, final Class<T> type) {
        return (Iterable)this.execute(new KeyValueCallback<Iterable<T>>(){

            @Override
            public Iterable<T> doInKeyValue(KeyValueAdapter adapter) {
                Iterable<?> result = adapter.find(query, (Serializable)((Object)KeyValueTemplate.this.resolveKeySpace(type)));
                if (result == null) {
                    return Collections.emptySet();
                }
                ArrayList filtered = new ArrayList();
                for (Object candidate : result) {
                    if (!KeyValueTemplate.typeCheck(type, candidate)) continue;
                    filtered.add(candidate);
                }
                return filtered;
            }
        });
    }

    @Override
    public <T> Iterable<T> findAll(Sort sort, Class<T> type) {
        return this.find(new KeyValueQuery(sort), type);
    }

    @Override
    public <T> Iterable<T> findInRange(int offset, int rows, Class<T> type) {
        return this.find(new KeyValueQuery().skip(offset).limit(rows), type);
    }

    @Override
    public <T> Iterable<T> findInRange(int offset, int rows, Sort sort, Class<T> type) {
        return this.find(new KeyValueQuery(sort).skip(offset).limit(rows), type);
    }

    @Override
    public long count(final KeyValueQuery<?> query, final Class<?> type) {
        return this.execute(new KeyValueCallback<Long>(){

            @Override
            public Long doInKeyValue(KeyValueAdapter adapter) {
                return adapter.count(query, (Serializable)((Object)KeyValueTemplate.this.resolveKeySpace(type)));
            }
        });
    }

    @Override
    public MappingContext<?, ?> getMappingContext() {
        return this.mappingContext;
    }

    public void destroy() throws Exception {
        this.adapter.clear();
    }

    private String resolveKeySpace(Class<?> type) {
        return ((KeyValuePersistentEntity)this.mappingContext.getPersistentEntity(type)).getKeySpace();
    }

    private RuntimeException resolveExceptionIfPossible(RuntimeException e) {
        DataAccessException translatedException = this.exceptionTranslator.translateExceptionIfPossible(e);
        return translatedException != null ? translatedException : e;
    }

    private void potentiallyPublishEvent(KeyValueEvent event) {
        if (this.eventPublisher == null) {
            return;
        }
        if (this.publishEvents && (this.eventTypesToPublish.isEmpty() || this.eventTypesToPublish.contains(((Object)((Object)event)).getClass()))) {
            this.eventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    private static boolean typeCheck(Class<?> requiredType, Object candidate) {
        return candidate == null ? true : ClassUtils.isAssignable(requiredType, candidate.getClass());
    }
}

