/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.map.repository.config;

import java.util.Map;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.keyvalue.core.KeyValueTemplate;
import org.springframework.data.keyvalue.repository.config.KeyValueRepositoryConfigurationExtension;
import org.springframework.data.map.MapKeyValueAdapter;
import org.springframework.data.map.repository.config.EnableMapRepositories;
import org.springframework.data.repository.config.RepositoryConfigurationSource;

public class MapRepositoryConfigurationExtension
extends KeyValueRepositoryConfigurationExtension {
    @Override
    public String getModuleName() {
        return "Map";
    }

    @Override
    protected String getModulePrefix() {
        return "map";
    }

    @Override
    protected String getDefaultKeyValueTemplateRef() {
        return "mapKeyValueTemplate";
    }

    @Override
    protected AbstractBeanDefinition getDefaultKeyValueTemplateBeanDefinition(RepositoryConfigurationSource configurationSource) {
        BeanDefinitionBuilder adapterBuilder = BeanDefinitionBuilder.rootBeanDefinition(MapKeyValueAdapter.class);
        adapterBuilder.addConstructorArgValue(MapRepositoryConfigurationExtension.getMapTypeToUse(configurationSource));
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(KeyValueTemplate.class);
        builder.addConstructorArgValue((Object)ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)adapterBuilder, (Object)configurationSource.getSource()));
        builder.setRole(1);
        return ParsingUtils.getSourceBeanDefinition((BeanDefinitionBuilder)builder, (Object)configurationSource.getSource());
    }

    private static Class<? extends Map> getMapTypeToUse(RepositoryConfigurationSource source) {
        return (Class)((AnnotationMetadata)source.getSource()).getAnnotationAttributes(EnableMapRepositories.class.getName()).get("mapType");
    }
}

