/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.query.EntityInformationCreator;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.PartTreeMongoQuery;
import org.springframework.data.mongodb.repository.query.StringBasedMongoQuery;
import org.springframework.data.mongodb.repository.support.DefaultEntityInformationCreator;
import org.springframework.data.mongodb.repository.support.QueryDslMongoRepository;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoRepositoryFactory
extends RepositoryFactorySupport {
    private final MongoOperations mongoOperations;
    private final EntityInformationCreator entityInformationCreator;

    public MongoRepositoryFactory(MongoOperations mongoOperations) {
        Assert.notNull((Object)mongoOperations);
        this.mongoOperations = mongoOperations;
        this.entityInformationCreator = new DefaultEntityInformationCreator(mongoOperations.getConverter().getMappingContext());
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return MongoRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface()) ? QueryDslMongoRepository.class : SimpleMongoRepository.class;
    }

    protected Object getTargetRepository(RepositoryMetadata metadata) {
        Class repositoryInterface = metadata.getRepositoryInterface();
        EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainClass());
        if (MongoRepositoryFactory.isQueryDslRepository(repositoryInterface)) {
            return new QueryDslMongoRepository(entityInformation, this.mongoOperations);
        }
        return new SimpleMongoRepository(entityInformation, this.mongoOperations);
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key) {
        return new MongoQueryLookupStrategy();
    }

    public <T, ID extends Serializable> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.entityInformationCreator.getEntityInformation(domainClass);
    }

    private class MongoQueryLookupStrategy
    implements QueryLookupStrategy {
        private MongoQueryLookupStrategy() {
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, NamedQueries namedQueries) {
            MongoQueryMethod queryMethod = new MongoQueryMethod(method, metadata, MongoRepositoryFactory.this.entityInformationCreator);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedMongoQuery(namedQuery, queryMethod, MongoRepositoryFactory.this.mongoOperations);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedMongoQuery(queryMethod, MongoRepositoryFactory.this.mongoOperations);
            }
            return new PartTreeMongoQuery(queryMethod, MongoRepositoryFactory.this.mongoOperations);
        }
    }
}

