/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bson.BSONObject;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.ExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class GroupOperation
extends ExposedFieldsAggregationOperationContext
implements AggregationOperation {
    private final ExposedFields nonSynthecticFields;
    private final List<Operation> operations;

    public GroupOperation(Fields fields) {
        this.nonSynthecticFields = ExposedFields.nonSynthetic(fields);
        this.operations = new ArrayList<Operation>();
    }

    protected GroupOperation(GroupOperation groupOperation) {
        this(groupOperation, Collections.emptyList());
    }

    private GroupOperation(GroupOperation groupOperation, List<Operation> nextOperations) {
        Assert.notNull((Object)groupOperation, (String)"GroupOperation must not be null!");
        Assert.notNull(nextOperations, (String)"NextOperations must not be null!");
        this.nonSynthecticFields = groupOperation.nonSynthecticFields;
        this.operations = new ArrayList<Operation>(nextOperations.size() + 1);
        this.operations.addAll(groupOperation.operations);
        this.operations.addAll(nextOperations);
    }

    protected GroupOperation and(Operation operation) {
        return new GroupOperation(this, Arrays.asList(operation));
    }

    public GroupOperationBuilder count() {
        return this.newBuilder(GroupOps.SUM, null, 1);
    }

    public GroupOperationBuilder sum(String reference) {
        return this.sum(reference, null);
    }

    private GroupOperationBuilder sum(String reference, Object value) {
        return this.newBuilder(GroupOps.SUM, reference, value);
    }

    public GroupOperationBuilder addToSet(String reference) {
        return this.addToSet(reference, null);
    }

    public GroupOperationBuilder addToSet(Object value) {
        return this.addToSet(null, value);
    }

    private GroupOperationBuilder addToSet(String reference, Object value) {
        return this.newBuilder(GroupOps.ADD_TO_SET, reference, value);
    }

    public GroupOperationBuilder last(String reference) {
        return this.newBuilder(GroupOps.LAST, reference, null);
    }

    public GroupOperationBuilder first(String reference) {
        return this.newBuilder(GroupOps.FIRST, reference, null);
    }

    public GroupOperationBuilder avg(String reference) {
        return this.newBuilder(GroupOps.AVG, reference, null);
    }

    public GroupOperationBuilder push(String reference) {
        return this.push(reference, null);
    }

    public GroupOperationBuilder push(Object value) {
        return this.push(null, value);
    }

    private GroupOperationBuilder push(String reference, Object value) {
        return this.newBuilder(GroupOps.PUSH, reference, value);
    }

    public GroupOperationBuilder min(String reference) {
        return this.newBuilder(GroupOps.MIN, reference, null);
    }

    public GroupOperationBuilder max(String reference) {
        return this.newBuilder(GroupOps.MAX, reference, null);
    }

    private GroupOperationBuilder newBuilder(Keyword keyword, String reference, Object value) {
        return new GroupOperationBuilder(this, new Operation(keyword, null, reference, value));
    }

    @Override
    public ExposedFields getFields() {
        ExposedFields fields = this.nonSynthecticFields.and(new ExposedFields.ExposedField(Fields.UNDERSCORE_ID, true));
        for (Operation operation : this.operations) {
            fields = fields.and(operation.asField());
        }
        return fields;
    }

    @Override
    public DBObject toDBObject(AggregationOperationContext context) {
        BasicDBObject operationObject = new BasicDBObject();
        if (this.nonSynthecticFields.exposesSingleFieldOnly()) {
            ExposedFields.FieldReference reference = context.getReference(this.nonSynthecticFields.iterator().next());
            operationObject.put(Fields.UNDERSCORE_ID, (Object)reference.toString());
        } else {
            BasicDBObject inner = new BasicDBObject();
            for (ExposedFields.ExposedField field : this.nonSynthecticFields) {
                ExposedFields.FieldReference reference = context.getReference(field);
                inner.put(field.getName(), (Object)reference.toString());
            }
            operationObject.put(Fields.UNDERSCORE_ID, (Object)inner);
        }
        for (Operation operation : this.operations) {
            operationObject.putAll((BSONObject)operation.toDBObject(context));
        }
        return new BasicDBObject("$group", (Object)operationObject);
    }

    static class Operation
    implements AggregationOperation {
        private final Keyword op;
        private final String key;
        private final String reference;
        private final Object value;

        public Operation(Keyword op, String key, String reference, Object value) {
            this.op = op;
            this.key = key;
            this.reference = reference;
            this.value = value;
        }

        public Operation withAlias(String key) {
            return new Operation(this.op, key, this.reference, this.value);
        }

        public ExposedFields.ExposedField asField() {
            return new ExposedFields.ExposedField(this.key, true);
        }

        @Override
        public DBObject toDBObject(AggregationOperationContext context) {
            return new BasicDBObject(this.key, (Object)new BasicDBObject(((Object)this.op).toString(), this.getValue(context)));
        }

        public Object getValue(AggregationOperationContext context) {
            return this.reference == null ? this.value : context.getReference(this.reference).toString();
        }

        public String toString() {
            return "Operation [op=" + this.op + ", key=" + this.key + ", reference=" + this.reference + ", value=" + this.value + "]";
        }
    }

    private static enum GroupOps implements Keyword
    {
        SUM,
        LAST,
        FIRST,
        PUSH,
        AVG,
        MIN,
        MAX,
        ADD_TO_SET,
        COUNT;


        @Override
        public String toString() {
            String[] parts = this.name().split("_");
            StringBuilder builder = new StringBuilder();
            for (String part : parts) {
                String lowerCase = part.toLowerCase(Locale.US);
                builder.append(builder.length() == 0 ? lowerCase : StringUtils.capitalize((String)lowerCase));
            }
            return "$" + builder.toString();
        }
    }

    static interface Keyword {
        public String toString();
    }

    public class GroupOperationBuilder {
        private final GroupOperation groupOperation;
        private final Operation operation;

        private GroupOperationBuilder(GroupOperation groupOperation2, Operation operation) {
            Assert.notNull((Object)groupOperation2, (String)"GroupOperation must not be null!");
            Assert.notNull((Object)operation, (String)"Operation must not be null!");
            this.groupOperation = groupOperation2;
            this.operation = operation;
        }

        public GroupOperation as(String alias) {
            return this.groupOperation.and(this.operation.withAlias(alias));
        }
    }
}

