/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.mongodb.core.mapping;

/**
 * SPI interface to determine how to name document fields in cases the field name is not manually defined.
 * 
 * @see DocumentField
 * @see PropertyNameFieldNamingStrategy
 * @see CamelCaseAbbreviatingFieldNamingStrategy
 * @since 1.3
 * @author Oliver Gierke
 */
public interface FieldNamingStrategy {

	/**
	 * Returns the field name to be used for the given {@link MongoPersistentProperty}.
	 * 
	 * @param property must not be {@literal null} or empty;
	 * @return
	 */
	String getFieldName(MongoPersistentProperty property);
}
