/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.io.Serializable;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.repository.core.support.PersistentEntityInformation;

public class MappingMongoEntityInformation<T, ID extends Serializable>
extends PersistentEntityInformation<T, ID>
implements MongoEntityInformation<T, ID> {
    private final MongoPersistentEntity<T> entityMetadata;
    private final String customCollectionName;

    public MappingMongoEntityInformation(MongoPersistentEntity<T> entity) {
        this(entity, null);
    }

    public MappingMongoEntityInformation(MongoPersistentEntity<T> entity, String customCollectionName) {
        super(entity);
        this.entityMetadata = entity;
        this.customCollectionName = customCollectionName;
    }

    @Override
    public String getCollectionName() {
        return this.customCollectionName == null ? this.entityMetadata.getCollection() : this.customCollectionName;
    }

    @Override
    public String getIdAttribute() {
        return ((MongoPersistentProperty)this.entityMetadata.getIdProperty()).getName();
    }
}

