/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import org.bson.Document;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.util.ClassUtils;

class PropertyOperations {
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    Document computeFieldsForProjection(ProjectionFactory projectionFactory, Document fields, Class<?> domainType, Class<?> targetType) {
        if (!fields.isEmpty() || ClassUtils.isAssignable(domainType, targetType)) {
            return fields;
        }
        Document projectedFields = new Document();
        if (targetType.isInterface()) {
            ProjectionInformation projectionInformation = projectionFactory.getProjectionInformation(targetType);
            if (projectionInformation.isClosed()) {
                projectionInformation.getInputProperties().forEach(it -> projectedFields.append(it.getName(), (Object)1));
            }
        } else {
            ((MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(targetType)).doWithProperties(persistentProperty -> projectedFields.append(persistentProperty.getName(), (Object)1));
        }
        return projectedFields;
    }

    PropertyOperations(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }
}

