/*
 * Copyright 2010-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.mongodb.core;

import org.bson.Document;
import org.springframework.dao.DataAccessException;
import org.springframework.lang.Nullable;

import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;

/**
 * Callback interface for executing actions against a {@link MongoCollection}.
 *
 * @author Mark Pollak
 * @author Grame Rocher
 * @author Oliver Gierke
 * @author John Brisbin
 * @auhtor Christoph Strobl
 * @since 1.0
 */
public interface CollectionCallback<T> {

	/**
	 * @param collection never {@literal null}.
	 * @return can be {@literal null}.
	 * @throws MongoException
	 * @throws DataAccessException
	 */
	@Nullable
	T doInCollection(MongoCollection<Document> collection) throws MongoException, DataAccessException;

}
