/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.UpdateResult;
import lombok.NonNull;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableUpdateOperationSupport
implements ExecutableUpdateOperation {
    private static final Query ALL_QUERY = new Query();
    @NonNull
    private final MongoTemplate template;

    @Override
    public <T> ExecutableUpdateOperation.ExecutableUpdate<T> update(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableUpdateSupport<T>(this.template, domainType, ALL_QUERY, null, null, null, null, null, domainType);
    }

    public ExecutableUpdateOperationSupport(@NonNull MongoTemplate template) {
        if (template == null) {
            throw new IllegalArgumentException("template is marked non-null but is null");
        }
        this.template = template;
    }

    static class ExecutableUpdateSupport<T>
    implements ExecutableUpdateOperation.ExecutableUpdate<T>,
    ExecutableUpdateOperation.UpdateWithCollection<T>,
    ExecutableUpdateOperation.UpdateWithQuery<T>,
    ExecutableUpdateOperation.TerminatingUpdate<T>,
    ExecutableUpdateOperation.FindAndReplaceWithOptions<T>,
    ExecutableUpdateOperation.TerminatingFindAndReplace<T>,
    ExecutableUpdateOperation.FindAndReplaceWithProjection<T> {
        @NonNull
        private final MongoTemplate template;
        @NonNull
        private final Class domainType;
        private final Query query;
        @Nullable
        private final Update update;
        @Nullable
        private final String collection;
        @Nullable
        private final FindAndModifyOptions findAndModifyOptions;
        @Nullable
        private final FindAndReplaceOptions findAndReplaceOptions;
        @Nullable
        private final Object replacement;
        @NonNull
        private final Class<T> targetType;

        @Override
        public ExecutableUpdateOperation.TerminatingUpdate<T> apply(Update update) {
            Assert.notNull((Object)update, (String)"Update must not be null!");
            return new ExecutableUpdateSupport<T>(this.template, this.domainType, this.query, update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType);
        }

        @Override
        public ExecutableUpdateOperation.UpdateWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty!");
            return new ExecutableUpdateSupport<T>(this.template, this.domainType, this.query, this.update, collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType);
        }

        @Override
        public ExecutableUpdateOperation.TerminatingFindAndModify<T> withOptions(FindAndModifyOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null!");
            return new ExecutableUpdateSupport<T>(this.template, this.domainType, this.query, this.update, this.collection, options, this.findAndReplaceOptions, this.replacement, this.targetType);
        }

        @Override
        public ExecutableUpdateOperation.FindAndReplaceWithProjection<T> replaceWith(T replacement) {
            Assert.notNull(replacement, (String)"Replacement must not be null!");
            return new ExecutableUpdateSupport<T>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, replacement, this.targetType);
        }

        @Override
        public ExecutableUpdateOperation.FindAndReplaceWithProjection<T> withOptions(FindAndReplaceOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null!");
            return new ExecutableUpdateSupport<T>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, options, this.replacement, this.targetType);
        }

        @Override
        public ExecutableUpdateOperation.UpdateWithUpdate<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new ExecutableUpdateSupport<T>(this.template, this.domainType, query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType);
        }

        @Override
        public <R> ExecutableUpdateOperation.FindAndReplaceWithOptions<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"ResultType must not be null!");
            return new ExecutableUpdateSupport<R>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, resultType);
        }

        @Override
        public UpdateResult all() {
            return this.doUpdate(true, false);
        }

        @Override
        public UpdateResult first() {
            return this.doUpdate(false, false);
        }

        @Override
        public UpdateResult upsert() {
            return this.doUpdate(true, true);
        }

        @Override
        @Nullable
        public T findAndModifyValue() {
            return this.template.findAndModify(this.query, this.update, this.findAndModifyOptions != null ? this.findAndModifyOptions : new FindAndModifyOptions(), this.targetType, this.getCollectionName());
        }

        @Override
        @Nullable
        public T findAndReplaceValue() {
            return this.template.findAndReplace(this.query, this.replacement, this.findAndReplaceOptions != null ? this.findAndReplaceOptions : FindAndReplaceOptions.empty(), this.domainType, this.getCollectionName(), this.targetType);
        }

        private UpdateResult doUpdate(boolean multi, boolean upsert) {
            return this.template.doUpdate(this.getCollectionName(), this.query, this.update, this.domainType, upsert, multi);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }

        public ExecutableUpdateSupport(@NonNull MongoTemplate template, @NonNull Class domainType, Query query, @Nullable Update update, @Nullable String collection, @Nullable FindAndModifyOptions findAndModifyOptions, @Nullable FindAndReplaceOptions findAndReplaceOptions, @Nullable Object replacement, @NonNull Class<T> targetType) {
            if (template == null) {
                throw new IllegalArgumentException("template is marked non-null but is null");
            }
            if (domainType == null) {
                throw new IllegalArgumentException("domainType is marked non-null but is null");
            }
            if (targetType == null) {
                throw new IllegalArgumentException("targetType is marked non-null but is null");
            }
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.update = update;
            this.collection = collection;
            this.findAndModifyOptions = findAndModifyOptions;
            this.findAndReplaceOptions = findAndReplaceOptions;
            this.replacement = replacement;
            this.targetType = targetType;
        }
    }
}

