/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.DBObject;
import com.mongodb.client.MongoClient;
import org.bson.Document;
import org.springframework.data.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

@ManagedResource(description="Global Lock Metrics")
public class GlobalLockMetrics
extends AbstractMonitor {
    @Deprecated
    public GlobalLockMetrics(com.mongodb.MongoClient mongoClient) {
        super(mongoClient);
    }

    public GlobalLockMetrics(MongoClient mongoClient) {
        super(mongoClient);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Total time")
    public double getTotalTime() {
        return this.getGlobalLockData("totalTime", Double.class);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Lock time", unit="s")
    public double getLockTime() {
        return this.getGlobalLockData("lockTime", Double.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Lock time")
    public double getLockTimeRatio() {
        return this.getGlobalLockData("ratio", Double.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Current Queue")
    public int getCurrentQueueTotal() {
        return this.getCurrentQueue("total");
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Reader Queue")
    public int getCurrentQueueReaders() {
        return this.getCurrentQueue("readers");
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Writer Queue")
    public int getCurrentQueueWriters() {
        return this.getCurrentQueue("writers");
    }

    private <T> T getGlobalLockData(String key, Class<T> targetClass) {
        DBObject globalLock = (DBObject)this.getServerStatus().get((Object)"globalLock");
        return (T)globalLock.get(key);
    }

    private int getCurrentQueue(String key) {
        Document globalLock = (Document)this.getServerStatus().get((Object)"globalLock");
        Document currentQueue = (Document)globalLock.get((Object)"currentQueue");
        return (Integer)currentQueue.get((Object)key);
    }
}

