/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.bson.Document;
import org.reactivestreams.Publisher;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mongodb.core.ReactiveFindOperation;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.mongodb.repository.query.ReactiveMongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryExecution;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveMongoQuery
implements RepositoryQuery {
    private final ReactiveMongoQueryMethod method;
    private final ReactiveMongoOperations operations;
    private final EntityInstantiators instantiators;
    private final ReactiveFindOperation.FindWithProjection<?> findOperationWithProjection;
    private final SpelExpressionParser expressionParser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public AbstractReactiveMongoQuery(ReactiveMongoQueryMethod method, ReactiveMongoOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)((Object)method), (String)"MongoQueryMethod must not be null!");
        Assert.notNull((Object)operations, (String)"ReactiveMongoOperations must not be null!");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"QueryMethodEvaluationContextProvider must not be null!");
        this.method = method;
        this.operations = operations;
        this.instantiators = new EntityInstantiators();
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        EntityMetadata metadata = method.getEntityInformation();
        Class type = metadata.getCollectionEntity().getType();
        this.findOperationWithProjection = operations.query(type);
    }

    public MongoQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        return this.method.hasReactiveWrapperParameter() ? this.executeDeferred(parameters) : this.execute(new MongoParametersParameterAccessor(this.method, parameters));
    }

    private Object executeDeferred(Object[] parameters) {
        ReactiveMongoParameterAccessor parameterAccessor = new ReactiveMongoParameterAccessor(this.method, parameters);
        if (this.getQueryMethod().isCollectionQuery()) {
            return Flux.defer(() -> (Publisher)this.execute(parameterAccessor));
        }
        return Mono.defer(() -> (Mono)this.execute(parameterAccessor));
    }

    private Object execute(MongoParameterAccessor parameterAccessor) {
        ConvertingParameterAccessor accessor = new ConvertingParameterAccessor(this.operations.getConverter(), parameterAccessor);
        TypeInformation<?> returnType = this.method.getReturnType();
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Class typeToRead = processor.getReturnedType().getTypeToRead();
        if (typeToRead == null && returnType.getComponentType() != null) {
            typeToRead = returnType.getComponentType().getType();
        }
        return this.doExecute(this.method, processor, accessor, typeToRead);
    }

    protected Object doExecute(ReactiveMongoQueryMethod method, ResultProcessor processor, ConvertingParameterAccessor accessor, @Nullable Class<?> typeToRead) {
        Query query = this.createQuery(accessor);
        this.applyQueryMetaAttributesWhenPresent(query);
        query = this.applyAnnotatedDefaultSortIfPresent(query);
        query = this.applyAnnotatedCollationIfPresent(query, accessor);
        ReactiveFindOperation.FindWithProjection<?> find = typeToRead == null ? this.findOperationWithProjection : this.findOperationWithProjection.as(typeToRead);
        String collection = method.getEntityInformation().getCollectionName();
        ReactiveMongoQueryExecution execution = this.getExecution(accessor, new ReactiveMongoQueryExecution.ResultProcessingConverter(processor, this.operations, this.instantiators), find);
        return execution.execute(query, processor.getReturnedType().getDomainType(), collection);
    }

    private ReactiveMongoQueryExecution getExecution(MongoParameterAccessor accessor, Converter<Object, Object> resultProcessing, ReactiveFindOperation.FindWithQuery<?> operation) {
        return new ReactiveMongoQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(accessor, operation), resultProcessing);
    }

    private ReactiveMongoQueryExecution getExecutionToWrap(MongoParameterAccessor accessor, ReactiveFindOperation.FindWithQuery<?> operation) {
        if (this.isDeleteQuery()) {
            return new ReactiveMongoQueryExecution.DeleteExecution(this.operations, this.method);
        }
        if (this.method.isGeoNearQuery()) {
            return new ReactiveMongoQueryExecution.GeoNearExecution(this.operations, accessor, this.method.getReturnType());
        }
        if (this.isTailable(this.method)) {
            return (q, t, c) -> operation.matching(q.with(accessor.getPageable())).tail();
        }
        if (this.method.isCollectionQuery()) {
            return (q, t, c) -> operation.matching(q.with(accessor.getPageable())).all();
        }
        if (this.isCountQuery()) {
            return (q, t, c) -> operation.matching(q).count();
        }
        if (this.isExistsQuery()) {
            return (q, t, c) -> operation.matching(q).exists();
        }
        return (q, t, c) -> {
            ReactiveFindOperation.TerminatingFind find = operation.matching(q);
            if (this.isCountQuery()) {
                return find.count();
            }
            return this.isLimiting() ? find.first() : find.one();
        };
    }

    private boolean isTailable(MongoQueryMethod method) {
        return method.getTailableAnnotation() != null;
    }

    Query applyQueryMetaAttributesWhenPresent(Query query) {
        if (this.method.hasQueryMetaAttributes()) {
            query.setMeta(this.method.getQueryMetaAttributes());
        }
        return query;
    }

    Query applyAnnotatedDefaultSortIfPresent(Query query) {
        if (!this.method.hasAnnotatedSort()) {
            return query;
        }
        return QueryUtils.decorateSort(query, Document.parse((String)this.method.getAnnotatedSort()));
    }

    Query applyAnnotatedCollationIfPresent(Query query, ConvertingParameterAccessor accessor) {
        return QueryUtils.applyCollation(query, this.method.hasAnnotatedCollation() ? this.method.getAnnotatedCollation() : null, accessor, this.getQueryMethod().getParameters(), this.expressionParser, this.evaluationContextProvider);
    }

    protected Query createCountQuery(ConvertingParameterAccessor accessor) {
        return this.applyQueryMetaAttributesWhenPresent(this.createQuery(accessor));
    }

    protected abstract Query createQuery(ConvertingParameterAccessor var1);

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isDeleteQuery();

    protected abstract boolean isLimiting();
}

