/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Encoder;
import org.bson.conversions.Bson;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.core.AggregationUtil;
import org.springframework.data.mongodb.core.EntityOperations;
import org.springframework.data.mongodb.core.MappedDocument;
import org.springframework.data.mongodb.core.PropertyOperations;
import org.springframework.data.mongodb.core.aggregation.AggregationUpdate;
import org.springframework.data.mongodb.core.aggregation.RelaxedTypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.ShardKey;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class QueryOperations {
    private final QueryMapper queryMapper;
    private final UpdateMapper updateMapper;
    private final EntityOperations entityOperations;
    private final PropertyOperations propertyOperations;
    private final CodecRegistryProvider codecRegistryProvider;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final AggregationUtil aggregationUtil;
    private final Map<Class<?>, Document> mappedShardKey = new ConcurrentHashMap(1);

    QueryOperations(QueryMapper queryMapper, UpdateMapper updateMapper, EntityOperations entityOperations, PropertyOperations propertyOperations, CodecRegistryProvider codecRegistryProvider) {
        this.queryMapper = queryMapper;
        this.updateMapper = updateMapper;
        this.entityOperations = entityOperations;
        this.propertyOperations = propertyOperations;
        this.codecRegistryProvider = codecRegistryProvider;
        this.mappingContext = queryMapper.getMappingContext();
        this.aggregationUtil = new AggregationUtil(queryMapper, this.mappingContext);
    }

    QueryContext createQueryContext(Query query) {
        return new QueryContext(query);
    }

    DistinctQueryContext distinctQueryContext(Query query, String fieldName) {
        return new DistinctQueryContext(query, fieldName);
    }

    CountContext countQueryContext(Query query) {
        return new CountContext(query);
    }

    UpdateContext updateContext(UpdateDefinition updateDefinition, Query query, boolean upsert) {
        return new UpdateContext(updateDefinition, query, true, upsert);
    }

    UpdateContext updateSingleContext(UpdateDefinition updateDefinition, Query query, boolean upsert) {
        return new UpdateContext(updateDefinition, query, false, upsert);
    }

    UpdateContext updateSingleContext(UpdateDefinition updateDefinition, Document query, boolean upsert) {
        return new UpdateContext(updateDefinition, query, false, upsert);
    }

    UpdateContext replaceSingleContext(MappedDocument replacement, boolean upsert) {
        return new UpdateContext(replacement, upsert);
    }

    DeleteContext deleteQueryContext(Query query) {
        return new DeleteContext(query, true);
    }

    DeleteContext deleteSingleContext(Query query) {
        return new DeleteContext(query, false);
    }

    class UpdateContext
    extends QueryContext {
        private final boolean multi;
        private final boolean upsert;
        @Nullable
        private final UpdateDefinition update;
        @Nullable
        private final MappedDocument mappedDocument;

        UpdateContext(UpdateDefinition update, Document query, boolean multi, boolean upsert) {
            this(update, new BasicQuery(query), multi, upsert);
        }

        UpdateContext(@Nullable UpdateDefinition update, Query query, boolean multi, boolean upsert) {
            super(query);
            this.multi = multi;
            this.upsert = upsert;
            this.update = update;
            this.mappedDocument = null;
        }

        UpdateContext(MappedDocument update, boolean upsert) {
            super(new BasicQuery(new Document(BsonUtils.asMap(update.getIdFilter()))));
            this.multi = false;
            this.upsert = upsert;
            this.mappedDocument = update;
            this.update = null;
        }

        UpdateOptions getUpdateOptions(@Nullable Class<?> domainType) {
            return this.getUpdateOptions(domainType, null);
        }

        UpdateOptions getUpdateOptions(@Nullable Class<?> domainType, @Nullable Consumer<UpdateOptions> callback) {
            UpdateOptions options = new UpdateOptions();
            options.upsert(this.upsert);
            if (this.update != null && this.update.hasArrayFilters()) {
                options.arrayFilters(this.update.getArrayFilters().stream().map(UpdateDefinition.ArrayFilter::asDocument).collect(Collectors.toList()));
            }
            this.applyCollation(domainType, arg_0 -> ((UpdateOptions)options).collation(arg_0));
            if (callback != null) {
                callback.accept(options);
            }
            return options;
        }

        ReplaceOptions getReplaceOptions(@Nullable Class<?> domainType) {
            return this.getReplaceOptions(domainType, null);
        }

        ReplaceOptions getReplaceOptions(@Nullable Class<?> domainType, @Nullable Consumer<ReplaceOptions> callback) {
            UpdateOptions updateOptions = this.getUpdateOptions(domainType);
            ReplaceOptions options = new ReplaceOptions();
            options.collation(updateOptions.getCollation());
            options.upsert(updateOptions.isUpsert());
            if (callback != null) {
                callback.accept(options);
            }
            return options;
        }

        @Override
        <T> Document getMappedQuery(@Nullable MongoPersistentEntity<T> domainType) {
            Document mappedQuery = super.getMappedQuery(domainType);
            if (this.multi && this.update.isIsolated().booleanValue() && !mappedQuery.containsKey((Object)"$isolated")) {
                mappedQuery.put("$isolated", (Object)1);
            }
            return mappedQuery;
        }

        <T> Document applyShardKey(MongoPersistentEntity<T> domainType, Document filter, @Nullable Document existing) {
            Document shardKeySource = existing != null ? existing : (this.mappedDocument != null ? this.mappedDocument.getDocument() : this.getMappedUpdate(domainType));
            Document filterWithShardKey = new Document((Map)filter);
            this.getMappedShardKeyFields(domainType).forEach(key -> filterWithShardKey.putIfAbsent(key, shardKeySource.get(key)));
            return filterWithShardKey;
        }

        boolean requiresShardKey(Document filter, @Nullable MongoPersistentEntity<?> domainType) {
            return !this.multi && domainType != null && domainType.isSharded() && !this.shardedById(domainType) && !filter.keySet().containsAll(this.getMappedShardKeyFields(domainType));
        }

        private boolean shardedById(MongoPersistentEntity<?> domainType) {
            ShardKey shardKey = domainType.getShardKey();
            if (shardKey.size() != 1) {
                return false;
            }
            String key = shardKey.getPropertyNames().iterator().next();
            if ("_id".equals(key)) {
                return true;
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)domainType.getIdProperty();
            return idProperty != null && idProperty.getName().equals(key);
        }

        Set<String> getMappedShardKeyFields(MongoPersistentEntity<?> entity) {
            return this.getMappedShardKey(entity).keySet();
        }

        Document getMappedShardKey(MongoPersistentEntity<?> entity) {
            return QueryOperations.this.mappedShardKey.computeIfAbsent(entity.getType(), key -> QueryOperations.this.queryMapper.getMappedFields(entity.getShardKey().getDocument(), entity));
        }

        List<Document> getUpdatePipeline(@Nullable Class<?> domainType) {
            Class<Object> type = domainType != null ? domainType : Object.class;
            RelaxedTypeBasedAggregationOperationContext context = new RelaxedTypeBasedAggregationOperationContext(type, QueryOperations.this.mappingContext, QueryOperations.this.queryMapper);
            return QueryOperations.this.aggregationUtil.createPipeline((AggregationUpdate)this.update, context);
        }

        Document getMappedUpdate(@Nullable MongoPersistentEntity<?> entity) {
            if (this.update != null) {
                return this.update instanceof MappedDocument.MappedUpdate ? this.update.getUpdateObject() : QueryOperations.this.updateMapper.getMappedObject((Bson)this.update.getUpdateObject(), entity);
            }
            return this.mappedDocument.getDocument();
        }

        void increaseVersionForUpdateIfNecessary(@Nullable MongoPersistentEntity<?> persistentEntity) {
            String versionFieldName;
            if (persistentEntity != null && persistentEntity.hasVersionProperty() && !this.update.modifies(versionFieldName = ((MongoPersistentProperty)persistentEntity.getRequiredVersionProperty()).getFieldName())) {
                this.update.inc(versionFieldName);
            }
        }

        boolean isAggregationUpdate() {
            return this.update instanceof AggregationUpdate;
        }

        boolean isMulti() {
            return this.multi;
        }
    }

    class DeleteContext
    extends QueryContext {
        private final boolean multi;

        DeleteContext(Query query, boolean multi) {
            super(query);
            this.multi = multi;
        }

        DeleteOptions getDeleteOptions(@Nullable Class<?> domainType) {
            return this.getDeleteOptions(domainType, null);
        }

        DeleteOptions getDeleteOptions(@Nullable Class<?> domainType, @Nullable Consumer<DeleteOptions> callback) {
            DeleteOptions options = new DeleteOptions();
            this.applyCollation(domainType, arg_0 -> ((DeleteOptions)options).collation(arg_0));
            if (callback != null) {
                callback.accept(options);
            }
            return options;
        }

        boolean isMulti() {
            return this.multi;
        }
    }

    class CountContext
    extends QueryContext {
        CountContext(Query query) {
            super(query);
        }

        CountOptions getCountOptions(@Nullable Class<?> domainType) {
            return this.getCountOptions(domainType, null);
        }

        CountOptions getCountOptions(@Nullable Class<?> domainType, @Nullable Consumer<CountOptions> callback) {
            CountOptions options = new CountOptions();
            Query query = this.getQuery();
            this.applyCollation(domainType, arg_0 -> ((CountOptions)options).collation(arg_0));
            if (query.getLimit() > 0) {
                options.limit(query.getLimit());
            }
            if (query.getSkip() > 0L) {
                options.skip((int)query.getSkip());
            }
            if (StringUtils.hasText((String)query.getHint())) {
                String hint = query.getHint();
                if (BsonUtils.isJsonDocument(hint)) {
                    options.hint((Bson)BsonUtils.parse(hint, QueryOperations.this.codecRegistryProvider));
                } else {
                    options.hintString(hint);
                }
            }
            if (callback != null) {
                callback.accept(options);
            }
            return options;
        }
    }

    class DistinctQueryContext
    extends QueryContext {
        private final String fieldName;

        private DistinctQueryContext(Object query, String fieldName) {
            super(query instanceof Document ? new BasicQuery((Document)query) : (Query)query);
            this.fieldName = fieldName;
        }

        @Override
        Document getMappedFields(@Nullable MongoPersistentEntity<?> entity, Class<?> targetType, ProjectionFactory projectionFactory) {
            return this.getMappedFields(entity);
        }

        Document getMappedFields(@Nullable MongoPersistentEntity<?> entity) {
            return QueryOperations.this.queryMapper.getMappedFields(new Document(this.fieldName, (Object)1), entity);
        }

        String getMappedFieldName(@Nullable MongoPersistentEntity<?> entity) {
            return (String)this.getMappedFields(entity).keySet().iterator().next();
        }

        <T> Class<T> getDriverCompatibleClass(Class<T> type) {
            return QueryOperations.this.codecRegistryProvider.getCodecFor(type).map(Encoder::getEncoderClass).orElse(BsonValue.class);
        }

        Class<?> getMostSpecificConversionTargetType(Class<?> requestedTargetType, Class<?> domainType) {
            Class conversionTargetType = requestedTargetType;
            try {
                Class propertyType = PropertyPath.from((String)this.fieldName, domainType).getLeafProperty().getLeafType();
                if (ClassUtils.isAssignable(requestedTargetType, (Class)propertyType)) {
                    conversionTargetType = propertyType;
                }
            }
            catch (PropertyReferenceException propertyReferenceException) {
                // empty catch block
            }
            return conversionTargetType;
        }
    }

    class QueryContext {
        private final Query query;

        private QueryContext(Query query) {
            this.query = query != null ? query : new Query();
        }

        Query getQuery() {
            return this.query;
        }

        Document getQueryObject() {
            return this.query.getQueryObject();
        }

        <T> Document getMappedQuery(@Nullable Class<T> domainType, Function<Class<T>, MongoPersistentEntity<?>> entityLookup) {
            return this.getMappedQuery(domainType == null ? null : entityLookup.apply(domainType));
        }

        <T> Document getMappedQuery(@Nullable MongoPersistentEntity<T> entity) {
            return QueryOperations.this.queryMapper.getMappedObject((Bson)this.getQueryObject(), entity);
        }

        Document getMappedFields(@Nullable MongoPersistentEntity<?> entity, Class<?> targetType, ProjectionFactory projectionFactory) {
            Document fields;
            Document mappedFields = fields = this.query.getFieldsObject();
            if (entity == null) {
                return mappedFields;
            }
            Document projectedFields = QueryOperations.this.propertyOperations.computeFieldsForProjection(projectionFactory, fields, entity.getType(), targetType);
            mappedFields = ObjectUtils.nullSafeEquals((Object)fields, (Object)projectedFields) ? QueryOperations.this.queryMapper.getMappedFields(projectedFields, entity) : QueryOperations.this.queryMapper.getMappedFields(projectedFields, (MongoPersistentEntity)QueryOperations.this.mappingContext.getRequiredPersistentEntity(targetType));
            if (entity != null && entity.hasTextScoreProperty() && !this.query.getQueryObject().containsKey((Object)"$text")) {
                mappedFields.remove((Object)entity.getTextScoreProperty().getFieldName());
            }
            return mappedFields;
        }

        Document getMappedSort(@Nullable MongoPersistentEntity<?> entity) {
            return QueryOperations.this.queryMapper.getMappedSort(this.query.getSortObject(), entity);
        }

        void applyCollation(@Nullable Class<?> domainType, Consumer<com.mongodb.client.model.Collation> consumer) {
            this.getCollation(domainType).ifPresent(consumer::accept);
        }

        Optional<com.mongodb.client.model.Collation> getCollation(@Nullable Class<?> domainType) {
            return QueryOperations.this.entityOperations.forType(domainType).getCollation(this.query).map(Collation::toMongoCollation);
        }
    }
}

