/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationRenderer;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.util.Assert;

public class FacetOperation
implements FieldsExposingAggregationOperation {
    public static final FacetOperation EMPTY = new FacetOperation();
    private final Facets facets;

    public FacetOperation() {
        this(Facets.EMPTY);
    }

    private FacetOperation(Facets facets) {
        this.facets = facets;
    }

    public FacetOperationBuilder and(AggregationOperation ... operations) {
        Assert.notNull((Object)operations, (String)"AggregationOperations must not be null!");
        Assert.notEmpty((Object[])operations, (String)"AggregationOperations must not be empty!");
        return new FacetOperationBuilder(this.facets, Arrays.asList(operations));
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        return new Document(this.getOperator(), (Object)this.facets.toDocument(context));
    }

    @Override
    public String getOperator() {
        return "$facet";
    }

    @Override
    public ExposedFields getFields() {
        return this.facets.asExposedFields();
    }

    private static class Facet {
        private final ExposedFields.ExposedField exposedField;
        private final List<AggregationOperation> operations;

        Facet(ExposedFields.ExposedField exposedField, List<AggregationOperation> operations) {
            Assert.notNull((Object)exposedField, (String)"ExposedField must not be null!");
            Assert.notNull(operations, (String)"AggregationOperations must not be null!");
            this.exposedField = exposedField;
            this.operations = operations;
        }

        ExposedFields.ExposedField getExposedField() {
            return this.exposedField;
        }

        protected List<Document> toDocuments(AggregationOperationContext context) {
            return AggregationOperationRenderer.toDocument(this.operations, context);
        }
    }

    private static class Facets {
        private static final Facets EMPTY = new Facets(Collections.emptyList());
        private List<Facet> facets;

        private Facets(List<Facet> facets) {
            this.facets = facets;
        }

        ExposedFields asExposedFields() {
            ExposedFields fields = ExposedFields.from(new ExposedFields.ExposedField[0]);
            for (Facet facet : this.facets) {
                fields = fields.and(facet.getExposedField());
            }
            return fields;
        }

        protected Document toDocument(AggregationOperationContext context) {
            Document document = new Document();
            for (Facet facet : this.facets) {
                document.put(facet.getExposedField().getName(), facet.toDocuments(context));
            }
            return document;
        }

        Facets and(String fieldName, List<AggregationOperation> operations) {
            Assert.hasText((String)fieldName, (String)"FieldName must not be null or empty!");
            Assert.notNull(operations, (String)"AggregationOperations must not be null!");
            ArrayList<Facet> facets = new ArrayList<Facet>(this.facets.size() + 1);
            facets.addAll(this.facets);
            facets.add(new Facet(new ExposedFields.ExposedField(fieldName, true), operations));
            return new Facets(facets);
        }
    }

    public static class FacetOperationBuilder {
        private final Facets current;
        private final List<AggregationOperation> operations;

        private FacetOperationBuilder(Facets current, List<AggregationOperation> operations) {
            this.current = current;
            this.operations = operations;
        }

        public FacetOperation as(String fieldName) {
            Assert.hasText((String)fieldName, (String)"FieldName must not be null or empty!");
            return new FacetOperation(this.current.and(fieldName, this.operations));
        }
    }
}

