/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.Collections;
import org.bson.Document;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.core.convert.DocumentReferenceSource;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxyFactory;
import org.springframework.data.mongodb.core.convert.ReferenceLoader;
import org.springframework.data.mongodb.core.convert.ReferenceLookupDelegate;
import org.springframework.data.mongodb.core.convert.ReferenceResolver;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.util.Assert;

public class DefaultReferenceResolver
implements ReferenceResolver {
    private final ReferenceLoader referenceLoader;
    private final LazyLoadingProxyFactory proxyFactory;
    private final ReferenceLookupDelegate.LookupFunction collectionLookupFunction = (filter, ctx) -> this.getReferenceLoader().fetchMany(filter, ctx);
    private final ReferenceLookupDelegate.LookupFunction singleValueLookupFunction = (filter, ctx) -> {
        Document target = this.getReferenceLoader().fetchOne(filter, ctx);
        return target == null ? Collections.emptyList() : Collections.singleton(target);
    };

    public DefaultReferenceResolver(ReferenceLoader referenceLoader, PersistenceExceptionTranslator exceptionTranslator) {
        Assert.notNull((Object)referenceLoader, (String)"ReferenceLoader must not be null");
        Assert.notNull((Object)exceptionTranslator, (String)"ExceptionTranslator must not be null");
        this.referenceLoader = referenceLoader;
        this.proxyFactory = new LazyLoadingProxyFactory(exceptionTranslator);
    }

    @Override
    public Object resolveReference(MongoPersistentProperty property, Object source, ReferenceLookupDelegate referenceLookupDelegate, ReferenceResolver.MongoEntityReader entityReader) {
        ReferenceLookupDelegate.LookupFunction lookupFunction;
        ReferenceLookupDelegate.LookupFunction lookupFunction2 = lookupFunction = property.isCollectionLike() || property.isMap() ? this.collectionLookupFunction : this.singleValueLookupFunction;
        if (this.isLazyReference(property)) {
            return this.createLazyLoadingProxy(property, source, referenceLookupDelegate, lookupFunction, entityReader);
        }
        return referenceLookupDelegate.readReference(property, source, lookupFunction, entityReader);
    }

    protected boolean isLazyReference(MongoPersistentProperty property) {
        if (property.isDocumentReference()) {
            return property.getDocumentReference().lazy();
        }
        return property.getDBRef() != null && property.getDBRef().lazy();
    }

    protected ReferenceLoader getReferenceLoader() {
        return this.referenceLoader;
    }

    LazyLoadingProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    private Object createLazyLoadingProxy(MongoPersistentProperty property, Object source, ReferenceLookupDelegate referenceLookupDelegate, ReferenceLookupDelegate.LookupFunction lookupFunction, ReferenceResolver.MongoEntityReader entityReader) {
        return this.proxyFactory.createLazyLoadingProxy(property, it -> referenceLookupDelegate.readReference(it, source, lookupFunction, entityReader), source instanceof DocumentReferenceSource ? ((DocumentReferenceSource)source).getTargetSource() : source);
    }
}

