/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import org.bson.BsonNull;
import org.bson.Document;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Window;
import org.springframework.data.mongodb.core.EntityOperations;
import org.springframework.data.mongodb.core.query.Query;

class ScrollUtils {
    ScrollUtils() {
    }

    static KeysetScrollQuery createKeysetPaginationQuery(Query query, String idPropertyName) {
        KeysetScrollPosition keyset = query.getKeyset();
        KeysetScrollDirector director = KeysetScrollDirector.of(keyset.getDirection());
        Document sortObject = director.getSortObject(idPropertyName, query);
        Document fieldsObject = director.getFieldsObject(query.getFieldsObject(), sortObject);
        Document queryObject = director.createQuery(keyset, query.getQueryObject(), sortObject);
        return new KeysetScrollQuery(queryObject, fieldsObject, sortObject);
    }

    static <T> Window<T> createWindow(Query query, List<T> result, Class<?> sourceType, EntityOperations operations) {
        Document sortObject = query.getSortObject();
        KeysetScrollPosition keyset = query.getKeyset();
        KeysetScrollDirector director = KeysetScrollDirector.of(keyset.getDirection());
        List resultsToUse = director.postPostProcessResults(result, query.getLimit());
        IntFunction<ScrollPosition> positionFunction = value -> {
            Object last = resultsToUse.get(value);
            EntityOperations.Entity entity = operations.forEntity(last);
            Map<String, Object> keys = entity.extractKeys(sortObject, sourceType);
            return ScrollPosition.forward(keys);
        };
        return Window.from(resultsToUse, positionFunction, (boolean)ScrollUtils.hasMoreElements(result, query.getLimit()));
    }

    static <T> Window<T> createWindow(List<T> result, int limit, IntFunction<? extends ScrollPosition> positionFunction) {
        return Window.from(ScrollUtils.getSubList(result, limit), positionFunction, (boolean)ScrollUtils.hasMoreElements(result, limit));
    }

    static boolean hasMoreElements(List<?> result, int limit) {
        return !result.isEmpty() && result.size() > limit;
    }

    static <T> List<T> getSubList(List<T> result, int limit) {
        if (limit > 0 && result.size() > limit) {
            return result.subList(0, limit);
        }
        return result;
    }

    static <T> List<T> getFirst(int count, List<T> list) {
        if (count > 0 && list.size() > count) {
            return list.subList(0, count);
        }
        return list;
    }

    static <T> List<T> getLast(int count, List<T> list) {
        if (count > 0 && list.size() > count) {
            return list.subList(list.size() - count, list.size());
        }
        return list;
    }

    static class KeysetScrollDirector {
        private static final KeysetScrollDirector FORWARD = new KeysetScrollDirector();
        private static final KeysetScrollDirector REVERSE = new ReverseKeysetScrollDirector();

        KeysetScrollDirector() {
        }

        public static KeysetScrollDirector of(ScrollPosition.Direction direction) {
            return direction == ScrollPosition.Direction.FORWARD ? FORWARD : REVERSE;
        }

        public Document getSortObject(String idPropertyName, Query query) {
            Document sortObject = query.isSorted() ? query.getSortObject() : new Document();
            sortObject.put(idPropertyName, (Object)1);
            return sortObject;
        }

        public Document getFieldsObject(Document fieldsObject, Document sortObject) {
            if (!fieldsObject.isEmpty()) {
                for (String field : sortObject.keySet()) {
                    fieldsObject.put(field, (Object)1);
                }
            }
            return fieldsObject;
        }

        public Document createQuery(KeysetScrollPosition keyset, Document queryObject, Document sortObject) {
            Map keysetValues = keyset.getKeys();
            List or = (List)queryObject.getOrDefault((Object)"$or", new ArrayList());
            ArrayList sortKeys = new ArrayList(sortObject.keySet());
            if (keysetValues.isEmpty()) {
                return queryObject;
            }
            if (!keysetValues.keySet().containsAll(sortKeys)) {
                throw new IllegalStateException("KeysetScrollPosition does not contain all keyset values");
            }
            for (int i = 0; i < sortKeys.size(); ++i) {
                Document sortConstraint = new Document();
                for (int j = 0; j < sortKeys.size(); ++j) {
                    String sortSegment = (String)sortKeys.get(j);
                    int sortOrder = sortObject.getInteger((Object)sortSegment);
                    Object o = keysetValues.get(sortSegment);
                    if (j >= i) {
                        if (o instanceof BsonNull) {
                            throw new IllegalStateException("Cannot resume from KeysetScrollPosition. Offending key: '%s' is 'null'".formatted(sortSegment));
                        }
                        sortConstraint.put(sortSegment, (Object)new Document(this.getComparator(sortOrder), o));
                        break;
                    }
                    sortConstraint.put(sortSegment, o);
                }
                if (sortConstraint.isEmpty()) continue;
                or.add(sortConstraint);
            }
            if (!or.isEmpty()) {
                queryObject.put("$or", (Object)or);
            }
            return queryObject;
        }

        protected String getComparator(int sortOrder) {
            return sortOrder == 1 ? "$gt" : "$lt";
        }

        protected <T> List<T> postPostProcessResults(List<T> list, int limit) {
            return ScrollUtils.getFirst(limit, list);
        }
    }

    record KeysetScrollQuery(Document query, Document fields, Document sort) {
    }

    private static class ReverseKeysetScrollDirector
    extends KeysetScrollDirector {
        private ReverseKeysetScrollDirector() {
        }

        @Override
        public Document getSortObject(String idPropertyName, Query query) {
            Document sortObject = super.getSortObject(idPropertyName, query);
            Iterator iterator = sortObject.keySet().iterator();
            while (iterator.hasNext()) {
                String field;
                sortObject.put(field, (Object)(sortObject.getInteger((Object)(field = (String)iterator.next())) == 1 ? -1 : 1));
            }
            return sortObject;
        }

        @Override
        public <T> List<T> postPostProcessResults(List<T> list, int limit) {
            Collections.reverse(list);
            return ScrollUtils.getLast(limit, list);
        }
    }
}

