/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.aggregation;

import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.TypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.NoOpDbRefResolver;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.lang.Nullable;

public class TestAggregationContext
implements AggregationOperationContext {
    private final AggregationOperationContext delegate;

    private TestAggregationContext(AggregationOperationContext delegate) {
        this.delegate = delegate;
    }

    public static AggregationOperationContext contextFor(@Nullable Class<?> type) {
        MappingMongoConverter mongoConverter = new MappingMongoConverter(NoOpDbRefResolver.INSTANCE, (MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty>)new MongoMappingContext());
        mongoConverter.afterPropertiesSet();
        return TestAggregationContext.contextFor(type, mongoConverter);
    }

    public static AggregationOperationContext contextFor(@Nullable Class<?> type, MongoConverter mongoConverter) {
        if (type == null) {
            return Aggregation.DEFAULT_CONTEXT;
        }
        return new TestAggregationContext(new TypeBasedAggregationOperationContext(type, mongoConverter.getMappingContext(), new QueryMapper(mongoConverter)).continueOnMissingFieldReference());
    }

    @Override
    public Document getMappedObject(Document document, @Nullable Class<?> type) {
        return this.delegate.getMappedObject(document, type);
    }

    @Override
    public ExposedFields.FieldReference getReference(Field field) {
        return this.delegate.getReference(field);
    }

    @Override
    public ExposedFields.FieldReference getReference(String name) {
        return this.delegate.getReference(name);
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.delegate.getCodecRegistry();
    }
}

