/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert.encryption;

import org.springframework.data.mongodb.core.convert.MongoConversionContext;
import org.springframework.data.mongodb.core.encryption.EncryptionContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.EvaluationContext;
import org.springframework.lang.Nullable;

class ExplicitEncryptionContext
implements EncryptionContext {
    private final MongoConversionContext conversionContext;

    public ExplicitEncryptionContext(MongoConversionContext conversionContext) {
        this.conversionContext = conversionContext;
    }

    @Override
    public MongoPersistentProperty getProperty() {
        return this.conversionContext.getProperty();
    }

    @Override
    @Nullable
    public Object lookupValue(String path) {
        return this.conversionContext.getValue(path);
    }

    @Override
    public Object convertToMongoType(Object value) {
        return this.conversionContext.write(value);
    }

    @Override
    public EvaluationContext getEvaluationContext(Object source) {
        return this.conversionContext.getSpELContext().getEvaluationContext(source);
    }

    @Override
    public <T> T read(@Nullable Object value, TypeInformation<T> target) {
        return this.conversionContext.read(value, target);
    }

    @Override
    public <T> T write(@Nullable Object value, TypeInformation<T> target) {
        return this.conversionContext.write(value, target);
    }

    @Override
    @Nullable
    public MongoConversionContext.OperatorContext getOperatorContext() {
        return this.conversionContext.getOperatorContext();
    }
}

