/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.util.AbstractMap;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.CachingMongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.mapping.UnwrapEntityContext;
import org.springframework.data.mongodb.core.mapping.UnwrappedMongoPersistentEntity;
import org.springframework.data.util.NullableWrapperConverters;
import org.springframework.data.util.TypeInformation;

public class MongoMappingContext
extends AbstractMappingContext<MongoPersistentEntity<?>, MongoPersistentProperty>
implements ApplicationContextAware {
    private static final FieldNamingStrategy DEFAULT_NAMING_STRATEGY = PropertyNameFieldNamingStrategy.INSTANCE;
    private FieldNamingStrategy fieldNamingStrategy = DEFAULT_NAMING_STRATEGY;
    private boolean autoIndexCreation = false;
    private @Nullable ApplicationContext applicationContext;

    public MongoMappingContext() {
        this.setSimpleTypeHolder(MongoSimpleTypes.HOLDER);
    }

    public void setFieldNamingStrategy(@Nullable FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy == null ? DEFAULT_NAMING_STRATEGY : fieldNamingStrategy;
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        if (NullableWrapperConverters.supports((Class)type.getType())) {
            return false;
        }
        return !MongoSimpleTypes.HOLDER.isSimpleType(type.getType()) && !AbstractMap.class.isAssignableFrom(type.getType());
    }

    public MongoPersistentProperty createPersistentProperty(Property property, MongoPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        CachingMongoPersistentProperty cachingMongoPersistentProperty = new CachingMongoPersistentProperty(property, owner, simpleTypeHolder, this.fieldNamingStrategy);
        cachingMongoPersistentProperty.validate();
        return cachingMongoPersistentProperty;
    }

    protected <T> BasicMongoPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new BasicMongoPersistentEntity<T>(typeInformation);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        super.setApplicationContext(applicationContext);
    }

    public boolean isAutoIndexCreation() {
        return this.autoIndexCreation;
    }

    public void setAutoIndexCreation(boolean autoCreateIndexes) {
        this.autoIndexCreation = autoCreateIndexes;
    }

    public @Nullable MongoPersistentEntity<?> getPersistentEntity(MongoPersistentProperty persistentProperty) {
        MongoPersistentEntity entity = (MongoPersistentEntity)super.getPersistentEntity((PersistentProperty)persistentProperty);
        if (entity == null || !persistentProperty.isUnwrapped()) {
            return entity;
        }
        return new UnwrappedMongoPersistentEntity(entity, new UnwrapEntityContext(persistentProperty));
    }
}

