/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import java.util.Map;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.DefaultMongoTransactionOptionsResolver;
import org.springframework.data.mongodb.MongoTransactionOptions;
import org.springframework.data.mongodb.TransactionOptionResolver;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public interface MongoTransactionOptionsResolver
extends TransactionOptionResolver<MongoTransactionOptions> {
    public static MongoTransactionOptionsResolver defaultResolver() {
        return DefaultMongoTransactionOptionsResolver.INSTANCE;
    }

    public @Nullable String getLabelPrefix();

    @Override
    default public MongoTransactionOptions resolve(TransactionDefinition definition) {
        if (!(definition instanceof TransactionAttribute)) {
            return MongoTransactionOptions.NONE;
        }
        TransactionAttribute attribute = (TransactionAttribute)definition;
        if (attribute.getLabels().isEmpty()) {
            return MongoTransactionOptions.NONE;
        }
        Map<String, String> attributeMap = attribute.getLabels().stream().filter(it -> !StringUtils.hasText((String)this.getLabelPrefix()) || it.startsWith(this.getLabelPrefix())).map(it -> StringUtils.hasText((String)this.getLabelPrefix()) ? it.substring(this.getLabelPrefix().length()) : it).map(it -> {
            String[] kvPair = StringUtils.split((String)it, (String)"=");
            Assert.isTrue((kvPair != null && kvPair.length == 2 ? 1 : 0) != 0, () -> "No value present for transaction option %s".formatted(kvPair != null ? kvPair[0] : it));
            return kvPair;
        }).collect(Collectors.toMap(it -> it[0].trim(), it -> it[1].trim()));
        return attributeMap.isEmpty() ? MongoTransactionOptions.NONE : this.convert(attributeMap);
    }

    public MongoTransactionOptions convert(Map<String, String> var1);
}

