/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.UpdateResult;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.QueryResultConverter;
import org.springframework.data.mongodb.core.ReplaceOptions;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.lang.Contract;

public interface ExecutableUpdateOperation {
    public <T> ExecutableUpdate<T> update(Class<T> var1);

    public static interface ExecutableUpdate<T>
    extends UpdateWithCollection<T>,
    UpdateWithQuery<T>,
    UpdateWithUpdate<T> {
    }

    public static interface FindAndReplaceWithProjection<T>
    extends FindAndReplaceWithOptions<T> {
        public <R> FindAndReplaceWithOptions<R> as(Class<R> var1);
    }

    public static interface FindAndReplaceWithOptions<T>
    extends TerminatingFindAndReplace<T>,
    ReplaceWithOptions {
        public FindAndReplaceWithProjection<T> withOptions(FindAndReplaceOptions var1);
    }

    public static interface ReplaceWithOptions
    extends TerminatingReplace {
        public TerminatingReplace withOptions(ReplaceOptions var1);
    }

    public static interface FindAndModifyWithOptions<T> {
        public TerminatingFindAndModify<T> withOptions(FindAndModifyOptions var1);
    }

    public static interface UpdateWithQuery<T>
    extends UpdateWithUpdate<T> {
        public UpdateWithUpdate<T> matching(Query var1);

        default public UpdateWithUpdate<T> matching(CriteriaDefinition criteria) {
            return this.matching(Query.query(criteria));
        }
    }

    public static interface UpdateWithCollection<T> {
        public UpdateWithQuery<T> inCollection(String var1);
    }

    public static interface UpdateWithUpdate<T> {
        public TerminatingUpdate<T> apply(UpdateDefinition var1);

        public FindAndReplaceWithProjection<T> replaceWith(T var1);
    }

    public static interface TerminatingUpdate<T>
    extends TerminatingFindAndModify<T>,
    FindAndModifyWithOptions<T> {
        public UpdateResult all();

        public UpdateResult first();

        public UpdateResult upsert();
    }

    public static interface TerminatingFindAndReplace<T>
    extends TerminatingReplace {
        default public Optional<T> findAndReplace() {
            return Optional.ofNullable(this.findAndReplaceValue());
        }

        public @Nullable T findAndReplaceValue();

        @Contract(value="_ -> new")
        public <R> TerminatingFindAndReplace<R> map(QueryResultConverter<? super T, ? extends R> var1);
    }

    public static interface TerminatingReplace {
        public UpdateResult replaceFirst();
    }

    public static interface TerminatingFindAndModify<T> {
        @Contract(value="_ -> new")
        public <R> TerminatingFindAndModify<R> map(QueryResultConverter<? super T, ? extends R> var1);

        default public Optional<T> findAndModify() {
            return Optional.ofNullable(this.findAndModifyValue());
        }

        public @Nullable T findAndModifyValue();
    }
}

