/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.DeleteResult;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.QueryResultConverter;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.ReactiveRemoveOperation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveRemoveOperationSupport
implements ReactiveRemoveOperation {
    private static final Query ALL_QUERY = new Query();
    private final ReactiveMongoTemplate template;

    ReactiveRemoveOperationSupport(ReactiveMongoTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveRemoveOperation.ReactiveRemove<T> remove(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveRemoveSupport(this.template, domainType, ALL_QUERY, null, QueryResultConverter.entity());
    }

    static class ReactiveRemoveSupport<S, T>
    implements ReactiveRemoveOperation.ReactiveRemove<T>,
    ReactiveRemoveOperation.RemoveWithCollection<T> {
        private final ReactiveMongoTemplate template;
        private final Class<S> domainType;
        private final Query query;
        private final @Nullable String collection;
        private final QueryResultConverter<? super S, ? extends T> resultConverter;

        ReactiveRemoveSupport(ReactiveMongoTemplate template, Class<S> domainType, Query query, @Nullable String collection, QueryResultConverter<? super S, ? extends T> resultConverter) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.collection = collection;
            this.resultConverter = resultConverter;
        }

        @Override
        public ReactiveRemoveOperation.RemoveWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty");
            return new ReactiveRemoveSupport<S, T>(this.template, this.domainType, this.query, collection, this.resultConverter);
        }

        @Override
        public ReactiveRemoveOperation.TerminatingRemove<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            return new ReactiveRemoveSupport<S, T>(this.template, this.domainType, query, this.collection, this.resultConverter);
        }

        @Override
        public Mono<DeleteResult> all() {
            String collectionName = this.getCollectionName();
            return this.template.doRemove(collectionName, this.query, this.domainType);
        }

        @Override
        public Flux<T> findAndRemove() {
            String collectionName = this.getCollectionName();
            return this.template.doFindAndDelete(collectionName, this.query, this.domainType, this.resultConverter);
        }

        @Override
        public <R> ReactiveRemoveOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            return new ReactiveRemoveSupport<T, R>(this.template, this.domainType, this.query, this.collection, converter);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }
    }
}

