/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import org.jspecify.annotations.Nullable;
import org.springframework.lang.Contract;
import org.springframework.util.ObjectUtils;

public class Term {
    private final Type type;
    private final String raw;
    private boolean negated;

    public Term(String raw) {
        this(raw, Type.WORD);
    }

    public Term(String raw, @Nullable Type type) {
        this.raw = raw;
        this.type = type == null ? Type.WORD : type;
    }

    @Contract(value="-> this")
    public Term negate() {
        this.negated = true;
        return this;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public Type getType() {
        return this.type;
    }

    public String getFormatted() {
        String formatted = Type.PHRASE.equals((Object)this.type) ? this.quotePhrase(this.raw) : this.raw;
        return this.negated ? this.negateRaw(formatted) : formatted;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Term)) {
            return false;
        }
        Term other = (Term)o;
        return ObjectUtils.nullSafeEquals((Object)this.negated, (Object)other.negated) && ObjectUtils.nullSafeEquals((Object)((Object)this.type), (Object)((Object)other.type)) && ObjectUtils.nullSafeEquals((Object)this.raw, (Object)other.raw);
    }

    public int hashCode() {
        int result = 17;
        result += ObjectUtils.nullSafeHashCode((Object)((Object)this.type));
        result += ObjectUtils.nullSafeHashCode((Object)this.raw);
        return result += ObjectUtils.nullSafeHashCode((Object)this.negated);
    }

    public String toString() {
        return this.getFormatted();
    }

    protected String quotePhrase(String raw) {
        return "\"" + raw + "\"";
    }

    protected String negateRaw(String raw) {
        return "-" + raw;
    }

    public static enum Type {
        WORD,
        PHRASE;

    }
}

