/*
 * Copyright 2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.mongodb.repository.aot;

/**
 * Base abstraction for interactions with MongoDB.
 *
 * @author Christoph Strobl
 * @since 5.0
 */
abstract class MongoInteraction {

	abstract InteractionType getExecutionType();

	boolean isAggregation() {
		return InteractionType.AGGREGATION.equals(getExecutionType());
	}

	boolean isCount() {
		return InteractionType.COUNT.equals(getExecutionType());
	}

	boolean isDelete() {
		return InteractionType.DELETE.equals(getExecutionType());
	}

	boolean isExists() {
		return InteractionType.EXISTS.equals(getExecutionType());
	}

	boolean isUpdate() {
		return InteractionType.UPDATE.equals(getExecutionType());
	}

	String name() {

		if (isDelete()) {
			return "deleteQuery";
		}
		if (isCount()) {
			return "countQuery";
		}
		return "filterQuery";
	}

	enum InteractionType {
		QUERY, COUNT, DELETE, EXISTS, UPDATE, AGGREGATION
	}
}
