/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.session.Session;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Repository
@Transactional(readOnly=true)
public class SimpleNeo4jRepository<T, ID extends Serializable>
implements Neo4jRepository<T, ID> {
    private static final int DEFAULT_QUERY_DEPTH = 1;
    private static final String ID_MUST_NOT_BE_NULL = "The given id must not be null!";
    private Class<T> clazz;
    private Session session;

    public SimpleNeo4jRepository(Class<T> domainClass, Session session) {
        Assert.notNull(domainClass, (String)"Domain class must not be null!");
        Assert.notNull((Object)session, (String)"Session must not be null!");
        this.clazz = domainClass;
        this.session = session;
    }

    protected Class<T> getDomainClass() {
        return this.clazz;
    }

    @Transactional
    public <S extends T> S save(S entity) {
        this.session.save(entity);
        return entity;
    }

    @Transactional
    public <S extends T> Iterable<S> save(Iterable<S> entities) {
        for (S entity : entities) {
            this.session.save(entity);
        }
        return entities;
    }

    public T findOne(ID id) {
        Assert.notNull(id, (String)ID_MUST_NOT_BE_NULL);
        return (T)this.session.load(this.clazz, id);
    }

    public boolean exists(ID id) {
        return this.findOne(id) != null;
    }

    public long count() {
        return this.session.countEntitiesOfType(this.clazz);
    }

    @Transactional
    public void delete(ID id) {
        T o = this.findOne(id);
        if (o != null) {
            this.session.delete(o);
        }
    }

    @Transactional
    public void delete(T t) {
        this.session.delete(t);
    }

    @Transactional
    public void delete(Iterable<? extends T> ts) {
        for (T t : ts) {
            this.session.delete(t);
        }
    }

    @Transactional
    public void deleteAll() {
        this.session.deleteAll(this.clazz);
    }

    @Override
    @Transactional
    public <S extends T> S save(S s, int depth) {
        this.session.save(s, depth);
        return s;
    }

    @Override
    @Transactional
    public <S extends T> Iterable<S> save(Iterable<S> ses, int depth) {
        this.session.save(ses, depth);
        return ses;
    }

    @Override
    public T findOne(ID id, int depth) {
        return (T)this.session.load(this.clazz, id, depth);
    }

    @Override
    public Iterable<T> findAll() {
        return this.findAll(1);
    }

    @Override
    public Iterable<T> findAll(int depth) {
        return this.session.loadAll(this.clazz, depth);
    }

    @Override
    public Iterable<T> findAll(Iterable<ID> longs) {
        return this.findAll(longs, 1);
    }

    @Override
    public Iterable<T> findAll(Iterable<ID> ids, int depth) {
        return this.session.loadAll(this.clazz, (Collection)ids, depth);
    }

    @Override
    public Iterable<T> findAll(Sort sort) {
        return this.findAll(sort, 1);
    }

    @Override
    public Iterable<T> findAll(Sort sort, int depth) {
        return this.session.loadAll(this.clazz, this.convert(sort), depth);
    }

    @Override
    public Iterable<T> findAll(Iterable<ID> ids, Sort sort) {
        return this.findAll(ids, sort, 1);
    }

    @Override
    public Iterable<T> findAll(Iterable<ID> ids, Sort sort, int depth) {
        return this.session.loadAll(this.clazz, (Collection)ids, this.convert(sort), depth);
    }

    @Override
    public Page<T> findAll(Pageable pageable) {
        return this.findAll(pageable, 1);
    }

    @Override
    public Page<T> findAll(Pageable pageable, int depth) {
        Collection data = this.session.loadAll(this.clazz, this.convert(pageable.getSort()), new Pagination(pageable.getPageNumber(), pageable.getPageSize()), depth);
        return this.updatePage(pageable, new ArrayList(data));
    }

    private SortOrder convert(Sort sort) {
        SortOrder sortOrder = new SortOrder();
        if (sort != null) {
            for (Sort.Order order : sort) {
                if (order.isAscending()) {
                    sortOrder.add(new String[]{order.getProperty()});
                    continue;
                }
                sortOrder.add(SortOrder.Direction.DESC, new String[]{order.getProperty()});
            }
        }
        return sortOrder;
    }

    private Page<T> updatePage(Pageable pageable, List<T> results) {
        int pageSize = pageable.getPageSize();
        int pageOffset = pageable.getOffset();
        int total = pageOffset + results.size() + (results.size() == pageSize ? pageSize : 0);
        return new PageImpl(results, pageable, (long)total);
    }
}

