/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.annotation.Version;
import org.neo4j.ogm.exception.core.MetadataException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.annotation.QueryResult;

public class Neo4jPersistentProperty
extends AnnotationBasedPersistentProperty<Neo4jPersistentProperty> {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jPersistentProperty.class);
    private final boolean isIdProperty;

    public Neo4jPersistentProperty(ClassInfo owningClassInfo, Property property, PersistentEntity<?, Neo4jPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
        if (owningClassInfo == null) {
            logger.warn("Owning ClassInfo is null for property: {}", (Object)property);
        }
        this.isIdProperty = owningClassInfo != null && owningClassInfo.getUnderlyingClass() != null && simpleTypeHolder.isSimpleType(owningClassInfo.getUnderlyingClass()) || owner.getType().isEnum() ? false : Neo4jPersistentProperty.resolveWhetherIdProperty(owningClassInfo, property);
    }

    private static boolean resolveWhetherIdProperty(ClassInfo owningClassInfo, Property property) {
        if (owningClassInfo == null || owningClassInfo.isInterface() || owningClassInfo.annotationsInfo().get(QueryResult.class.getName()) != null || owningClassInfo.isEnum()) {
            return false;
        }
        try {
            return property.getField().filter(field -> owningClassInfo.getField(owningClassInfo.identityField()).equals(field)).isPresent();
        }
        catch (MetadataException noIdentityField) {
            logger.warn("No identity field found for class of type: {} when creating persistent property for : {}", (Object)owningClassInfo.name(), (Object)property);
            return false;
        }
    }

    public boolean isIdProperty() {
        logger.debug("[property].isIdProperty() returns {}", (Object)this.isIdProperty);
        return this.isIdProperty;
    }

    public boolean isVersionProperty() {
        return this.isAnnotationPresent(Version.class);
    }

    public boolean usePropertyAccess() {
        logger.debug("[property].usePropertyAccess() returns false");
        return false;
    }

    public boolean isAssociation() {
        return !this.isTransient() && (this.isAnnotationPresent(Relationship.class) || this.isAnnotationPresent(StartNode.class) || this.isAnnotationPresent(EndNode.class));
    }

    protected Association<Neo4jPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }
}

