/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.spel;

import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.data.neo4j.repository.query.spel.Neo4jQueryPlaceholderSupplier;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.SpelEvaluator;
import org.springframework.data.repository.query.SpelQueryContext;

public class ParameterizedQuery {
    private final Parameters<?, ?> methodParameters;
    private final SpelEvaluator spelEvaluator;

    private ParameterizedQuery(Parameters<?, ?> methodParameters, SpelEvaluator spelEvaluator) {
        this.methodParameters = methodParameters;
        this.spelEvaluator = spelEvaluator;
    }

    public static ParameterizedQuery getParameterizedQuery(String queryString, Parameters<?, ?> methodParameters, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Neo4jQueryPlaceholderSupplier supplier = new Neo4jQueryPlaceholderSupplier();
        SpelQueryContext.EvaluatingSpelQueryContext context = SpelQueryContext.of((index, prefix) -> supplier.parameterName((int)index), (prefix, name) -> supplier.decoratePlaceholder((String)name)).withEvaluationContextProvider(evaluationContextProvider);
        SpelEvaluator evaluator = context.parse(queryString, methodParameters);
        return new ParameterizedQuery(methodParameters, evaluator);
    }

    public Map<String, Object> resolveParameter(Object[] parameters, BiFunction<Parameters<?, ?>, Object[], Map<String, Object>> nativePlaceholderFunction) {
        Map parameterValues = this.spelEvaluator.evaluate(parameters);
        Map<String, Object> nativeParameterValues = nativePlaceholderFunction.apply(this.methodParameters, parameters);
        parameterValues.putAll(nativeParameterValues);
        return parameterValues;
    }

    public String getQueryString() {
        return this.spelEvaluator.getQueryString();
    }
}

