/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.event;

import org.apiguardian.api.API;
import org.springframework.core.Ordered;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.event.BeforeBindCallback;

@API(status=API.Status.INTERNAL, since="6.0")
public final class OptimisticLockingBeforeBindCallback
implements BeforeBindCallback<Object>,
Ordered {
    private final Neo4jMappingContext neo4jMappingContext;

    public OptimisticLockingBeforeBindCallback(Neo4jMappingContext neo4jMappingContext) {
        this.neo4jMappingContext = neo4jMappingContext;
    }

    @Override
    public Object onBeforeBind(Object entity) {
        Neo4jPersistentEntity neo4jPersistentEntity = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredNodeDescription(entity.getClass());
        if (neo4jPersistentEntity.hasVersionProperty()) {
            PersistentPropertyAccessor propertyAccessor = neo4jPersistentEntity.getPropertyAccessor(entity);
            Neo4jPersistentProperty versionProperty = (Neo4jPersistentProperty)neo4jPersistentEntity.getRequiredVersionProperty();
            if (!Long.class.isAssignableFrom(versionProperty.getType())) {
                return entity;
            }
            Long versionPropertyValue = (Long)propertyAccessor.getProperty((PersistentProperty)versionProperty);
            long newVersionValue = 0L;
            if (versionPropertyValue != null) {
                newVersionValue = versionPropertyValue + 1L;
            }
            propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)newVersionValue);
        }
        return entity;
    }

    public int getOrder() {
        return 111;
    }
}

