/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import reactor.core.publisher.Mono;

@FunctionalInterface
interface Neo4jQueryExecution {
    public Object execute(PreparedQuery var1, boolean var2);

    public static class ReactiveQueryExecution
    implements Neo4jQueryExecution {
        private final ReactiveNeo4jOperations neo4jOperations;

        ReactiveQueryExecution(ReactiveNeo4jOperations neo4jOperations) {
            this.neo4jOperations = neo4jOperations;
        }

        @Override
        public Object execute(PreparedQuery preparedQuery, boolean asCollectionQuery) {
            Mono executableQuery = this.neo4jOperations.toExecutableQuery(preparedQuery);
            if (asCollectionQuery) {
                return executableQuery.flatMapMany(q -> q.getResults());
            }
            return executableQuery.flatMap(q -> q.getSingleResult());
        }
    }

    public static class DefaultQueryExecution
    implements Neo4jQueryExecution {
        private final Neo4jOperations neo4jOperations;

        DefaultQueryExecution(Neo4jOperations neo4jOperations) {
            this.neo4jOperations = neo4jOperations;
        }

        @Override
        public Object execute(PreparedQuery preparedQuery, boolean asCollectionQuery) {
            Neo4jOperations.ExecutableQuery executableQuery = this.neo4jOperations.toExecutableQuery(preparedQuery);
            if (asCollectionQuery) {
                return executableQuery.getResults();
            }
            return executableQuery.getSingleResult();
        }
    }
}

