/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.SummaryCounters;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.neo4j.core.DatabaseSelectionProvider;
import org.springframework.data.neo4j.core.DynamicLabels;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.CreateRelationshipStatementHolder;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipContext;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipProcessingStateMachine;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.mapping.callback.EventSupport;
import org.springframework.data.neo4j.repository.NoResultException;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@API(status=API.Status.STABLE, since="6.0")
public final class Neo4jTemplate
implements Neo4jOperations,
BeanFactoryAware {
    private static final LogAccessor log = new LogAccessor(LogFactory.getLog(Neo4jTemplate.class));
    private static final String OPTIMISTIC_LOCKING_ERROR_MESSAGE = "An entity with the required version does not exist.";
    private static final Renderer renderer = Renderer.getDefaultRenderer();
    private final Neo4jClient neo4jClient;
    private final Neo4jMappingContext neo4jMappingContext;
    private final CypherGenerator cypherGenerator;
    private EventSupport eventSupport;
    private final DatabaseSelectionProvider databaseSelectionProvider;

    public Neo4jTemplate(Neo4jClient neo4jClient) {
        this(neo4jClient, new Neo4jMappingContext(), DatabaseSelectionProvider.getDefaultSelectionProvider());
    }

    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, DatabaseSelectionProvider databaseSelectionProvider) {
        this(neo4jClient, neo4jMappingContext, databaseSelectionProvider, EntityCallbacks.create());
    }

    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, DatabaseSelectionProvider databaseSelectionProvider, EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)neo4jClient, (String)"The Neo4jClient is required");
        Assert.notNull((Object)neo4jMappingContext, (String)"The Neo4jMappingContext is required");
        Assert.notNull((Object)databaseSelectionProvider, (String)"The database name provider is required");
        this.neo4jClient = neo4jClient;
        this.neo4jMappingContext = neo4jMappingContext;
        this.cypherGenerator = CypherGenerator.INSTANCE;
        this.eventSupport = EventSupport.useExistingCallbacks(neo4jMappingContext, entityCallbacks);
        this.databaseSelectionProvider = databaseSelectionProvider;
    }

    @Override
    public long count(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData).returning(new Expression[]{Functions.count((Expression)Cypher.asterisk())}).build();
        return this.count(statement);
    }

    @Override
    public long count(Statement statement) {
        return this.count(statement, Collections.emptyMap());
    }

    @Override
    public long count(Statement statement, Map<String, Object> parameters) {
        return this.count(renderer.render(statement), parameters);
    }

    @Override
    public long count(String cypherQuery) {
        return this.count(cypherQuery, Collections.emptyMap());
    }

    @Override
    public long count(String cypherQuery, Map<String, Object> parameters) {
        PreparedQuery<Long> preparedQuery = PreparedQuery.queryFor(Long.class).withCypherQuery(cypherQuery).withParameters(parameters).build();
        return this.toExecutableQuery(preparedQuery).getRequiredSingleResult();
    }

    @Override
    public <T> List<T> findAll(Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData).returning(new Expression[]{this.cypherGenerator.createReturnStatementForMatch(entityMetaData)}).build();
        return this.createExecutableQuery(domainType, statement).getResults();
    }

    @Override
    public <T> List<T> findAll(Statement statement, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement).getResults();
    }

    @Override
    public <T> List<T> findAll(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement, parameters).getResults();
    }

    @Override
    public <T> Optional<T> findOne(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement, parameters).getSingleResult();
    }

    @Override
    public <T> List<T> findAll(String cypherQuery, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery).getResults();
    }

    @Override
    public <T> List<T> findAll(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery, parameters).getResults();
    }

    @Override
    public <T> Optional<T> findOne(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery, parameters).getSingleResult();
    }

    @Override
    public <T> Optional<T> findById(Object id, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)"__id__"))).returning(new Expression[]{this.cypherGenerator.createReturnStatementForMatch(entityMetaData)}).build();
        return this.createExecutableQuery(domainType, statement, Collections.singletonMap("__id__", this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id))).getSingleResult();
    }

    @Override
    public <T> List<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)"__ids__"))).returning(new Expression[]{this.cypherGenerator.createReturnStatementForMatch(entityMetaData)}).build();
        return this.createExecutableQuery(domainType, statement, Collections.singletonMap("__ids__", this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids))).getResults();
    }

    private Object convertIdValues(@Nullable Neo4jPersistentProperty idProperty, Object idValues) {
        return this.neo4jMappingContext.getConversionService().writeValue(idValues, (TypeInformation<?>)ClassTypeInformation.from(idValues.getClass()), idProperty == null ? null : idProperty.getOptionalWritingConverter());
    }

    @Override
    public <T> T save(T instance) {
        return this.saveImpl(instance, this.getDatabaseName());
    }

    private <T> T saveImpl(T instance, @Nullable String inDatabase) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(instance.getClass());
        boolean isEntityNew = entityMetaData.isNew(instance);
        T entityToBeSaved = this.eventSupport.maybeCallBeforeBind(instance);
        DynamicLabels dynamicLabels = this.determineDynamicLabels(entityToBeSaved, entityMetaData, inDatabase);
        Optional optionalInternalId = ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOf(entityMetaData, dynamicLabels))).in(inDatabase).bind(entityToBeSaved).with(this.neo4jMappingContext.getRequiredBinderFunctionFor(entityToBeSaved.getClass()))).fetchAs(Long.class).one();
        if (entityMetaData.hasVersionProperty() && !optionalInternalId.isPresent()) {
            throw new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE);
        }
        PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
        if (!entityMetaData.isUsingInternalIds()) {
            this.processRelations(entityMetaData, entityToBeSaved, isEntityNew, inDatabase);
            return entityToBeSaved;
        }
        propertyAccessor.setProperty(entityMetaData.getRequiredIdProperty(), optionalInternalId.get());
        this.processRelations(entityMetaData, entityToBeSaved, isEntityNew, inDatabase);
        return (T)propertyAccessor.getBean();
    }

    private <T> DynamicLabels determineDynamicLabels(T entityToBeSaved, Neo4jPersistentEntity<?> entityMetaData, @Nullable String inDatabase) {
        return entityMetaData.getDynamicLabelsProperty().map(p -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
            Neo4jClient.RunnableSpecTightToDatabase runnableQuery = (Neo4jClient.RunnableSpecTightToDatabase)((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.createStatementReturningDynamicLabels(entityMetaData))).in(inDatabase).bind(propertyAccessor.getProperty(entityMetaData.getRequiredIdProperty())).to("__id__")).bind(entityMetaData.getStaticLabels()).to("__staticLabels__");
            if (entityMetaData.hasVersionProperty()) {
                runnableQuery = (Neo4jClient.RunnableSpecTightToDatabase)runnableQuery.bind((Long)propertyAccessor.getProperty(entityMetaData.getRequiredVersionProperty()) - 1L).to("__version__");
            }
            Optional<Map<String, Object>> optionalResult = runnableQuery.fetch().one();
            return new DynamicLabels(optionalResult.map(r -> (Collection)r.get("__nodeLabels__")).orElseGet(Collections::emptyList), (Collection)propertyAccessor.getProperty((PersistentProperty)p));
        }).orElse(DynamicLabels.EMPTY);
    }

    @Override
    public <T> List<T> saveAll(Iterable<T> instances) {
        ArrayList entities;
        String databaseName = this.getDatabaseName();
        if (instances instanceof Collection) {
            entities = (ArrayList)instances;
        } else {
            entities = new ArrayList();
            instances.forEach(entities::add);
        }
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        Class domainClass = CollectionUtils.findCommonElementType(entities);
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainClass);
        if (entityMetaData.isUsingInternalIds() || entityMetaData.hasVersionProperty() || entityMetaData.getDynamicLabelsProperty().isPresent()) {
            log.debug((CharSequence)"Saving entities using single statements.");
            return entities.stream().map(e -> this.saveImpl(e, databaseName)).collect(Collectors.toList());
        }
        List isNewIndicator = entities.stream().map(entity -> ((Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(entity.getClass())).isNew(entity)).collect(Collectors.toList());
        List<Object> entitiesToBeSaved = entities.stream().map(this.eventSupport::maybeCallBeforeBind).collect(Collectors.toList());
        Function binderFunction = this.neo4jMappingContext.getRequiredBinderFunctionFor(domainClass);
        List entityList = entitiesToBeSaved.stream().map(binderFunction).collect(Collectors.toList());
        ResultSummary resultSummary = ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOfMultipleInstancesOf(entityMetaData))).in(databaseName).bind(entityList).to("__entities__")).run();
        entitiesToBeSaved.forEach(entityToBeSaved -> this.processRelations(entityMetaData, entityToBeSaved, (Boolean)isNewIndicator.get(entitiesToBeSaved.indexOf(entityToBeSaved)), databaseName));
        SummaryCounters counters = resultSummary.counters();
        log.debug(() -> String.format("Created %d and deleted %d nodes, created %d and deleted %d relationships and set %d properties.", counters.nodesCreated(), counters.nodesDeleted(), counters.relationshipsCreated(), counters.relationshipsDeleted(), counters.propertiesSet()));
        return entitiesToBeSaved;
    }

    @Override
    public <T> void deleteById(Object id, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        String nameOfParameter = "id";
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter));
        log.debug(() -> String.format("Deleting entity with id %s ", id));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        ResultSummary summary = ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statement)).in(this.getDatabaseName()).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id)).to(nameOfParameter)).run();
        log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
    }

    @Override
    public <T> void deleteByIdWithVersion(Object id, Class<T> domainType, Neo4jPersistentProperty versionProperty, Object versionValue) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        String nameOfParameter = "id";
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter)).and(Cypher.property((Expression)Constants.NAME_OF_ROOT_NODE, (String)versionProperty.getPropertyName()).isEqualTo((Expression)Cypher.parameter((String)"__version__")).or(Cypher.property((Expression)Constants.NAME_OF_ROOT_NODE, (String)versionProperty.getPropertyName()).isNull()));
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, condition).returning(new Expression[]{Constants.NAME_OF_ROOT_NODE}).build();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(nameOfParameter, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id));
        parameters.put("__version__", versionValue);
        this.createExecutableQuery(domainType, statement, parameters).getSingleResult().orElseThrow(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
        this.deleteById(id, domainType);
    }

    @Override
    public <T> void deleteAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        String nameOfParameter = "ids";
        Condition condition = entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)nameOfParameter));
        log.debug(() -> String.format("Deleting all entities with the following ids: %s ", ids));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        ResultSummary summary = ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statement)).in(this.getDatabaseName()).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids)).to(nameOfParameter)).run();
        log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
    }

    @Override
    public void deleteAll(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(domainType);
        log.debug(() -> String.format("Deleting all nodes with primary label %s", entityMetaData.getPrimaryLabel()));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData);
        ResultSummary summary = this.neo4jClient.query(renderer.render(statement)).in(this.getDatabaseName()).run();
        log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, Statement statement) {
        return this.createExecutableQuery(domainType, statement, Collections.emptyMap());
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, String cypherStatement) {
        return this.createExecutableQuery(domainType, cypherStatement, Collections.emptyMap());
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, Statement statement, Map<String, Object> parameters) {
        return this.createExecutableQuery(domainType, renderer.render(statement), parameters);
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, String cypherStatement, Map<String, Object> parameters) {
        Assert.notNull((Object)this.neo4jMappingContext.getPersistentEntity(domainType), (String)"Cannot get or create persistent entity.");
        PreparedQuery<T> preparedQuery = PreparedQuery.queryFor(domainType).withCypherQuery(cypherStatement).withParameters(parameters).usingMappingFunction(this.neo4jMappingContext.getRequiredMappingFunctionFor(domainType)).build();
        return this.toExecutableQuery(preparedQuery);
    }

    private void processRelations(Neo4jPersistentEntity<?> neo4jPersistentEntity, Object parentObject, boolean isParentObjectNew, @Nullable String inDatabase) {
        this.processNestedRelations(neo4jPersistentEntity, parentObject, isParentObjectNew, inDatabase, new NestedRelationshipProcessingStateMachine());
    }

    private void processNestedRelations(Neo4jPersistentEntity<?> neo4jPersistentEntity, Object parentObject, boolean isParentObjectNew, @Nullable String inDatabase, NestedRelationshipProcessingStateMachine stateMachine) {
        PersistentPropertyAccessor propertyAccessor = neo4jPersistentEntity.getPropertyAccessor(parentObject);
        Object fromId = propertyAccessor.getProperty(neo4jPersistentEntity.getRequiredIdProperty());
        neo4jPersistentEntity.doWithAssociations(association -> {
            NestedRelationshipContext relationshipContext = NestedRelationshipContext.of((Association<Neo4jPersistentProperty>)association, propertyAccessor, neo4jPersistentEntity);
            Collection<?> relatedValuesToStore = MappingSupport.unifyRelationshipValue(relationshipContext.getInverse(), relationshipContext.getValue());
            RelationshipDescription relationshipDescription = relationshipContext.getRelationship();
            RelationshipDescription relationshipDescriptionObverse = relationshipDescription.getRelationshipObverse();
            NestedRelationshipProcessingStateMachine.ProcessState processState = stateMachine.getStateOf(relationshipDescriptionObverse, relatedValuesToStore);
            if (processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_RELATIONSHIPS) {
                return;
            }
            if (!isParentObjectNew) {
                Statement relationshipRemoveQuery = this.cypherGenerator.prepareDeleteOf(neo4jPersistentEntity, relationshipDescription);
                ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(relationshipRemoveQuery)).in(inDatabase).bind(this.convertIdValues((Neo4jPersistentProperty)neo4jPersistentEntity.getIdProperty(), fromId)).to("fromId")).run();
            }
            if (relationshipContext.inverseValueIsEmpty()) {
                return;
            }
            stateMachine.markAsProcessed(relationshipDescription, relatedValuesToStore);
            for (Object relatedValueToStore : relatedValuesToStore) {
                Object relatedNode = relationshipContext.identifyAndExtractRelationshipTargetNode(relatedValueToStore);
                Neo4jPersistentEntity targetNodeDescription = (Neo4jPersistentEntity)this.neo4jMappingContext.getPersistentEntity(relatedNode.getClass());
                boolean isEntityNew = targetNodeDescription.isNew(relatedNode);
                relatedNode = this.eventSupport.maybeCallBeforeBind(relatedNode);
                Long relatedInternalId = this.saveRelatedNode(relatedNode, relationshipContext.getAssociationTargetType(), targetNodeDescription, inDatabase);
                CreateRelationshipStatementHolder statementHolder = this.neo4jMappingContext.createStatement(neo4jPersistentEntity, relationshipContext, relatedInternalId, relatedValueToStore);
                ((Neo4jClient.RunnableSpecTightToDatabase)((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(renderer.render(statementHolder.getStatement())).in(inDatabase).bind(this.convertIdValues((Neo4jPersistentProperty)targetNodeDescription.getRequiredIdProperty(), fromId)).to("fromId")).bindAll(statementHolder.getProperties())).run();
                if (targetNodeDescription.isUsingInternalIds()) {
                    PersistentPropertyAccessor targetPropertyAccessor = targetNodeDescription.getPropertyAccessor(relatedNode);
                    targetPropertyAccessor.setProperty(targetNodeDescription.getRequiredIdProperty(), (Object)relatedInternalId);
                }
                if (processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_VALUES) continue;
                this.processNestedRelations(targetNodeDescription, relatedNode, isEntityNew, inDatabase, stateMachine);
            }
        });
    }

    private <Y> Long saveRelatedNode(Object entity, Class<Y> entityType, NodeDescription targetNodeDescription, @Nullable String inDatabase) {
        DynamicLabels dynamicLabels = this.determineDynamicLabels(entity, (Neo4jPersistentEntity)targetNodeDescription, inDatabase);
        Optional optionalSavedNodeId = ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(() -> renderer.render(this.cypherGenerator.prepareSaveOf(targetNodeDescription, dynamicLabels))).in(inDatabase).bind(entity).with(this.neo4jMappingContext.getRequiredBinderFunctionFor(entityType))).fetchAs(Long.class).one();
        if (((Neo4jPersistentEntity)targetNodeDescription).hasVersionProperty() && !optionalSavedNodeId.isPresent()) {
            throw new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE);
        }
        return (Long)optionalSavedNodeId.get();
    }

    private String getDatabaseName() {
        return this.databaseSelectionProvider.getDatabaseSelection().getValue();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.eventSupport = EventSupport.discoverCallbacks(this.neo4jMappingContext, beanFactory);
    }

    @Override
    public <T> Neo4jOperations.ExecutableQuery<T> toExecutableQuery(PreparedQuery<T> preparedQuery) {
        Neo4jClient.MappingSpec mappingSpec = ((Neo4jClient.RunnableSpecTightToDatabase)this.neo4jClient.query(preparedQuery.getCypherQuery()).in(this.getDatabaseName()).bindAll(preparedQuery.getParameters())).fetchAs(preparedQuery.getResultType());
        Neo4jClient.RecordFetchSpec fetchSpec = preparedQuery.getOptionalMappingFunction().map(f -> mappingSpec.mappedBy((BiFunction)f)).orElse(mappingSpec);
        return new DefaultExecutableQuery<T>(preparedQuery, fetchSpec);
    }

    final class DefaultExecutableQuery<T>
    implements Neo4jOperations.ExecutableQuery<T> {
        private final PreparedQuery<T> preparedQuery;
        private final Neo4jClient.RecordFetchSpec<T> fetchSpec;

        DefaultExecutableQuery(PreparedQuery<T> preparedQuery, Neo4jClient.RecordFetchSpec<T> fetchSpec) {
            this.preparedQuery = preparedQuery;
            this.fetchSpec = fetchSpec;
        }

        @Override
        public List<T> getResults() {
            Collection<T> all = this.fetchSpec.all();
            if (this.preparedQuery.resultsHaveBeenAggregated()) {
                return all.stream().flatMap(nested -> ((Collection)nested).stream()).distinct().collect(Collectors.toList());
            }
            return all.stream().collect(Collectors.toList());
        }

        @Override
        public Optional<T> getSingleResult() {
            try {
                return this.fetchSpec.one();
            }
            catch (NoSuchRecordException e) {
                throw new IncorrectResultSizeDataAccessException(e.getMessage(), 1);
            }
        }

        @Override
        public T getRequiredSingleResult() {
            return this.fetchSpec.one().orElseThrow(() -> new NoResultException(1, this.preparedQuery.getCypherQuery()));
        }
    }
}

