/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apiguardian.api.API;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0.2")
public final class Neo4jSpelSupport {
    public static String FUNCTION_LITERAL = "literal";
    public static String FUNCTION_ORDER_BY = "orderBy";

    public static LiteralReplacement orderBy(@Nullable Object arg) {
        Sort sort = null;
        if (arg instanceof Pageable) {
            sort = ((Pageable)arg).getSort();
        } else if (arg instanceof Sort) {
            sort = (Sort)arg;
        } else if (arg != null) {
            throw new IllegalArgumentException(arg.getClass() + " is not a valid order criteria.");
        }
        return StringBasedLiteralReplacement.withTargetAndValue(LiteralReplacement.Target.SORT, CypherGenerator.INSTANCE.createOrderByFragment(sort));
    }

    public static LiteralReplacement literal(@Nullable Object arg) {
        LiteralReplacement literalReplacement = StringBasedLiteralReplacement.withTargetAndValue(LiteralReplacement.Target.UNSPECIFIED, arg == null ? "" : arg.toString());
        return literalReplacement;
    }

    private static class StringBasedLiteralReplacement
    implements LiteralReplacement {
        private static final int DEFAULT_CACHE_SIZE = 16;
        private static final Map<String, LiteralReplacement> INSTANCES = new LinkedHashMap<String, LiteralReplacement>(16){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, LiteralReplacement> eldest) {
                return this.size() > 16;
            }
        };
        private final LiteralReplacement.Target target;
        private final String value;

        static LiteralReplacement withTargetAndValue(LiteralReplacement.Target target, @Nullable String value) {
            String valueUsed = value == null ? "" : value;
            StringBuilder key = new StringBuilder(target.name()).append("_").append(valueUsed);
            return INSTANCES.computeIfAbsent(key.toString(), k -> new StringBasedLiteralReplacement(target, valueUsed));
        }

        private StringBasedLiteralReplacement(LiteralReplacement.Target target, String value) {
            this.target = target;
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public LiteralReplacement.Target getTarget() {
            return this.target;
        }
    }

    static interface LiteralReplacement {
        public String getValue();

        public Target getTarget();

        public static enum Target {
            SORT,
            UNSPECIFIED;

        }
    }
}

