/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apiguardian.api.API;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
public final class NestedRelationshipContext {
    private final Neo4jPersistentProperty inverse;
    private final Object value;
    private final RelationshipDescription relationship;
    private final boolean inverseValueIsEmpty;

    private NestedRelationshipContext(Neo4jPersistentProperty inverse, @Nullable Object value, RelationshipDescription relationship, boolean inverseValueIsEmpty) {
        this.inverse = inverse;
        this.value = value;
        this.relationship = relationship;
        this.inverseValueIsEmpty = inverseValueIsEmpty;
    }

    public Neo4jPersistentProperty getInverse() {
        return this.inverse;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public RelationshipDescription getRelationship() {
        return this.relationship;
    }

    public boolean inverseValueIsEmpty() {
        return this.inverseValueIsEmpty;
    }

    boolean hasRelationshipWithProperties() {
        return this.relationship.hasRelationshipProperties();
    }

    public Object identifyAndExtractRelationshipTargetNode(Object relatedValue) {
        Object valueToBeSaved = relatedValue;
        if (relatedValue instanceof Map.Entry) {
            Map.Entry relatedValueMapEntry = (Map.Entry)relatedValue;
            if (this.hasRelationshipWithProperties()) {
                Object mapValue = ((Map.Entry)relatedValue).getValue();
                mapValue = mapValue instanceof List ? ((List)mapValue).get(0) : mapValue;
                valueToBeSaved = ((MappingSupport.RelationshipPropertiesWithEntityHolder)mapValue).getRelatedEntity();
            } else if (this.getInverse().isDynamicAssociation()) {
                valueToBeSaved = relatedValueMapEntry.getValue();
            }
        } else if (this.hasRelationshipWithProperties()) {
            valueToBeSaved = ((MappingSupport.RelationshipPropertiesWithEntityHolder)relatedValue).getRelatedEntity();
        }
        return valueToBeSaved;
    }

    @Nullable
    public PersistentPropertyAccessor<?> getRelationshipPropertiesPropertyAccessor(Object relatedValue) {
        if (!this.hasRelationshipWithProperties() || relatedValue == null) {
            return null;
        }
        if (relatedValue instanceof Map.Entry) {
            Object mapValue = ((Map.Entry)relatedValue).getValue();
            mapValue = mapValue instanceof List ? ((List)mapValue).get(0) : mapValue;
            return ((MappingSupport.RelationshipPropertiesWithEntityHolder)mapValue).getRelationshipPropertiesPropertyAccessor();
        }
        return ((MappingSupport.RelationshipPropertiesWithEntityHolder)relatedValue).getRelationshipPropertiesPropertyAccessor();
    }

    public static NestedRelationshipContext of(Association<Neo4jPersistentProperty> handler, PersistentPropertyAccessor<?> propertyAccessor, Neo4jPersistentEntity<?> neo4jPersistentEntity) {
        Neo4jPersistentProperty inverse = (Neo4jPersistentProperty)handler.getInverse();
        Cloneable value = propertyAccessor.getProperty((PersistentProperty)inverse);
        boolean inverseValueIsEmpty = value == null;
        RelationshipDescription relationship = neo4jPersistentEntity.getRelationshipsInHierarchy(s -> true).stream().filter(r -> r.getFieldName().equals(inverse.getName())).findFirst().get();
        if (relationship.hasRelationshipProperties() && value != null) {
            Neo4jPersistentEntity relationshipPropertiesEntity = (Neo4jPersistentEntity)relationship.getRelationshipPropertiesEntity();
            if (relationship.isDynamic()) {
                HashMap relationshipProperties = new HashMap();
                for (Map.Entry mapEntry : ((Map)((Object)value)).entrySet()) {
                    ArrayList<MappingSupport.RelationshipPropertiesWithEntityHolder> relationshipValues = new ArrayList<MappingSupport.RelationshipPropertiesWithEntityHolder>();
                    relationshipProperties.put(mapEntry.getKey(), relationshipValues);
                    Object mapEntryValue = mapEntry.getValue();
                    if (mapEntryValue instanceof List) {
                        for (Object relationshipProperty : (List)mapEntryValue) {
                            MappingSupport.RelationshipPropertiesWithEntityHolder oneOfThem = new MappingSupport.RelationshipPropertiesWithEntityHolder(relationshipPropertiesEntity, relationshipProperty, NestedRelationshipContext.getTargetNode(relationshipPropertiesEntity, relationshipProperty));
                            relationshipValues.add(oneOfThem);
                        }
                        continue;
                    }
                    MappingSupport.RelationshipPropertiesWithEntityHolder oneOfThem = new MappingSupport.RelationshipPropertiesWithEntityHolder(relationshipPropertiesEntity, mapEntryValue, NestedRelationshipContext.getTargetNode(relationshipPropertiesEntity, mapEntryValue));
                    relationshipValues.add(oneOfThem);
                }
                value = relationshipProperties;
            } else if (inverse.isCollectionLike()) {
                ArrayList<MappingSupport.RelationshipPropertiesWithEntityHolder> relationshipProperties = new ArrayList<MappingSupport.RelationshipPropertiesWithEntityHolder>();
                for (Object relationshipProperty : (Collection)((Object)value)) {
                    MappingSupport.RelationshipPropertiesWithEntityHolder oneOfThem = new MappingSupport.RelationshipPropertiesWithEntityHolder(relationshipPropertiesEntity, relationshipProperty, NestedRelationshipContext.getTargetNode(relationshipPropertiesEntity, relationshipProperty));
                    relationshipProperties.add(oneOfThem);
                }
                value = relationshipProperties;
            } else {
                value = new MappingSupport.RelationshipPropertiesWithEntityHolder(relationshipPropertiesEntity, value, NestedRelationshipContext.getTargetNode(relationshipPropertiesEntity, value));
            }
        }
        return new NestedRelationshipContext(inverse, value, relationship, inverseValueIsEmpty);
    }

    private static Object getTargetNode(Neo4jPersistentEntity<?> relationshipPropertiesEntity, Object object) {
        PersistentPropertyAccessor propertyAccessor = relationshipPropertiesEntity.getPropertyAccessor(object);
        return propertyAccessor.getProperty(relationshipPropertiesEntity.getPersistentProperty(TargetNode.class));
    }
}

