/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apiguardian.api.API;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;

@API(status=API.Status.INTERNAL, since="6.1.3")
public final class PropertyFilterSupport {
    public static List<PropertyPath> getInputProperties(ResultProcessor resultProcessor, ProjectionFactory factory, Neo4jMappingContext mappingContext) {
        ReturnedType returnedType = resultProcessor.getReturnedType();
        ArrayList<PropertyPath> filteredProperties = new ArrayList<PropertyPath>();
        boolean isProjecting = returnedType.isProjecting();
        boolean isClosedProjection = factory.getProjectionInformation(returnedType.getReturnedType()).isClosed();
        if (!isProjecting || !isClosedProjection) {
            return Collections.emptyList();
        }
        for (String inputProperty : returnedType.getInputProperties()) {
            PropertyFilterSupport.addPropertiesFrom(returnedType.getDomainType(), returnedType.getReturnedType(), factory, filteredProperties, inputProperty, mappingContext);
        }
        return filteredProperties;
    }

    static List<PropertyPath> addPropertiesFrom(Class<?> domainType, Class<?> returnType, ProjectionFactory projectionFactory, Neo4jMappingContext neo4jMappingContext) {
        ProjectionInformation projectionInformation = projectionFactory.getProjectionInformation(returnType);
        ArrayList<PropertyPath> propertyPaths = new ArrayList<PropertyPath>();
        for (PropertyDescriptor inputProperty : projectionInformation.getInputProperties()) {
            PropertyFilterSupport.addPropertiesFrom(domainType, returnType, projectionFactory, propertyPaths, inputProperty.getName(), neo4jMappingContext);
        }
        return propertyPaths;
    }

    private static void addPropertiesFrom(Class<?> domainType, Class<?> returnedType, ProjectionFactory factory, Collection<PropertyPath> filteredProperties, String inputProperty, Neo4jMappingContext mappingContext) {
        ProjectionInformation projectionInformation = factory.getProjectionInformation(returnedType);
        PropertyPath propertyPath = projectionInformation.isClosed() ? PropertyPath.from((String)inputProperty, returnedType) : PropertyPath.from((String)inputProperty, domainType);
        Class propertyType = propertyPath.getLeafType();
        if (mappingContext.getConversionService().isSimpleType(propertyType)) {
            filteredProperties.add(propertyPath);
        } else if (mappingContext.hasPersistentEntityFor(propertyType)) {
            if (propertyType.equals(domainType)) {
                return;
            }
            PropertyFilterSupport.addPropertiesFromEntity(filteredProperties, propertyPath, propertyType, mappingContext, new HashSet());
        } else {
            ProjectionInformation nestedProjectionInformation = factory.getProjectionInformation(propertyType);
            filteredProperties.add(propertyPath);
            if (nestedProjectionInformation.isClosed()) {
                for (PropertyDescriptor nestedInputProperty : nestedProjectionInformation.getInputProperties()) {
                    PropertyPath nestedPropertyPath = propertyPath.nested(nestedInputProperty.getName());
                    filteredProperties.add(nestedPropertyPath);
                    PropertyFilterSupport.addPropertiesFrom(domainType, returnedType, factory, filteredProperties, nestedPropertyPath.toDotPath(), mappingContext);
                }
            } else {
                PropertyFilterSupport.processEntity(domainType, filteredProperties, inputProperty, mappingContext);
            }
        }
    }

    private static void processEntity(Class<?> domainType, Collection<PropertyPath> filteredProperties, String inputProperty, Neo4jMappingContext mappingContext) {
        Neo4jPersistentEntity persistentEntity = (Neo4jPersistentEntity)mappingContext.getPersistentEntity(domainType);
        Neo4jPersistentProperty persistentProperty = (Neo4jPersistentProperty)persistentEntity.getPersistentProperty(inputProperty);
        Class propertyEntityType = persistentProperty.getActualType();
        PropertyPath propertyPath = PropertyPath.from((String)inputProperty, domainType);
        PropertyFilterSupport.addPropertiesFromEntity(filteredProperties, propertyPath, propertyEntityType, mappingContext, new HashSet());
    }

    private static void addPropertiesFromEntity(Collection<PropertyPath> filteredProperties, PropertyPath propertyPath, Class<?> propertyType, Neo4jMappingContext mappingContext, Collection<Neo4jPersistentEntity<?>> processedEntities) {
        Neo4jPersistentEntity persistentEntityFromProperty = (Neo4jPersistentEntity)mappingContext.getPersistentEntity(propertyType);
        if (PropertyFilterSupport.hasProcessedEntity(persistentEntityFromProperty, processedEntities)) {
            return;
        }
        processedEntities.add(persistentEntityFromProperty);
        Class pathRootType = propertyPath.getOwningType().getType();
        if (mappingContext.hasPersistentEntityFor(pathRootType)) {
            processedEntities.add((Neo4jPersistentEntity<?>)mappingContext.getPersistentEntity(pathRootType));
        }
        PropertyFilterSupport.takeAllPropertiesFromEntity(filteredProperties, propertyPath, mappingContext, persistentEntityFromProperty, processedEntities);
    }

    private static boolean hasProcessedEntity(Neo4jPersistentEntity<?> persistentEntityFromProperty, Collection<Neo4jPersistentEntity<?>> processedEntities) {
        return processedEntities.contains(persistentEntityFromProperty);
    }

    private static void takeAllPropertiesFromEntity(Collection<PropertyPath> filteredProperties, PropertyPath propertyPath, Neo4jMappingContext mappingContext, Neo4jPersistentEntity<?> persistentEntityFromProperty, Collection<Neo4jPersistentEntity<?>> processedEntities) {
        filteredProperties.add(propertyPath);
        persistentEntityFromProperty.doWithAll(neo4jPersistentProperty -> PropertyFilterSupport.addPropertiesFromEntity(filteredProperties, propertyPath.nested(neo4jPersistentProperty.getFieldName()), mappingContext, processedEntities));
    }

    private static void addPropertiesFromEntity(Collection<PropertyPath> filteredProperties, PropertyPath propertyPath, Neo4jMappingContext mappingContext, Collection<Neo4jPersistentEntity<?>> processedEntities) {
        if (filteredProperties.contains(propertyPath)) {
            return;
        }
        Class propertyType = propertyPath.getLeafType();
        if (mappingContext.getConversionService().isSimpleType(propertyType)) {
            filteredProperties.add(propertyPath);
        } else if (mappingContext.hasPersistentEntityFor(propertyType)) {
            PropertyFilterSupport.addPropertiesFromEntity(filteredProperties, propertyPath, propertyType, mappingContext, processedEntities);
        }
    }
}

