/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0.4")
public final class QueryFragments {
    private List<PatternElement> matchOn = new ArrayList<PatternElement>();
    private Condition condition;
    private Collection<Expression> returnExpressions = new ArrayList<Expression>();
    private Collection<SortItem> orderBy;
    private Number limit;
    private Long skip;
    private ReturnTuple returnTuple;
    private boolean scalarValueReturn = false;
    private boolean renderConstantsAsParameters = false;

    public void addMatchOn(PatternElement match) {
        this.matchOn.add(match);
    }

    public void setMatchOn(List<PatternElement> match) {
        this.matchOn = match;
    }

    public List<PatternElement> getMatchOn() {
        return this.matchOn;
    }

    public void setCondition(@Nullable Condition condition) {
        this.condition = Optional.ofNullable(condition).orElse(Conditions.noCondition());
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setReturnExpressions(Collection<Expression> expression) {
        this.returnExpressions = expression;
    }

    public void setReturnExpression(Expression returnExpression, boolean isScalarValue) {
        this.returnExpressions = Collections.singletonList(returnExpression);
        this.scalarValueReturn = isScalarValue;
    }

    public boolean includeField(PropertyFilter.RelaxedPropertyPath fieldName) {
        return this.returnTuple == null ? PropertyFilter.acceptAll().contains(fieldName.toDotPath(), fieldName.getType()) : this.returnTuple.filteredProperties.contains(fieldName.toDotPath(), fieldName.getType());
    }

    public void setOrderBy(Collection<SortItem> orderBy) {
        this.orderBy = orderBy;
    }

    public void setLimit(Number limit) {
        this.limit = limit;
    }

    public void setSkip(Long skip) {
        this.skip = skip;
    }

    public void setReturnBasedOn(NodeDescription<?> nodeDescription, List<PropertyPath> includedProperties, boolean isDistinct) {
        this.returnTuple = new ReturnTuple(nodeDescription, includedProperties, isDistinct);
    }

    public boolean isScalarValueReturn() {
        return this.scalarValueReturn;
    }

    public void setRenderConstantsAsParameters(boolean renderConstantsAsParameters) {
        this.renderConstantsAsParameters = renderConstantsAsParameters;
    }

    public Statement toStatement() {
        StatementBuilder.OngoingReadingWithoutWhere match = null;
        for (PatternElement patternElement : this.matchOn) {
            if (match == null) {
                match = Cypher.match((PatternElement[])new PatternElement[]{this.matchOn.get(0)});
                continue;
            }
            match = match.match(new PatternElement[]{patternElement});
        }
        StatementBuilder.OngoingReadingWithWhere matchWithWhere = match.where(this.condition);
        StatementBuilder.OngoingReadingAndReturn returnPart = this.isDistinctReturn() ? matchWithWhere.returningDistinct(this.getReturnExpressions()) : matchWithWhere.returning(this.getReturnExpressions());
        Statement statement = returnPart.orderBy(this.getOrderBy()).skip((Number)this.skip).limit(this.limit).build();
        statement.setRenderConstantsAsParameters(this.renderConstantsAsParameters);
        return statement;
    }

    private Collection<Expression> getReturnExpressions() {
        return this.returnExpressions.size() > 0 ? this.returnExpressions : CypherGenerator.INSTANCE.createReturnStatementForMatch((Neo4jPersistentEntity)this.returnTuple.nodeDescription, this::includeField);
    }

    private boolean isDistinctReturn() {
        return this.returnExpressions.isEmpty() && this.returnTuple.isDistinct;
    }

    public Collection<SortItem> getOrderBy() {
        return this.orderBy != null ? this.orderBy : Collections.emptySet();
    }

    public Number getLimit() {
        return this.limit;
    }

    public Long getSkip() {
        return this.skip;
    }

    static final class ReturnTuple {
        final NodeDescription<?> nodeDescription;
        final PropertyFilter filteredProperties;
        final boolean isDistinct;

        private ReturnTuple(NodeDescription<?> nodeDescription, List<PropertyPath> filteredProperties, boolean isDistinct) {
            this.nodeDescription = nodeDescription;
            this.filteredProperties = PropertyFilter.from(filteredProperties, nodeDescription);
            this.isDistinct = isDistinct;
        }
    }
}

