/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.0.2")
public final class Neo4jSpelSupport {
    public static String FUNCTION_LITERAL = "literal";
    public static String FUNCTION_ORDER_BY = "orderBy";
    private static final Pattern LABEL_AND_TYPE_QUOTATION = Pattern.compile("`");
    private static final String EXPRESSION_PARAMETER = "$1#{";
    private static final String QUOTED_EXPRESSION_PARAMETER = "$1__HASH__{";
    private static final String ENTITY_NAME = "staticLabels";
    private static final String ENTITY_NAME_VARIABLE = "#staticLabels";
    private static final String ENTITY_NAME_VARIABLE_EXPRESSION = "#{#staticLabels}";
    private static final Pattern EXPRESSION_PARAMETER_QUOTING = Pattern.compile("([:?])#\\{(?!#staticLabels)");
    private static final Pattern EXPRESSION_PARAMETER_UNQUOTING = Pattern.compile("([:?])__HASH__\\{");

    public static LiteralReplacement orderBy(@Nullable Object arg) {
        Sort sort = null;
        if (arg instanceof Pageable) {
            sort = ((Pageable)arg).getSort();
        } else if (arg instanceof Sort) {
            sort = (Sort)arg;
        } else if (arg != null) {
            throw new IllegalArgumentException(arg.getClass() + " is not a valid order criteria.");
        }
        return StringBasedLiteralReplacement.withTargetAndValue(LiteralReplacement.Target.SORT, CypherGenerator.INSTANCE.createOrderByFragment(sort));
    }

    public static LiteralReplacement literal(@Nullable Object arg) {
        LiteralReplacement literalReplacement = StringBasedLiteralReplacement.withTargetAndValue(LiteralReplacement.Target.UNSPECIFIED, arg == null ? "" : arg.toString());
        return literalReplacement;
    }

    public static String renderQueryIfExpressionOrReturnQuery(String query, Neo4jMappingContext mappingContext, EntityMetadata<?> metadata, SpelExpressionParser parser) {
        Assert.notNull((Object)query, (String)"query must not be null!");
        Assert.notNull(metadata, (String)"metadata must not be null!");
        Assert.notNull((Object)parser, (String)"parser must not be null!");
        if (!Neo4jSpelSupport.containsExpression(query)) {
            return query;
        }
        StandardEvaluationContext evalContext = new StandardEvaluationContext();
        Neo4jPersistentEntity requiredPersistentEntity = (Neo4jPersistentEntity)mappingContext.getRequiredPersistentEntity(metadata.getJavaType());
        evalContext.setVariable(ENTITY_NAME, (Object)requiredPersistentEntity.getStaticLabels().stream().map(l -> {
            Matcher matcher = LABEL_AND_TYPE_QUOTATION.matcher((CharSequence)l);
            return String.format(Locale.ENGLISH, "`%s`", matcher.replaceAll("``"));
        }).collect(Collectors.joining(":")));
        query = Neo4jSpelSupport.potentiallyQuoteExpressionsParameter(query);
        Expression expr = parser.parseExpression(query, ParserContext.TEMPLATE_EXPRESSION);
        String result = (String)expr.getValue((EvaluationContext)evalContext, String.class);
        if (result == null) {
            return query;
        }
        return Neo4jSpelSupport.potentiallyUnquoteParameterExpressions(result);
    }

    static String potentiallyUnquoteParameterExpressions(String result) {
        return EXPRESSION_PARAMETER_UNQUOTING.matcher(result).replaceAll(EXPRESSION_PARAMETER);
    }

    static String potentiallyQuoteExpressionsParameter(String query) {
        return EXPRESSION_PARAMETER_QUOTING.matcher(query).replaceAll(QUOTED_EXPRESSION_PARAMETER);
    }

    private static boolean containsExpression(String query) {
        return query.contains(ENTITY_NAME_VARIABLE_EXPRESSION);
    }

    private static class StringBasedLiteralReplacement
    implements LiteralReplacement {
        private static final int DEFAULT_CACHE_SIZE = 16;
        private static final Map<String, LiteralReplacement> INSTANCES = new LinkedHashMap<String, LiteralReplacement>(16){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, LiteralReplacement> eldest) {
                return this.size() > 16;
            }
        };
        private final LiteralReplacement.Target target;
        private final String value;

        static LiteralReplacement withTargetAndValue(LiteralReplacement.Target target, @Nullable String value) {
            String valueUsed = value == null ? "" : value;
            StringBuilder key = new StringBuilder(target.name()).append("_").append(valueUsed);
            return INSTANCES.computeIfAbsent(key.toString(), k -> new StringBasedLiteralReplacement(target, valueUsed));
        }

        private StringBasedLiteralReplacement(LiteralReplacement.Target target, String value) {
            this.target = target;
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public LiteralReplacement.Target getTarget() {
            return this.target;
        }
    }

    static interface LiteralReplacement {
        public String getValue();

        public Target getTarget();

        public static enum Target {
            SORT,
            UNSPECIFIED;

        }
    }
}

