/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.Arrays;
import java.util.Optional;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.SortItem;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.repository.query.CypherdslConditionExecutorImpl;
import org.springframework.data.neo4j.repository.support.CypherdslConditionExecutor;
import org.springframework.data.neo4j.repository.support.Neo4jEntityInformation;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

@API(status=API.Status.INTERNAL, since="6.1")
public final class QuerydslNeo4jPredicateExecutor<T>
implements QuerydslPredicateExecutor<T> {
    private final CypherdslConditionExecutor<T> delegate;

    public QuerydslNeo4jPredicateExecutor(Neo4jEntityInformation<T, Object> entityInformation, Neo4jOperations neo4jOperations) {
        this.delegate = new CypherdslConditionExecutorImpl<T>(entityInformation, neo4jOperations);
    }

    public Optional<T> findOne(Predicate predicate) {
        return this.delegate.findOne(Cypher.adapt((Object)predicate).asCondition());
    }

    public Iterable<T> findAll(Predicate predicate) {
        return this.delegate.findAll(Cypher.adapt((Object)predicate).asCondition());
    }

    public Iterable<T> findAll(Predicate predicate, Sort sort) {
        return this.delegate.findAll(Cypher.adapt((Object)predicate).asCondition(), sort);
    }

    public Iterable<T> findAll(Predicate predicate, OrderSpecifier<?> ... orderSpecifiers) {
        return this.delegate.findAll(Cypher.adapt((Object)predicate).asCondition(), this.toSortItems(orderSpecifiers));
    }

    public Iterable<T> findAll(OrderSpecifier<?> ... orderSpecifiers) {
        return this.delegate.findAll(this.toSortItems(orderSpecifiers));
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        return this.delegate.findAll(Cypher.adapt((Object)predicate).asCondition(), pageable);
    }

    public long count(Predicate predicate) {
        return this.delegate.count(Cypher.adapt((Object)predicate).asCondition());
    }

    private SortItem[] toSortItems(OrderSpecifier<?> ... orderSpecifiers) {
        return (SortItem[])Arrays.stream(orderSpecifiers).map(os -> Cypher.sort((Expression)Cypher.adapt((Object)os.getTarget()).asExpression(), (SortItem.Direction)(os.isAscending() ? SortItem.Direction.ASC : SortItem.Direction.DESC))).toArray(SortItem[]::new);
    }

    public boolean exists(Predicate predicate) {
        return this.findAll(predicate).iterator().hasNext();
    }
}

